import { useState, useEffect } from 'react';

export const usePDFLoader = () => {
    const [pdfJsLoaded, setPdfJsLoaded] = useState(false);
    const [jsPdfLoaded, setJsPdfLoaded] = useState(false);
    const [loadingError, setLoadingError] = useState(null);
    const [isClient, setIsClient] = useState(false);

    useEffect(() => {
        setIsClient(typeof window !== 'undefined');
    }, []);

    useEffect(() => {
        const loadPdfJs = async () => {
            if (!isClient) return;

            if (typeof window !== 'undefined' && !window.pdfjsLib) {
                try {
                    const script = document.createElement('script');
                    script.src = '/js/pdf.min.js';
                    script.onload = () => {
                        if (window.pdfjsLib) {
                            window.pdfjsLib.GlobalWorkerOptions.workerSrc = '/js/pdf.worker.min.js';
                            setPdfJsLoaded(true);
                            console.log('✅ PDF.js loaded successfully');
                        } else {
                            setLoadingError('Failed to initialize PDF.js');
                        }
                    };
                    script.onerror = () => {
                        setLoadingError('Failed to load PDF.js library');
                    };
                    document.head.appendChild(script);
                } catch (error) {
                    console.error('Error loading PDF.js:', error);
                    setLoadingError('Error loading PDF.js');
                }
            } else if (window.pdfjsLib) {
                setPdfJsLoaded(true);
                console.log('✅ PDF.js already loaded');
            }
        };

        loadPdfJs();
    }, [isClient]);

    useEffect(() => {
        const loadJsPDF = async () => {
            if (!isClient) return;

            if (typeof window !== 'undefined' && !window.jsPDF) {
                try {
                    const script = document.createElement('script');
                    script.src = '/js/jspdf.umd.min.js';
                    script.onload = () => {
                        setJsPdfLoaded(true);
                        console.log('✅ jsPDF loaded successfully');
                    };
                    script.onerror = () => {
                        setLoadingError('Failed to load jsPDF library');
                    };
                    document.head.appendChild(script);
                } catch (error) {
                    console.error('Error loading jsPDF:', error);
                    setLoadingError('Error loading jsPDF');
                }
            } else if (window.jsPDF) {
                setJsPdfLoaded(true);
                console.log('✅ jsPDF already loaded');
            }
        };

        loadJsPDF();
    }, [isClient]);

    return { pdfJsLoaded, jsPdfLoaded, loadingError, setLoadingError, isClient };
};
