import { getToken, setToken } from "@/hooks/auth";

export async function apiFetch(endpoint: string, options: RequestInit = {}) {
  const token = getToken();

  const defaultHeaders = {
    "Content-Type": "application/json",
    Authorization: token ? `Bearer ${token}` : ""
  };

  const response = await fetch(`/api/edge${endpoint}`, {
    ...options,
    headers: { ...defaultHeaders, ...options.headers },
  });

  if (!response.ok) {
    if (response.status === 401) {
      setToken();
    }
  }

  return response;
}
