var _excluded = ["destinationId", "fallbackDestination", "overrideLinkBehavior", "tabIndex", "position", "children", "className", "onClick"];
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { useCallback } from 'react';
import PropTypes from "prop-types";
import classNames from 'classnames';
import { isTabbable } from 'tabbable';
import { useEuiMemoizedStyles } from '../../../services';
import { EuiButton } from '../../button/button';
import { EuiScreenReaderOnly } from '../screen_reader_only';
import { euiSkipLinkStyles } from './skip_link.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var POSITIONS = ['static', 'fixed', 'absolute'];
export var EuiSkipLink = function EuiSkipLink(_ref) {
  var destinationId = _ref.destinationId,
    _ref$fallbackDestinat = _ref.fallbackDestination,
    fallbackDestination = _ref$fallbackDestinat === void 0 ? 'main' : _ref$fallbackDestinat,
    overrideLinkBehavior = _ref.overrideLinkBehavior,
    tabIndex = _ref.tabIndex,
    _ref$position = _ref.position,
    position = _ref$position === void 0 ? 'static' : _ref$position,
    children = _ref.children,
    className = _ref.className,
    _onClick = _ref.onClick,
    rest = _objectWithoutProperties(_ref, _excluded);
  var classes = classNames('euiSkipLink', className);
  var styles = useEuiMemoizedStyles(euiSkipLinkStyles);
  var cssStyles = [styles.euiSkipLink, position !== 'static' ? styles[position] : undefined];
  var onClick = useCallback(function (e) {
    var destinationEl = null;
    // Check if the destination ID is valid
    destinationEl = document.getElementById(destinationId);
    var hasValidId = !!destinationEl;
    // Check the fallback destination if not
    if (!destinationEl && fallbackDestination) {
      if (Array.isArray(fallbackDestination)) {
        for (var i = 0; i < fallbackDestination.length; i++) {
          destinationEl = document.querySelector(fallbackDestination[i]);
          if (destinationEl) break; // Stop once the first fallback has been found
        }
      } else {
        destinationEl = document.querySelector(fallbackDestination);
      }
    }
    if ((overrideLinkBehavior || !hasValidId) && destinationEl) {
      e.preventDefault();

      // Scroll to the top of the destination content only if it's ~mostly out of view
      var destinationY = destinationEl.getBoundingClientRect().top;
      var halfOfViewportHeight = window.innerHeight / 2;
      if (destinationY >= halfOfViewportHeight || window.scrollY >= destinationY + halfOfViewportHeight) {
        destinationEl.scrollIntoView();
      }

      // Ensure the destination content is focusable
      if (!isTabbable(destinationEl)) {
        destinationEl.tabIndex = -1;
        destinationEl.addEventListener('blur', function () {
          var _destinationEl;
          return (_destinationEl = destinationEl) === null || _destinationEl === void 0 ? void 0 : _destinationEl.removeAttribute('tabindex');
        }, {
          once: true
        });
      }
      destinationEl.focus({
        preventScroll: true
      }); // Scrolling is already handled above, and focus autoscroll behaves oddly on Chrome around fixed headers
    }
    _onClick === null || _onClick === void 0 || _onClick(e);
  }, [overrideLinkBehavior, destinationId, fallbackDestination, _onClick]);
  return ___EmotionJSX(EuiScreenReaderOnly, {
    showOnFocus: true
  }, ___EmotionJSX(EuiButton, _extends({
    css: cssStyles,
    className: classes,
    tabIndex: position === 'fixed' ? 0 : tabIndex,
    size: "s",
    fill: true,
    href: "#".concat(destinationId),
    onClick: onClick
  }, rest), children));
};
EuiSkipLink.propTypes = {
  href: PropTypes.string,
  onClick: PropTypes.func,
  /**
     * Change the display position of the element when focused.
     * If 'fixed', the link will be fixed to the top left of the viewport
     */
  position: PropTypes.any,
  /**
     * Typically an anchor id (e.g. `a11yMainContent`), the value provided
     * will be prepended with a hash `#` and used as the link `href`
     */
  destinationId: PropTypes.string.isRequired,
  /**
     * If no destination ID element exists or can be found, you may provide a query selector
     * string to fall back to.
     *
     * For complex applications with potentially variable layouts per page, an array of
     * query selectors can be passed, e.g. `['main', '[role=main]', '.appWrapper']`, which
     * prioritizes looking for multiple fallbacks based on array order.
     * @default main
     */
  fallbackDestination: PropTypes.oneOfType([PropTypes.string.isRequired, PropTypes.arrayOf(PropTypes.string.isRequired).isRequired]),
  /**
     * If default HTML anchor link behavior is not desired (e.g. for SPAs with hash routing),
     * setting this flag to true will manually scroll to and focus the destination element
     * without changing the browser URL's hash
     */
  overrideLinkBehavior: PropTypes.bool,
  /**
     * When position is fixed, this is forced to `0`
     */
  tabIndex: PropTypes.number,
  children: PropTypes.node,
  /**
     * Make button a solid color for prominence
     */
  fill: PropTypes.bool,
  /**
     * Any of the named color palette options.
     */
  color: PropTypes.any,
  /**
     * Use size `s` in confined spaces
     */
  size: PropTypes.any,
  /**
     * `disabled` is also allowed
     */
  isDisabled: PropTypes.bool,
  className: PropTypes.string,
  "aria-label": PropTypes.string,
  "data-test-subj": PropTypes.string,
  css: PropTypes.any,
  buttonRef: PropTypes.any
};