var _excluded = ["role", "children", "paddingSize", "isLoading", "isLoadingMessage", "isOpen"];
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t.return && (u = t.return(), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { useCallback, useMemo, useState } from 'react';
import PropTypes from "prop-types";
import classNames from 'classnames';
import { useEuiTheme } from '../../../services';
import { EuiResizeObserver } from '../../observer/resize_observer';
import { EuiAccordionChildrenLoading } from './accordion_children_loading';
import { euiAccordionChildrenStyles, euiAccordionChildWrapperStyles } from './accordion_children.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiAccordionChildren = function EuiAccordionChildren(_ref) {
  var role = _ref.role,
    children = _ref.children,
    paddingSize = _ref.paddingSize,
    isLoading = _ref.isLoading,
    isLoadingMessage = _ref.isLoadingMessage,
    isOpen = _ref.isOpen,
    rest = _objectWithoutProperties(_ref, _excluded);
  /**
   * Children
   */
  var classes = classNames('euiAccordion__children', {
    'euiAccordion__children-isLoading': isLoading
  });
  var euiTheme = useEuiTheme();
  var styles = euiAccordionChildrenStyles(euiTheme);
  var cssStyles = [styles.euiAccordion__children, isLoading && styles.isLoading, paddingSize && paddingSize !== 'none' && styles[paddingSize]];

  /**
   * Wrapper
   */
  var wrapperStyles = euiAccordionChildWrapperStyles(euiTheme);
  var wrapperCssStyles = [wrapperStyles.euiAccordion__childWrapper, isOpen ? wrapperStyles.isOpen : wrapperStyles.isClosed];

  /**
   * Update the accordion wrapper height whenever the accordion opens, and also
   * whenever the child content updates (which will change the height)
   */
  var _useState = useState(0),
    _useState2 = _slicedToArray(_useState, 2),
    contentHeight = _useState2[0],
    setContentHeight = _useState2[1];
  var onResize = useCallback(function (_ref2) {
    var height = _ref2.height;
    return setContentHeight(Math.round(height));
  }, []);
  var heightInlineStyle = useMemo(function () {
    return {
      blockSize: isOpen ? contentHeight : 0
    };
  }, [isOpen, contentHeight]);
  return ___EmotionJSX("div", _extends({}, rest, {
    className: "euiAccordion__childWrapper",
    css: wrapperCssStyles,
    style: heightInlineStyle,
    role: role
    // @ts-expect-error - inert property not yet available in React TS defs. TODO: Remove this once https://github.com/DefinitelyTyped/DefinitelyTyped/pull/60822 is merged
    ,
    inert: !isOpen ? '' : undefined // Can't pass a boolean currently, Jest throws errors
  }), ___EmotionJSX(EuiResizeObserver, {
    onResize: onResize
  }, function (resizeRef) {
    return ___EmotionJSX("div", {
      ref: resizeRef,
      className: classes,
      css: cssStyles
    }, isLoading && isLoadingMessage ? ___EmotionJSX(EuiAccordionChildrenLoading, {
      isLoadingMessage: isLoadingMessage
    }) : children);
  }));
};
EuiAccordionChildren.propTypes = {
  isOpen: PropTypes.bool.isRequired
};