var _excluded = ["arrowDisplay", "arrowProps", "isOpen"];
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React from 'react';
import PropTypes from "prop-types";
import classNames from 'classnames';
import { useEuiTheme } from '../../../services';
import { EuiButtonIcon } from '../../button';
import { euiAccordionArrowStyles } from './accordion_arrow.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiAccordionArrow = function EuiAccordionArrow(_ref) {
  var _ref$arrowDisplay = _ref.arrowDisplay,
    arrowDisplay = _ref$arrowDisplay === void 0 ? 'left' : _ref$arrowDisplay,
    arrowProps = _ref.arrowProps,
    isOpen = _ref.isOpen,
    rest = _objectWithoutProperties(_ref, _excluded);
  var euiTheme = useEuiTheme();
  if (arrowDisplay === 'none') return null;
  var styles = euiAccordionArrowStyles(euiTheme);
  var cssStyles = [styles.euiAccordion__arrow, styles[arrowDisplay], isOpen ? styles.isOpen : styles.isClosed, arrowProps === null || arrowProps === void 0 ? void 0 : arrowProps.css];
  var classes = classNames('euiAccordion__arrow', arrowProps === null || arrowProps === void 0 ? void 0 : arrowProps.className);
  return ___EmotionJSX(EuiButtonIcon, _extends({
    color: "text"
  }, arrowProps, rest, {
    className: classes,
    css: cssStyles,
    iconType: "arrowRight"
  }));
};
EuiAccordionArrow.propTypes = {
  isOpen: PropTypes.bool.isRequired
};