/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import { css } from '@emotion/react';
import { euiFontSize, logicalCSS, logicalTextAlignCSS } from '../../../global_styling';
export var euiAccordionButtonStyles = function euiAccordionButtonStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  return {
    euiAccordion__button: /*#__PURE__*/css(euiFontSize(euiThemeContext, 's'), " align-items:center;display:flex;flex-grow:1;line-height:", euiTheme.size.l, ";", logicalTextAlignCSS('left'), " ", logicalCSS('width', '100%'), " &:hover,&:focus{cursor:pointer;text-decoration:underline;};label:euiAccordion__button;"),
    // Triggering button needs separate `disabled` key because the element that renders may not support `:disabled`;
    // Hover pseudo selector for specificity
    disabled: /*#__PURE__*/css("&,&:hover{cursor:not-allowed;color:", euiTheme.colors.disabledText, ";text-decoration:none;};label:disabled;"),
    // Optional padding sizes
    s: /*#__PURE__*/css("padding:", euiTheme.size.s, ";;label:s;"),
    m: /*#__PURE__*/css("padding:", euiTheme.size.base, ";;label:m;"),
    l: /*#__PURE__*/css("padding:", euiTheme.size.l, ";;label:l;"),
    // Remove padding from the accordion button on the side that the arrow is on
    arrowLeft: /*#__PURE__*/css(logicalCSS('padding-left', 0), ";;label:arrowLeft;"),
    arrowRight: /*#__PURE__*/css(logicalCSS('padding-right', 0), ";;label:arrowRight;")
  };
};