function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import { css } from '@emotion/react';
import { euiFontSize, euiFocusRing, euiTextTruncate, logicalCSS, logicalShorthandCSS, logicalTextAlignCSS, mathWithUnits } from '../../global_styling';
import { transparentize } from '../../services';
import { euiBadgeColors } from './color_utils';
var _ref = process.env.NODE_ENV === "production" ? {
  name: "1hw5vc4-clickable",
  styles: "cursor:pointer;label:clickable;"
} : {
  name: "1hw5vc4-clickable",
  styles: "cursor:pointer;label:clickable;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
export var euiBadgeStyles = function euiBadgeStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  var badgeColors = euiBadgeColors(euiThemeContext);
  var setBadgeColorVars = function setBadgeColorVars(colors) {
    return "\n    --euiBadgeTextColor: ".concat(colors.color, ";\n    --euiBadgeBackgroundColor: ").concat(colors.backgroundColor, ";\n  ");
  };
  return {
    euiBadge: /*#__PURE__*/css("display:inline-block;vertical-align:middle;", logicalShorthandCSS('padding', "0 ".concat(euiTheme.size.s)), " ", logicalCSS('max-width', '100%'), " font-size:", euiFontSize(euiThemeContext, 'xs').fontSize, ";line-height:", mathWithUnits(
    // Account for the border
    [euiTheme.size.base, euiTheme.border.width.thin], function (x, y) {
      return x + y * 2;
    }), ";font-weight:", euiTheme.font.weight.medium, ";white-space:nowrap;text-decoration:none;cursor:default;border:", euiTheme.border.width.thin, " solid transparent;border-radius:", mathWithUnits(euiTheme.border.radius.medium, function (x) {
      return x / 2;
    }), ";", logicalTextAlignCSS('left'), "color:var(--euiBadgeTextColor, ", badgeColors.default.color, ");background-color:var(\n        --euiBadgeBackgroundColor,\n        ", badgeColors.default.backgroundColor, "\n      );*::selection{color:var(\n          --euiBadgeBackgroundColor,\n          ", badgeColors.default.backgroundColor, "\n        );background-color:var(\n          --euiBadgeTextColor,\n          ", badgeColors.default.color, "\n        );}&:focus-within{", euiFocusRing(euiThemeContext), ";}&+.euiBadge{", logicalCSS('margin-left', euiTheme.size.xs), ";};label:euiBadge;"),
    clickable: /*#__PURE__*/css("&:not(:disabled){&:hover,&:focus{text-decoration:underline;}}&:focus{", euiFocusRing(euiThemeContext), ";}&:disabled{cursor:not-allowed;};label:clickable;"),
    // Colors
    default: /*#__PURE__*/css(setBadgeColorVars(badgeColors.default), ";label:default;"),
    hollow: /*#__PURE__*/css(setBadgeColorVars(badgeColors.hollow), " border-color:", badgeColors.hollow.borderColor, ";;label:hollow;"),
    primary: /*#__PURE__*/css(setBadgeColorVars(badgeColors.primary), ";label:primary;"),
    accent: /*#__PURE__*/css(setBadgeColorVars(badgeColors.accent), ";label:accent;"),
    warning: /*#__PURE__*/css(setBadgeColorVars(badgeColors.warning), ";label:warning;"),
    danger: /*#__PURE__*/css(setBadgeColorVars(badgeColors.danger), ";label:danger;"),
    success: /*#__PURE__*/css(setBadgeColorVars(badgeColors.success), ";label:success;"),
    disabled: /*#__PURE__*/css(setBadgeColorVars(badgeColors.disabled), "*::selection{color:", euiTheme.colors.emptyShade, ";};label:disabled;"),
    // Content wrapper
    euiBadge__content: /*#__PURE__*/css(logicalCSS(
    // Ensure proper height in case of just displaying an icon
    'min-height', "".concat(mathWithUnits(euiTheme.border.width.thin, function (x) {
      return euiTheme.base + x * 2;
    }))), " display:flex;align-items:center;overflow:hidden;;label:euiBadge__content;"),
    // Text
    text: {
      euiBadge__text: /*#__PURE__*/css(euiTextTruncate(), " cursor:inherit;;label:euiBadge__text;"),
      clickable: _ref
    },
    // Icon
    icon: {
      euiBadge__icon: /*#__PURE__*/css(";label:euiBadge__icon;"),
      right: /*#__PURE__*/css("&:not(:only-child){", logicalCSS('margin-left', euiTheme.size.xs), ";};label:right;"),
      left: /*#__PURE__*/css("&:not(:only-child){", logicalCSS('margin-right', euiTheme.size.xs), ";};label:left;")
    },
    // Clickable icons (iconOnClick)
    iconButton: {
      euiBadge__iconButton: /*#__PURE__*/css("font-size:0;&:focus{background-color:", transparentize(euiTheme.colors.ghost, 0.8), ";color:", euiTheme.colors.ink, ";border-radius:", mathWithUnits(euiTheme.border.radius.small, function (x) {
        return x / 2;
      }), ";}&:disabled{cursor:not-allowed;}.euiBadge__icon{margin:0!important;};label:euiBadge__iconButton;"),
      right: /*#__PURE__*/css(logicalCSS('margin-left', euiTheme.size.xs), ";;label:right;"),
      left: /*#__PURE__*/css(logicalCSS('margin-right', euiTheme.size.xs), ";;label:left;")
    },
    // Used in badges with both onClick & iconOnClick
    euiBadge__childButton: /*#__PURE__*/css(euiTextTruncate(), " text-align:inherit;font-weight:inherit;line-height:inherit;color:inherit;&:disabled{cursor:not-allowed;}&:not(:disabled){&:hover,&:focus{text-decoration:underline;}};label:euiBadge__childButton;")
  };
};