var _excluded = ["children", "className", "gutterSize"];
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { forwardRef } from 'react';
import PropTypes from "prop-types";
import classNames from 'classnames';
import { useEuiMemoizedStyles } from '../../../services';
import { euiBadgeGroupStyles } from './badge_group.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var GUTTER_SIZES = ['none', 'xs', 's'];
export var EuiBadgeGroup = /*#__PURE__*/forwardRef(function (_ref, ref) {
  var children = _ref.children,
    className = _ref.className,
    _ref$gutterSize = _ref.gutterSize,
    gutterSize = _ref$gutterSize === void 0 ? 'xs' : _ref$gutterSize,
    rest = _objectWithoutProperties(_ref, _excluded);
  var classes = classNames('euiBadgeGroup', className);
  var styles = useEuiMemoizedStyles(euiBadgeGroupStyles);
  var cssStyles = [styles.euiBadgeGroup, styles[gutterSize]];
  return ___EmotionJSX("div", _extends({
    css: cssStyles,
    className: classes,
    ref: ref
  }, rest), children);
});
EuiBadgeGroup.propTypes = {
  className: PropTypes.string,
  "aria-label": PropTypes.string,
  "data-test-subj": PropTypes.string,
  css: PropTypes.any,
  /**
     * Space between badges
     */
  gutterSize: PropTypes.any,
  /**
     * Should be a list of `EuiBadge`s, but can also be any other element
     */
  children: PropTypes.node
};
EuiBadgeGroup.displayName = 'EuiBadgeGroup';