function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import { css } from '@emotion/react';
import { logicalCSS, euiFocusRing, euiFontSizeFromScale, euiTextTruncate, mathWithUnits } from '../../../global_styling';
import { euiBadgeColors } from '../color_utils';
var _ref = process.env.NODE_ENV === "production" ? {
  name: "l1nme7-middle",
  styles: "vertical-align:middle;label:middle;"
} : {
  name: "l1nme7-middle",
  styles: "vertical-align:middle;label:middle;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var _ref2 = process.env.NODE_ENV === "production" ? {
  name: "19hexhy-baseline",
  styles: "vertical-align:baseline;label:baseline;"
} : {
  name: "19hexhy-baseline",
  styles: "vertical-align:baseline;label:baseline;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var _ref3 = process.env.NODE_ENV === "production" ? {
  name: "pzpqqg-euiBetaBadge__icon",
  styles: "position:relative;transform:translate(0, -1px);label:euiBetaBadge__icon;"
} : {
  name: "pzpqqg-euiBetaBadge__icon",
  styles: "position:relative;transform:translate(0, -1px);label:euiBetaBadge__icon;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
export var euiBetaBadgeStyles = function euiBetaBadgeStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme,
    colorMode = euiThemeContext.colorMode;
  var badgeColors = euiBadgeColors(euiThemeContext);
  return {
    euiBetaBadge: /*#__PURE__*/css("display:inline-block;border-radius:", euiTheme.size.l, ";cursor:default;font-weight:", euiTheme.font.weight.bold, ";text-transform:uppercase;letter-spacing:0.05em;text-align:center;", euiTextTruncate(), " &:focus{", euiFocusRing(euiThemeContext, 'outset', {
      color: colorMode === 'DARK' ? euiTheme.colors.ghost : euiTheme.colors.ink
    }), ";};label:euiBetaBadge;"),
    // Colors
    accent: /*#__PURE__*/css(badgeColors.accentText, ";label:accent;"),
    subdued: /*#__PURE__*/css(badgeColors.subdued, ";label:subdued;"),
    hollow: /*#__PURE__*/css("color:", badgeColors.hollow.color, ";background-color:", badgeColors.hollow.backgroundColor, ";box-shadow:inset 0 0 0 ", euiTheme.border.width.thin, " ", badgeColors.hollow.borderColor, ";;label:hollow;"),
    warning: /*#__PURE__*/css(badgeColors.warning, ";label:warning;"),
    // Font sizes
    m: /*#__PURE__*/css("font-size:", euiFontSizeFromScale('xs', euiTheme), ";line-height:", euiTheme.size.l, ";;label:m;"),
    s: /*#__PURE__*/css("font-size:0.625rem;line-height:", mathWithUnits(euiTheme.size.xs, function (x) {
      return x + euiTheme.base;
    }), ";;label:s;"),
    // Padding/width sizes
    badgeSizes: {
      default: {
        m: "\n        ".concat(logicalCSS('padding-horizontal', euiTheme.size.base)),
        s: "\n        ".concat(logicalCSS('padding-horizontal', euiTheme.size.m))
      },
      // When it's just an icon or a single letter, make the badge a circle
      circle: {
        m: "\n          ".concat(logicalCSS('width', euiTheme.size.l), "\n        "),
        s: "\n          ".concat(logicalCSS('width', mathWithUnits(euiTheme.size.xs, function (x) {
          return x + euiTheme.base;
        })), "\n        ")
      }
    },
    euiBetaBadge__icon: _ref3,
    // Alignments
    baseline: _ref2,
    middle: _ref
  };
};