var _excluded = ["children", "className", "size", "color"];
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React from 'react';
import PropTypes from "prop-types";
import classNames from 'classnames';
import { useEuiMemoizedStyles } from '../../../services';
import { euiNotificationBadgeStyles } from './badge_notification.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var COLORS = ['accent', 'subdued', 'success'];
export var SIZES = ['s', 'm'];
export var EuiNotificationBadge = function EuiNotificationBadge(_ref) {
  var children = _ref.children,
    className = _ref.className,
    _ref$size = _ref.size,
    size = _ref$size === void 0 ? 's' : _ref$size,
    _ref$color = _ref.color,
    color = _ref$color === void 0 ? 'accent' : _ref$color,
    rest = _objectWithoutProperties(_ref, _excluded);
  var classes = classNames('euiNotificationBadge', className);
  var styles = useEuiMemoizedStyles(euiNotificationBadgeStyles);
  var cssStyles = [styles.euiNotificationBadge, styles[size], styles[color]];
  return ___EmotionJSX("span", _extends({
    css: cssStyles,
    className: classes
  }, rest), children);
};
EuiNotificationBadge.propTypes = {
  /**
     * ReactNode to render as this component's content
     */
  children: PropTypes.node.isRequired,
  size: PropTypes.any,
  color: PropTypes.any,
  className: PropTypes.string,
  "aria-label": PropTypes.string,
  "data-test-subj": PropTypes.string,
  css: PropTypes.any
};