function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t.return && (u = t.return(), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { useState, useCallback, useMemo } from 'react';
import { EuiContextMenuItem, EuiContextMenuPanel } from '../context_menu';
import { EuiPopover } from '../popover';
import { EuiButtonIcon } from '../button';
import { EuiToolTip } from '../tool_tip';
import { useEuiI18n } from '../i18n';
import { isCustomItemAction, callWithItemIfFunction } from './action_types';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var CollapsedItemActions = function CollapsedItemActions(_ref) {
  var actions = _ref.actions,
    itemId = _ref.itemId,
    item = _ref.item,
    actionsDisabled = _ref.actionsDisabled,
    displayedRowIndex = _ref.displayedRowIndex,
    className = _ref.className;
  var _useState = useState(false),
    _useState2 = _slicedToArray(_useState, 2),
    popoverOpen = _useState2[0],
    setPopoverOpen = _useState2[1];
  var closePopover = useCallback(function () {
    return setPopoverOpen(false);
  }, []);
  var allActionsTooltip = useEuiI18n('euiCollapsedItemActions.allActionsTooltip', 'All actions');
  var allActionsButtonAriaLabel = useEuiI18n('euiCollapsedItemActions.allActions', 'All actions, row {index}', {
    index: displayedRowIndex + 1
  });
  var allActionsButtonDisabledAriaLabel = useEuiI18n('euiCollapsedItemActions.allActionsDisabled', 'Individual item actions are disabled when rows are being selected.');
  var controls = useMemo(function () {
    return actions.reduce(function (controls, action, index) {
      var _action$available, _action$available2;
      var available = (_action$available = (_action$available2 = action.available) === null || _action$available2 === void 0 ? void 0 : _action$available2.call(action, item)) !== null && _action$available !== void 0 ? _action$available : true;
      if (!available) return controls;
      var enabled = action.enabled == null || action.enabled(item);
      if (isCustomItemAction(action)) {
        var customAction = action;
        var actionControl = customAction.render(item, enabled);
        controls.push(
        // Do not put the `onClick` on the EuiContextMenuItem itself - otherwise
        // it renders a <button> tag instead of a <div>, and we end up with nested
        // interactive elements
        ___EmotionJSX(EuiContextMenuItem, {
          key: index,
          className: "euiBasicTable__collapsedCustomAction"
        }, ___EmotionJSX("span", {
          onClick: closePopover
        }, actionControl)));
      } else {
        var icon = action.icon ? callWithItemIfFunction(item)(action.icon) : undefined;
        var buttonContent = callWithItemIfFunction(item)(action.name);
        var toolTipContent = callWithItemIfFunction(item)(action.description);
        var href = callWithItemIfFunction(item)(action.href);
        var dataTestSubj = callWithItemIfFunction(item)(action['data-test-subj']);
        var _onClick = action.onClick,
          target = action.target;
        controls.push(___EmotionJSX(EuiContextMenuItem, {
          key: index,
          className: "euiBasicTable__collapsedAction",
          disabled: !enabled && !actionsDisabled,
          href: href,
          target: target,
          icon: icon,
          "data-test-subj": dataTestSubj,
          onClick: function onClick(event) {
            event.persist();
            _onClick === null || _onClick === void 0 || _onClick(item, event);
            // Allow consumer events to prevent the popover from closing if necessary
            if (!event.isPropagationStopped()) closePopover();
          },
          toolTipContent: toolTipContent,
          toolTipProps: {
            delay: 'long'
          }
        }, buttonContent));
      }
      return controls;
    }, []);
  }, [actions, actionsDisabled, item, closePopover]);
  var popoverButton = ___EmotionJSX(EuiButtonIcon, {
    className: className,
    "aria-label": actionsDisabled ? allActionsButtonDisabledAriaLabel : allActionsButtonAriaLabel,
    title: actionsDisabled ? allActionsButtonDisabledAriaLabel : undefined,
    iconType: "boxesHorizontal",
    color: "text",
    isDisabled: actionsDisabled,
    onClick: function onClick() {
      return setPopoverOpen(function (isOpen) {
        return !isOpen;
      });
    },
    "data-test-subj": "euiCollapsedItemActionsButton"
  });
  var withTooltip = !actionsDisabled && ___EmotionJSX(EuiToolTip, {
    content: allActionsTooltip,
    delay: "long"
  }, popoverButton);
  return ___EmotionJSX(EuiPopover, {
    className: className,
    id: "".concat(itemId, "-actions"),
    isOpen: popoverOpen,
    button: withTooltip || popoverButton,
    closePopover: closePopover,
    panelPaddingSize: "none",
    anchorPosition: "leftCenter"
  }, ___EmotionJSX(EuiContextMenuPanel, {
    className: "euiBasicTable__collapsedActions",
    items: controls
  }));
};