var _excluded = ["schema"],
  _excluded2 = ["onChange"],
  _excluded3 = ["columns", "loading", "message", "error", "selection", "compressed", "pagination", "sorting", "itemIdToExpandedRowMap", "itemId", "rowProps", "cellProps", "tableLayout", "items", "search", "searchFormat", "onTableChange", "executeQueryOptions", "allowNeutralSort", "childrenBetween"];
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
import PropTypes from "prop-types";
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { Component } from 'react';
import { EuiBasicTable } from './basic_table';
import { isString } from '../../services/predicate';
import { Comparators } from '../../services/sort';
import { EuiSearchBar } from '../search_bar/search_bar';
import { EuiSearchBox } from '../search_bar/search_box';
import { EuiSpacer } from '../spacer';
import { euiTablePaginationDefaults } from '../table/table_pagination';
import { EuiComponentDefaultsContext } from '../provider/component_defaults';
import { jsx as ___EmotionJSX } from "@emotion/react";
function isEuiSearchBarProps(x) {
  return typeof x !== 'boolean';
}
var getQueryFromSearch = function getQueryFromSearch(search, defaultQuery) {
  var query;
  if (!search) {
    query = '';
  } else {
    query = (defaultQuery ? search.defaultQuery || search.query || '' : search.query) || '';
  }
  return isString(query) ? EuiSearchBar.Query.parse(query) : query;
};
var getInitialPagination = function getInitialPagination(pagination, consumerDefaults) {
  var _ref2, _pagination$pageIndex, _ref3, _pagination$pageSize;
  if (!pagination) {
    return {
      pageIndex: undefined,
      pageSize: undefined
    };
  }
  var defaults = _objectSpread(_objectSpread({}, euiTablePaginationDefaults), consumerDefaults);
  var _ref = pagination,
    _ref$pageSizeOptions = _ref.pageSizeOptions,
    pageSizeOptions = _ref$pageSizeOptions === void 0 ? defaults.itemsPerPageOptions : _ref$pageSizeOptions,
    _ref$showPerPageOptio = _ref.showPerPageOptions,
    showPerPageOptions = _ref$showPerPageOptio === void 0 ? defaults.showPerPageOptions : _ref$showPerPageOptio;
  var defaultPageSize = pageSizeOptions !== null && pageSizeOptions !== void 0 && pageSizeOptions.includes(defaults.itemsPerPage) ? defaults.itemsPerPage : pageSizeOptions[0];
  var initialPageIndex = pagination === true ? 0 : (_ref2 = (_pagination$pageIndex = pagination.pageIndex) !== null && _pagination$pageIndex !== void 0 ? _pagination$pageIndex : pagination.initialPageIndex) !== null && _ref2 !== void 0 ? _ref2 : 0;
  var initialPageSize = pagination === true ? defaultPageSize : (_ref3 = (_pagination$pageSize = pagination.pageSize) !== null && _pagination$pageSize !== void 0 ? _pagination$pageSize : pagination.initialPageSize) !== null && _ref3 !== void 0 ? _ref3 : defaultPageSize;
  if (showPerPageOptions && initialPageSize != null && !(pageSizeOptions !== null && pageSizeOptions !== void 0 && pageSizeOptions.includes(initialPageSize))) {
    throw new Error("EuiInMemoryTable received initialPageSize ".concat(initialPageSize, ", which wasn't provided within pageSizeOptions."));
  }
  return {
    pageIndex: initialPageIndex,
    pageSize: initialPageSize,
    pageSizeOptions: pageSizeOptions,
    showPerPageOptions: showPerPageOptions
  };
};
function findColumnByProp(columns, prop, value) {
  for (var i = 0; i < columns.length; i++) {
    var column = columns[i];
    if (column[prop] === value) {
      return column;
    }
  }
}
function findColumnByFieldOrName(columns, value) {
  // The passed value can be a column's `field` or its `name`
  // for backwards compatibility `field` must be checked first
  var column = findColumnByProp(columns, 'field', value);
  if (column == null) {
    column = findColumnByProp(columns, 'name', value);
  }
  return column;
}
function getInitialSorting(columns, sorting) {
  if (!sorting || !sorting.sort) {
    return {
      sortName: undefined,
      sortDirection: undefined
    };
  }
  var _sort = sorting.sort,
    sortable = _sort.field,
    sortDirection = _sort.direction;
  var sortColumn = findColumnByFieldOrName(columns, sortable);
  if (sortColumn == null) {
    return {
      sortName: undefined,
      sortDirection: undefined
    };
  }
  var sortName = sortColumn.name;
  return {
    sortName: sortName,
    sortDirection: sortDirection
  };
}
export var EuiInMemoryTable = /*#__PURE__*/function (_Component) {
  function EuiInMemoryTable(props, context) {
    var _this;
    _classCallCheck(this, EuiInMemoryTable);
    _this = _callSuper(this, EuiInMemoryTable, [props]);
    _defineProperty(_this, "onTableChange", function (_ref4) {
      var page = _ref4.page,
        sort = _ref4.sort;
      var _ref5 = page || {},
        pageIndex = _ref5.index,
        pageSize = _ref5.size;

      // don't apply pagination changes that are otherwise controlled
      // `page` is left unchanged as it goes to the consumer's `onTableChange` callback, allowing the app to respond
      var pagination = _this.props.pagination;
      if (pagination != null && typeof pagination !== 'boolean') {
        if (pagination.pageSize != null) pageSize = pagination.pageSize;
        if (pagination.pageIndex != null) pageIndex = pagination.pageIndex;
      }
      var _ref6 = sort || {},
        sortName = _ref6.field,
        sortDirection = _ref6.direction;

      // To keep backwards compatibility reportedSortName needs to be tracked separately
      // from sortName; sortName gets stored internally while reportedSortName is sent to the callback
      var reportedSortName = sortName;

      // EuiBasicTable returns the column's `field` instead of `name` on sort
      // and the column's `name` instead of `field` on pagination
      if (sortName) {
        var sortColumn = findColumnByFieldOrName(_this.props.columns, sortName);
        if (sortColumn) {
          // Ensure sortName uses `name`
          sortName = sortColumn.name;

          // Ensure reportedSortName uses `field` if it exists
          var sortField = sortColumn.field;
          if (sortField) reportedSortName = sortField;
        }
      }

      // Allow going back to 'neutral' sorting
      if (_this.state.allowNeutralSort && _this.state.sortName === sortName && _this.state.sortDirection === 'desc' && sortDirection === 'asc') {
        sortName = '';
        reportedSortName = '';
        sortDirection = 'asc'; // Default sort direction.
      }
      if (_this.props.onTableChange) {
        _this.props.onTableChange({
          // @ts-ignore complex relationship between pagination's existence and criteria, the code logic ensures this is correctly maintained
          page: page,
          sort: {
            field: reportedSortName,
            direction: sortDirection
          }
        });
      }
      _this.setState({
        pageIndex: pageIndex,
        pageSize: pageSize,
        sortName: sortName,
        sortDirection: sortDirection
      });
    });
    _defineProperty(_this, "onQueryChange", function (_ref7) {
      var query = _ref7.query,
        queryText = _ref7.queryText,
        error = _ref7.error;
      var search = _this.props.search;
      if (isEuiSearchBarProps(search)) {
        if (search.onChange) {
          var shouldQueryInMemory = error == null ? search.onChange({
            query: query,
            queryText: queryText,
            error: null
          }) : search.onChange({
            query: null,
            queryText: queryText,
            error: error
          });
          if (!shouldQueryInMemory) {
            return;
          }
        }
      }

      // Reset pagination state.
      _this.setState(function (state) {
        return {
          prevProps: _objectSpread(_objectSpread({}, state.prevProps), {}, {
            search: search
          }),
          query: query,
          pageIndex: 0
        };
      });
    });
    // Alternative to onQueryChange - allows consumers to specify they want the
    // search bar to ignore EQL syntax and only use the searchbar for plain text
    _defineProperty(_this, "onPlainTextSearch", function (searchValue) {
      var escapedQueryText = searchValue.replace(/["\\]/g, '\\$&');
      var finalQuery = "\"".concat(escapedQueryText, "\"");
      _this.setState({
        query: EuiSearchBar.Query.parse(finalQuery)
      });
    });
    var columns = props.columns,
      _search = props.search,
      _pagination = props.pagination,
      sorting = props.sorting,
      allowNeutralSort = props.allowNeutralSort;
    var _getInitialPagination = getInitialPagination(_pagination, context.EuiTablePagination),
      _pageIndex = _getInitialPagination.pageIndex,
      _pageSize = _getInitialPagination.pageSize,
      pageSizeOptions = _getInitialPagination.pageSizeOptions,
      showPerPageOptions = _getInitialPagination.showPerPageOptions;
    var _getInitialSorting = getInitialSorting(columns, sorting),
      _sortName = _getInitialSorting.sortName,
      _sortDirection = _getInitialSorting.sortDirection;
    _this.state = {
      prevProps: {
        items: props.items,
        sortName: _sortName,
        sortDirection: _sortDirection,
        search: _search
      },
      search: _search,
      query: getQueryFromSearch(_search, true),
      pageIndex: _pageIndex || 0,
      pageSize: _pageSize,
      pageSizeOptions: pageSizeOptions,
      sortName: _sortName,
      sortDirection: _sortDirection,
      allowNeutralSort: allowNeutralSort !== false,
      showPerPageOptions: showPerPageOptions
    };
    return _this;
  }
  _inherits(EuiInMemoryTable, _Component);
  return _createClass(EuiInMemoryTable, [{
    key: "renderSearchBar",
    value: function renderSearchBar() {
      var _this$props = this.props,
        search = _this$props.search,
        searchFormat = _this$props.searchFormat;
      if (!search) return;
      var searchBar;
      if (searchFormat === 'text') {
        var _searchBoxProps = (search === null || search === void 0 ? void 0 : search.box) || {}; // Work around | boolean type
        var schema = _searchBoxProps.schema,
          searchBoxProps = _objectWithoutProperties(_searchBoxProps, _excluded); // Destructure `schema` so it doesn't get rendered to DOM

        searchBar = ___EmotionJSX(EuiSearchBox, _extends({
          query: "" // Unused, passed to satisfy Typescript
        }, searchBoxProps, {
          onSearch: this.onPlainTextSearch
        }));
      } else {
        var searchBarProps = {};
        if (isEuiSearchBarProps(search)) {
          var onChange = search.onChange,
            _searchBarProps = _objectWithoutProperties(search, _excluded2);
          searchBarProps = _searchBarProps;
          if (searchBarProps.box && searchBarProps.box.schema === true) {
            searchBarProps.box = _objectSpread(_objectSpread({}, searchBarProps.box), {}, {
              schema: this.resolveSearchSchema()
            });
          }
        }
        searchBar = ___EmotionJSX(EuiSearchBar, _extends({
          onChange: this.onQueryChange
        }, searchBarProps));
      }
      return ___EmotionJSX(React.Fragment, null, searchBar, ___EmotionJSX(EuiSpacer, {
        size: "l"
      }));
    }
  }, {
    key: "resolveSearchSchema",
    value: function resolveSearchSchema() {
      var columns = this.props.columns;
      return columns.reduce(function (schema, column) {
        var _ref8 = column,
          field = _ref8.field,
          dataType = _ref8.dataType;
        if (field) {
          var type = dataType || 'string';
          schema.fields[field] = {
            type: type
          };
        }
        return schema;
      }, {
        strict: true,
        fields: {}
      });
    }
  }, {
    key: "getItemSorter",
    value: function getItemSorter() {
      var _this$state = this.state,
        sortName = _this$state.sortName,
        sortDirection = _this$state.sortDirection;
      var columns = this.props.columns;
      var sortColumn = columns.find(function (_ref9) {
        var name = _ref9.name;
        return name === sortName;
      });
      if (sortColumn == null) {
        // can't return a non-function so return a function that says everything is the same
        return function () {
          return 0;
        };
      }
      var sortable = sortColumn.sortable;
      if (typeof sortable === 'function') {
        return Comparators.value(sortable, Comparators.default(sortDirection));
      }
      return Comparators.property(sortColumn.field, Comparators.default(sortDirection));
    }
  }, {
    key: "getItems",
    value: function getItems() {
      var executeQueryOptions = this.props.executeQueryOptions;
      var items = this.state.prevProps.items;
      if (!items.length) {
        return {
          items: [],
          totalItemCount: 0
        };
      }
      var _this$state2 = this.state,
        query = _this$state2.query,
        sortName = _this$state2.sortName,
        pageIndex = _this$state2.pageIndex,
        pageSize = _this$state2.pageSize;
      var matchingItems = query !== null && (executeQueryOptions === null || executeQueryOptions === void 0 ? void 0 : executeQueryOptions.enabled) !== false ? EuiSearchBar.Query.execute(query, items, executeQueryOptions) : items;
      var sortedItems = sortName ? matchingItems.slice(0) // avoid mutating the source array
      .sort(this.getItemSorter()) // sort, causes mutation
      : matchingItems;
      var visibleItems = pageSize && this.props.pagination ? function () {
        var startIndex = pageIndex * pageSize;
        return sortedItems.slice(startIndex, Math.min(startIndex + pageSize, sortedItems.length));
      }() : sortedItems;
      return {
        items: visibleItems,
        totalItemCount: matchingItems.length
      };
    }
  }, {
    key: "render",
    value: function render() {
      var _this$props2 = this.props,
        columns = _this$props2.columns,
        loading = _this$props2.loading,
        message = _this$props2.message,
        error = _this$props2.error,
        selection = _this$props2.selection,
        compressed = _this$props2.compressed,
        hasPagination = _this$props2.pagination,
        hasSorting = _this$props2.sorting,
        itemIdToExpandedRowMap = _this$props2.itemIdToExpandedRowMap,
        itemId = _this$props2.itemId,
        rowProps = _this$props2.rowProps,
        cellProps = _this$props2.cellProps,
        tableLayout = _this$props2.tableLayout,
        _unuseditems = _this$props2.items,
        search = _this$props2.search,
        searchFormat = _this$props2.searchFormat,
        onTableChange = _this$props2.onTableChange,
        executeQueryOptions = _this$props2.executeQueryOptions,
        allowNeutralSort = _this$props2.allowNeutralSort,
        childrenBetween = _this$props2.childrenBetween,
        rest = _objectWithoutProperties(_this$props2, _excluded3);
      var _this$state3 = this.state,
        pageIndex = _this$state3.pageIndex,
        pageSize = _this$state3.pageSize,
        pageSizeOptions = _this$state3.pageSizeOptions,
        sortName = _this$state3.sortName,
        sortDirection = _this$state3.sortDirection,
        showPerPageOptions = _this$state3.showPerPageOptions;
      var _this$getItems = this.getItems(),
        items = _this$getItems.items,
        totalItemCount = _this$getItems.totalItemCount;
      var pagination = !hasPagination ? undefined : {
        pageIndex: pageIndex,
        pageSize: pageSize !== null && pageSize !== void 0 ? pageSize : 1,
        pageSizeOptions: pageSizeOptions,
        totalItemCount: totalItemCount,
        showPerPageOptions: showPerPageOptions
      };

      // Data loaded from a server can have a default sort order which is meaningful to the
      // user, but can't be reproduced with client-side sort logic. So we allow the table to display
      // rows in the order in which they're initially loaded by providing an undefined sorting prop.
      var sorting = !hasSorting ? undefined : {
        sort: !sortName && !sortDirection ? undefined : {
          field: sortName,
          direction: sortDirection
        },
        allowNeutralSort: this.state.allowNeutralSort
      };
      var searchBar = this.renderSearchBar();
      var table =
      // @ts-ignore complex relationship between pagination's existence and criteria, the code logic ensures this is correctly maintained
      ___EmotionJSX(EuiBasicTable, _extends({
        items: items,
        itemId: itemId,
        rowProps: rowProps,
        cellProps: cellProps,
        columns: columns,
        pagination: pagination,
        sorting: sorting,
        selection: selection,
        onChange: this.onTableChange,
        error: error,
        loading: loading,
        noItemsMessage: message,
        tableLayout: tableLayout,
        compressed: compressed,
        itemIdToExpandedRowMap: itemIdToExpandedRowMap
      }, rest));
      if (!searchBar) {
        return table;
      }
      return ___EmotionJSX("div", null, searchBar, childrenBetween, table);
    }
  }], [{
    key: "getDerivedStateFromProps",
    value: function getDerivedStateFromProps(nextProps, prevState) {
      var updatedPrevState = prevState;
      if (nextProps.items !== prevState.prevProps.items) {
        // We have new items because an external search has completed, so reset pagination state.

        var nextPageIndex = 0;
        if (nextProps.pagination != null && typeof nextProps.pagination !== 'boolean') {
          nextPageIndex = nextProps.pagination.pageIndex || 0;
        }
        updatedPrevState = _objectSpread(_objectSpread({}, updatedPrevState), {}, {
          prevProps: _objectSpread(_objectSpread({}, updatedPrevState.prevProps), {}, {
            items: nextProps.items
          }),
          pageIndex: nextPageIndex
        });
      }

      // apply changes to controlled pagination
      if (nextProps.pagination != null && typeof nextProps.pagination !== 'boolean') {
        if (nextProps.pagination.pageSize != null && nextProps.pagination.pageSize !== updatedPrevState.pageIndex) {
          updatedPrevState = _objectSpread(_objectSpread({}, updatedPrevState), {}, {
            pageSize: nextProps.pagination.pageSize
          });
        }
        if (nextProps.pagination.pageIndex != null && nextProps.pagination.pageIndex !== updatedPrevState.pageIndex) {
          updatedPrevState = _objectSpread(_objectSpread({}, updatedPrevState), {}, {
            pageIndex: nextProps.pagination.pageIndex
          });
        }
      }
      var _getInitialSorting2 = getInitialSorting(nextProps.columns, nextProps.sorting),
        sortName = _getInitialSorting2.sortName,
        sortDirection = _getInitialSorting2.sortDirection;
      if (sortName !== prevState.prevProps.sortName || sortDirection !== prevState.prevProps.sortDirection) {
        updatedPrevState = _objectSpread(_objectSpread({}, updatedPrevState), {}, {
          prevProps: _objectSpread(_objectSpread({}, updatedPrevState.prevProps), {}, {
            sortName: sortName,
            sortDirection: sortDirection
          }),
          sortName: sortName,
          sortDirection: sortDirection
        });
      }
      var nextQuery = nextProps.search ? nextProps.search.query : '';
      var prevQuery = prevState.prevProps.search ? prevState.prevProps.search.query : '';
      if (nextQuery !== prevQuery) {
        updatedPrevState = _objectSpread(_objectSpread({}, updatedPrevState), {}, {
          prevProps: _objectSpread(_objectSpread({}, updatedPrevState.prevProps), {}, {
            search: nextProps.search
          }),
          query: getQueryFromSearch(nextProps.search, false)
        });
      }
      if (updatedPrevState !== prevState) {
        return updatedPrevState;
      }
      return null;
    }
  }]);
}(Component);
_defineProperty(EuiInMemoryTable, "contextType", EuiComponentDefaultsContext);
_defineProperty(EuiInMemoryTable, "defaultProps", {
  tableLayout: 'fixed',
  searchFormat: 'eql'
});
EuiInMemoryTable.propTypes = {
  className: PropTypes.string,
  "aria-label": PropTypes.string,
  "data-test-subj": PropTypes.string,
  css: PropTypes.any,
  /**
     * Describes how to extract a unique ID from each item, used for selections & expanded rows
     */
  /**
     * Describes how to extract a unique ID from each item, used for selections & expanded rows
     */
  itemId: PropTypes.oneOfType([PropTypes.string.isRequired, PropTypes.number.isRequired, PropTypes.func.isRequired]),
  /**
     * Row expansion uses the itemId prop to identify each row
     */
  /**
     * Row expansion uses the itemId prop to identify each row
     */
  itemIdToExpandedRowMap: PropTypes.shape({}),
  /**
     * A list of objects to appear in the table - an item per row
     */
  /**
     * A list of objects to appear in the table - an item per row
     */
  items: PropTypes.arrayOf(PropTypes.any.isRequired),
  /**
     * Applied to `EuiTableRowCell`
     */
  /**
     * Applied to `EuiTableRowCell`
     */
  cellProps: PropTypes.oneOfType([PropTypes.any.isRequired, PropTypes.func.isRequired]),
  /**
     * An array of one of the objects: #EuiTableFieldDataColumnType, #EuiTableComputedColumnType or #EuiTableActionsColumnType.
     */
  /**
     * An array of one of the objects: #EuiTableFieldDataColumnType, #EuiTableComputedColumnType or #EuiTableActionsColumnType.
     */
  columns: PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.shape({
    /**
       * A field of the item (may be a nested field)
       */
    // type hack used for better autocomplete support
    // https://github.com/microsoft/TypeScript/issues/29729
    field: PropTypes.oneOfType([PropTypes.any.isRequired, PropTypes.any.isRequired]).isRequired,
    // supports outer.inner key paths
    /**
       * The display name of the column
       */
    name: PropTypes.node.isRequired,
    /**
       * A description of the column (will be presented as a title over the column header)
       */
    description: PropTypes.string,
    /**
       * Describes the data types of the displayed value (serves as a rendering hint for the table)
       */
    dataType: PropTypes.oneOf(["auto", "string", "number", "boolean", "date"]),
    /**
       * A CSS width property. Hints for the required width of the column (e.g. "30%", "100px", etc..)
       */
    width: PropTypes.string,
    /**
       * Defines whether the user can sort on this column. If a function is provided, this function returns the value to sort against
       */
    sortable: PropTypes.oneOfType([PropTypes.bool.isRequired, PropTypes.func.isRequired]),
    /**
       * Disables the user's ability to change the sort, but will still
       * show the current sort direction in the column header
       */
    readOnly: PropTypes.bool,
    /**
       * Defines the horizontal alignment of the column
       * @default left
       */
    align: PropTypes.any,
    /**
       * Creates a text wrapper around cell content that helps word break or truncate
       * long text correctly.
       * @default true
       */
    textOnly: PropTypes.bool,
    /**
       * Indicates whether this column should truncate overflowing text content.
       * - Set to `true` to enable single-line truncation.
       * - To enable multi-line truncation, use a configuration object with `lines`
       * set to a number of lines to truncate to.
       */
    truncateText: PropTypes.oneOfType([PropTypes.bool.isRequired, PropTypes.shape({
      lines: PropTypes.number.isRequired
    }).isRequired]),
    /**
       * Allows configuring custom render options or appearances for column cells
       * when the table responsively collapses into a mobile-friendly view
       */
    mobileOptions: PropTypes.shape({
      render: PropTypes.func
    }),
    /**
       * Describe a custom renderer function for the content
       */
    render: PropTypes.func,
    /**
       * Content to display in the footer beneath this column
       */
    footer: PropTypes.oneOfType([PropTypes.string.isRequired, PropTypes.element.isRequired, PropTypes.func.isRequired]),
    /**
       * If passing `itemIdToExpandedRowMap` to your table, set this flag to `true`
       * for the custom column or cell used to toggle the expanded row.
       */
    isExpander: PropTypes.bool,
    className: PropTypes.string,
    "aria-label": PropTypes.string,
    "data-test-subj": PropTypes.string,
    css: PropTypes.any
  }).isRequired, PropTypes.shape({
    className: PropTypes.string,
    "aria-label": PropTypes.string,
    "data-test-subj": PropTypes.string,
    css: PropTypes.any,
    /**
         * A function that computes the value for each item and renders it
         */
    render: PropTypes.func.isRequired,
    /**
         * The display name of the column
         */
    name: PropTypes.node,
    /**
         * If provided, allows this column to be sorted on. Must return the value to sort against.
         */
    sortable: PropTypes.func
  }).isRequired, PropTypes.shape({
    /**
       * An array of one of the objects: #DefaultItemAction or #CustomItemAction
       */
    actions: PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.shape({
      /**
         * The type of action
         */
      type: PropTypes.oneOfType([PropTypes.oneOf(["button"]), PropTypes.oneOf(["icon"]).isRequired]),
      /**
         * Defines the color of the button
         */
      color: PropTypes.oneOfType([PropTypes.any.isRequired, PropTypes.func.isRequired]),
      /**
         * The display name of the action (will render as visible text if rendered within a collapsed menu)
         */
      /**
         * The display name of the action (will render as visible text if rendered within a collapsed menu)
         */
      name: PropTypes.oneOfType([PropTypes.node.isRequired, PropTypes.func.isRequired]).isRequired,
      /**
         * Describes the action (will render as tooltip content)
         */
      /**
         * Describes the action (will render as tooltip content)
         */
      description: PropTypes.oneOfType([PropTypes.string.isRequired, PropTypes.func.isRequired]).isRequired,
      /**
         * A handler function to execute the action. Passes back the current row
         * item as the first argument, and the originating React click event
         * as a second argument.
         */
      /**
         * A handler function to execute the action. Passes back the current row
         * item as the first argument, and the originating React click event
         * as a second argument.
         */
      onClick: PropTypes.func,
      href: PropTypes.oneOfType([PropTypes.string.isRequired, PropTypes.func.isRequired]),
      target: PropTypes.string,
      /**
         * A callback function that determines whether the action is available
         */
      /**
         * A callback function that determines whether the action is available
         */
      available: PropTypes.func,
      /**
         * A callback function that determines whether the action is enabled
         */
      /**
         * A callback function that determines whether the action is enabled
         */
      enabled: PropTypes.func,
      "data-test-subj": PropTypes.oneOfType([PropTypes.string.isRequired, PropTypes.func.isRequired]),
      /**
         * If more than 3 actions are passed, 2 primary actions will show (on hover)
         * next to an expansion menu of all actions.
         *
         * On mobile, primary actions will be tucked away in the expansion menu for space.
         */
      /**
         * If more than 3 actions are passed, 2 primary actions will show (on hover)
         * next to an expansion menu of all actions.
         *
         * On mobile, primary actions will be tucked away in the expansion menu for space.
         */
      isPrimary: PropTypes.bool,
      /**
         * Allows only showing the action on mouse hover or keyboard focus.
         * If more than 3 actions are passed, this will always be true for `isPrimary` actions.
         *
         * Has no effect on mobile, or if `hasActions` is not set.
         */
      /**
         * Allows only showing the action on mouse hover or keyboard focus.
         * If more than 3 actions are passed, this will always be true for `isPrimary` actions.
         *
         * Has no effect on mobile, or if `hasActions` is not set.
         */
      showOnHover: PropTypes.bool,
      /**
         * Associates an icon with the button
         */
      icon: PropTypes.oneOfType([PropTypes.oneOf(["accessibility", "addDataApp", "advancedSettingsApp", "agentApp", "aggregate", "analyzeEvent", "annotation", "anomalyChart", "anomalySwimLane", "apmApp", "apmTrace", "appSearchApp", "apps", "arrowDown", "arrowLeft", "arrowRight", "arrowUp", "arrowStart", "arrowEnd", "article", "asterisk", "at", "auditbeatApp", "beaker", "bell", "bellSlash", "beta", "bolt", "boxesHorizontal", "boxesVertical", "branch", "branchUser", "broom", "brush", "bug", "bullseye", "calendar", "canvasApp", "casesApp", "changePointDetection", "check", "checkInCircleFilled", "cheer", "classificationJob", "clickLeft", "clickRight", "clock", "clockCounter", "cloudDrizzle", "cloudStormy", "cloudSunny", "cluster", "codeApp", "color", "compute", "console", "consoleApp", "container", "continuityAbove", "continuityAboveBelow", "continuityBelow", "continuityWithin", "contrast", "contrastHigh", "controlsHorizontal", "controlsVertical", "copy", "copyClipboard", "createAdvancedJob", "createGenericJob", "createGeoJob", "createMultiMetricJob", "createPopulationJob", "createSingleMetricJob", "cross", "crossClusterReplicationApp", "crossInCircle", "crosshairs", "currency", "cut", "dashboardApp", "dataVisualizer", "database", "desktop", "devToolsApp", "diff", "discoverApp", "discuss", "document", "documentEdit", "documentation", "documents", "dot", "dotInCircle", "doubleArrowLeft", "doubleArrowRight", "download", "editorAlignCenter", "editorAlignLeft", "editorAlignRight", "editorBold", "editorChecklist", "editorCodeBlock", "editorComment", "editorDistributeHorizontal", "editorDistributeVertical", "editorHeading", "editorItalic", "editorItemAlignBottom", "editorItemAlignCenter", "editorItemAlignLeft", "editorItemAlignMiddle", "editorItemAlignRight", "editorItemAlignTop", "editorLink", "editorOrderedList", "editorPositionBottomLeft", "editorPositionBottomRight", "editorPositionTopLeft", "editorPositionTopRight", "editorRedo", "editorStrike", "editorTable", "editorUnderline", "editorUndo", "editorUnorderedList", "email", "empty", "emsApp", "endpoint", "eql", "eraser", "error", "errorFilled", "esqlVis", "exit", "expand", "expandMini", "exportAction", "eye", "eyeClosed", "faceHappy", "faceNeutral", "faceSad", "fieldStatistics", "filebeatApp", "filter", "filterExclude", "filterIgnore", "filterInclude", "filterInCircle", "flag", "fleetApp", "fold", "folderCheck", "folderClosed", "folderExclamation", "folderOpen", "frameNext", "framePrevious", "fullScreen", "fullScreenExit", "function", "gear", "gisApp", "glasses", "globe", "grab", "grabHorizontal", "grabOmnidirectional", "gradient", "graphApp", "grid", "grokApp", "heart", "heartbeatApp", "heatmap", "help", "home", "iInCircle", "image", "importAction", "index", "indexClose", "indexEdit", "indexFlush", "indexManagementApp", "indexMapping", "indexOpen", "indexPatternApp", "indexRollupApp", "indexRuntime", "indexSettings", "indexTemporary", "infinity", "inputOutput", "inspect", "invert", "ip", "key", "keyboard", "kqlField", "kqlFunction", "kqlOperand", "kqlSelector", "kqlValue", "kubernetesNode", "kubernetesPod", "launch", "layers", "lensApp", "lettering", "lineDashed", "lineDotted", "lineSolid", "link", "list", "listAdd", "lock", "lockOpen", "logPatternAnalysis", "logRateAnalysis", "logoAWS", "logoAWSMono", "logoAerospike", "logoApache", "logoAppSearch", "logoAzure", "logoAzureMono", "logoBeats", "logoBusinessAnalytics", "logoCeph", "logoCloud", "logoCloudEnterprise", "logoCode", "logoCodesandbox", "logoCouchbase", "logoDocker", "logoDropwizard", "logoElastic", "logoElasticStack", "logoElasticsearch", "logoEnterpriseSearch", "logoEtcd", "logoGCP", "logoGCPMono", "logoGithub", "logoGmail", "logoGolang", "logoGoogleG", "logoHAproxy", "logoIBM", "logoIBMMono", "logoKafka", "logoKibana", "logoKubernetes", "logoLogging", "logoLogstash", "logoMaps", "logoMemcached", "logoMetrics", "logoMongodb", "logoMySQL", "logoNginx", "logoObservability", "logoOsquery", "logoPhp", "logoPostgres", "logoPrometheus", "logoRabbitmq", "logoRedis", "logoSecurity", "logoSiteSearch", "logoSketch", "logoSlack", "logoUptime", "logoVulnerabilityManagement", "logoWebhook", "logoWindows", "logoWorkplaceSearch", "logsApp", "logstashFilter", "logstashIf", "logstashInput", "logstashOutput", "logstashQueue", "machineLearningApp", "magnet", "magnifyWithExclamation", "magnifyWithMinus", "magnifyWithPlus", "managementApp", "mapMarker", "memory", "menu", "menuDown", "menuLeft", "menuRight", "menuUp", "merge", "metricbeatApp", "metricsApp", "minimize", "minus", "minusInCircle", "minusInCircleFilled", "minusInSquare", "mobile", "monitoringApp", "moon", "move", "namespace", "nested", "newChat", "node", "notebookApp", "number", "offline", "online", "outlierDetectionJob", "package", "packetbeatApp", "pageSelect", "pagesSelect", "palette", "paperClip", "partial", "pause", "payment", "pencil", "percent", "pin", "pinFilled", "pipeBreaks", "pipelineApp", "pipeNoBreaks", "pivot", "play", "playFilled", "plus", "plusInCircle", "plusInCircleFilled", "plusInSquare", "popout", "push", "questionInCircle", "quote", "recentlyViewedApp", "refresh", "regressionJob", "reporter", "reportingApp", "returnKey", "save", "savedObjectsApp", "scale", "search", "searchProfilerApp", "section", "securityAnalyticsApp", "securityApp", "securitySignal", "securitySignalDetected", "securitySignalResolved", "sessionViewer", "shard", "share", "singleMetricViewer", "snowflake", "sortAscending", "sortDescending", "sortDown", "sortLeft", "sortRight", "sortUp", "sortable", "spaces", "spacesApp", "sparkles", "sqlApp", "starEmpty", "starEmptySpace", "starFilled", "starFilledSpace", "starMinusEmpty", "starMinusFilled", "starPlusEmpty", "starPlusFilled", "stats", "stop", "stopFilled", "stopSlash", "storage", "string", "submodule", "sun", "swatchInput", "symlink", "tableDensityCompact", "tableDensityExpanded", "tableDensityNormal", "tableOfContents", "tag", "tear", "temperature", "timeline", "timelineWithArrow", "timelionApp", "timeRefresh", "timeslider", "training", "transitionLeftIn", "transitionLeftOut", "transitionTopIn", "transitionTopOut", "trash", "unfold", "unlink", "upgradeAssistantApp", "uptimeApp", "user", "userAvatar", "users", "usersRolesApp", "vector", "videoPlayer", "visArea", "visAreaStacked", "visBarHorizontal", "visBarHorizontalStacked", "visBarVertical", "visBarVerticalStacked", "visGauge", "visGoal", "visLine", "visMapCoordinate", "visMapRegion", "visMetric", "visPie", "visTable", "visTagCloud", "visText", "visTimelion", "visVega", "visVisualBuilder", "visualizeApp", "vulnerabilityManagementApp", "warning", "warningFilled", "alert", "watchesApp", "wordWrap", "wordWrapDisabled", "workplaceSearchApp", "wrench", "tokenAlias", "tokenAnnotation", "tokenArray", "tokenBinary", "tokenBoolean", "tokenClass", "tokenCompletionSuggester", "tokenConstant", "tokenDate", "tokenDimension", "tokenElement", "tokenEnum", "tokenEnumMember", "tokenEvent", "tokenException", "tokenField", "tokenFile", "tokenFlattened", "tokenFunction", "tokenGeo", "tokenHistogram", "tokenInterface", "tokenIP", "tokenJoin", "tokenKey", "tokenKeyword", "tokenMethod", "tokenMetricCounter", "tokenMetricGauge", "tokenModule", "tokenNamespace", "tokenNested", "tokenNull", "tokenNumber", "tokenObject", "tokenOperator", "tokenPackage", "tokenParameter", "tokenPercolator", "tokenProperty", "tokenRange", "tokenRankFeature", "tokenRankFeatures", "tokenRepo", "tokenSearchType", "tokenSemanticText", "tokenShape", "tokenString", "tokenStruct", "tokenSymbol", "tokenTag", "tokenText", "tokenTokenCount", "tokenVariable", "tokenVectorDense", "tokenDenseVector", "tokenVectorSparse"]).isRequired, PropTypes.func.isRequired])
    }).isRequired, PropTypes.shape({
      /**
         * Allows rendering a totally custom action
         */
      render: PropTypes.func.isRequired,
      /**
         * A callback that defines whether the action is available
         */
      available: PropTypes.func,
      /**
         * A callback that defines whether the action is enabled
         */
      enabled: PropTypes.func
    }).isRequired]).isRequired).isRequired,
    /**
       * The display name of the column
       */
    name: PropTypes.node
  }).isRequired]).isRequired),
  /**
     * Error message to display
     */
  /**
     * Error message to display
     */
  error: PropTypes.string,
  /**
     * Describes the content of the table. If not specified, the caption will be "This table contains {itemCount} rows."
     */
  /**
     * Describes the content of the table. If not specified, the caption will be "This table contains {itemCount} rows."
     */
  tableCaption: PropTypes.string,
  /**
     * Indicates which column should be used as the identifying cell in each row. Should match a "field" prop in FieldDataColumn
     */
  /**
     * Indicates which column should be used as the identifying cell in each row. Should match a "field" prop in FieldDataColumn
     */
  rowHeader: PropTypes.string,
  /**
     * Provides an infinite loading indicator
     */
  /**
     * Provides an infinite loading indicator
     */
  loading: PropTypes.bool,
  /**
     * Applied to `EuiTableRow`
     */
  /**
     * Applied to `EuiTableRow`
     */
  rowProps: PropTypes.oneOfType([PropTypes.any.isRequired, PropTypes.func.isRequired]),
  /**
     * Configures #EuiTableSelectionType
     */
  /**
     * Configures #EuiTableSelectionType
     */
  selection: PropTypes.shape({
    /**
       * A callback that will be called whenever the item selection changes.
       *
       * Required if `selected` is passed.
       */
    onSelectionChange: PropTypes.func,
    /**
       * A callback that is called per item to indicate whether it is selectable
       */
    selectable: PropTypes.func,
    /**
       * A callback that is called per item to retrieve a message for its selectable state.
       * We display these messages as a tooltip on an unselectable checkbox
       */
    selectableMessage: PropTypes.func,
    /**
       * Sets initially selected items. Use for uncontrolled selection behavior (checkbox
       * will only change from user input, and not from developer control).
       *
       * This prop will be ignored if `selected` is passed.
       */
    initialSelected: PropTypes.arrayOf(PropTypes.any.isRequired),
    /**
       * Used for controlled selection behavior, e.g. when you want to programmatically
       * control which selection checkboxes are checked, and which are not.
       */
    selected: PropTypes.arrayOf(PropTypes.any.isRequired)
  }),
  /**
     * Sets the table-layout CSS property. Note that auto tableLayout prevents truncateText from working properly.
     */
  /**
     * Sets the table-layout CSS property. Note that auto tableLayout prevents truncateText from working properly.
     */
  tableLayout: PropTypes.oneOf(["fixed", "auto"]),
  message: PropTypes.node,
  /**
     * Configures #Search.
     */
  /**
     * Configures #Search.
     */
  search: PropTypes.oneOfType([PropTypes.bool.isRequired, PropTypes.shape({
    onChange: PropTypes.func,
    /**
       The initial query the bar will hold when first mounted
       */
    defaultQuery: PropTypes.oneOfType([PropTypes.any.isRequired, PropTypes.string.isRequired]),
    /**
       If you wish to use the search bar as a controlled component, continuously pass the query via this prop.
       */
    query: PropTypes.oneOfType([PropTypes.any.isRequired, PropTypes.string.isRequired]),
    /**
       Configures the search box. Set `placeholder` to change the placeholder text in the box and `incremental` to support incremental (as you type) search.
       */
    box: PropTypes.shape({
      name: PropTypes.string,
      id: PropTypes.string,
      placeholder: PropTypes.string,
      value: PropTypes.string,
      isInvalid: PropTypes.bool,
      /**
         * Expand to fill 100% of the parent.
         * Defaults to `fullWidth` prop of `<EuiForm>`.
         * @default false
         */
      fullWidth: PropTypes.bool,
      isLoading: PropTypes.bool,
      /**
         * Called when the user presses [Enter] OR on change if the incremental prop is `true`.
         * If you don't need the on[Enter] functionality, prefer using onChange
         */
      onSearch: PropTypes.func,
      /**
         * When `true` the search will be executed (that is, the `onSearch` will be called) as the
         * user types.
         */
      incremental: PropTypes.bool,
      /**
         * when `true` creates a shorter height input
         */
      compressed: PropTypes.bool,
      inputRef: PropTypes.func,
      /**
         * Shows a button that quickly clears any input
         */
      isClearable: PropTypes.bool,
      /**
         * Creates an input group with element(s) coming before input
         * `string` | `ReactElement` or an array of these
         */
      prepend: PropTypes.oneOfType([PropTypes.oneOfType([PropTypes.string.isRequired, PropTypes.element.isRequired]).isRequired, PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.string.isRequired, PropTypes.element.isRequired]).isRequired).isRequired]),
      /**
         * Creates an input group with element(s) coming after input.
         * `string` | `ReactElement` or an array of these
         */
      append: PropTypes.oneOfType([PropTypes.oneOfType([PropTypes.string.isRequired, PropTypes.element.isRequired]).isRequired, PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.string.isRequired, PropTypes.element.isRequired]).isRequired).isRequired]),
      className: PropTypes.string,
      "aria-label": PropTypes.string,
      "data-test-subj": PropTypes.string,
      css: PropTypes.any,
      // Boolean values are not meaningful to this EuiSearchBox, but are allowed so that other
      // components can use e.g. a true value to mean "auto-derive a schema". See EuiInMemoryTable.
      // Admittedly, this is a bit of a hack.
      schema: PropTypes.oneOfType([PropTypes.shape({
        strict: PropTypes.bool,
        fields: PropTypes.any,
        flags: PropTypes.arrayOf(PropTypes.string.isRequired),
        // Controls which phrases will be parsed as field clauses
        recognizedFields: PropTypes.arrayOf(PropTypes.string.isRequired)
      }).isRequired, PropTypes.bool.isRequired])
    }),
    /**
       An array of search filters. See #SearchFilterConfig.
       */
    filters: PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.shape({
      type: PropTypes.oneOf(["is"]).isRequired,
      field: PropTypes.string.isRequired,
      name: PropTypes.string.isRequired,
      negatedName: PropTypes.string,
      available: PropTypes.func
    }).isRequired, PropTypes.shape({
      type: PropTypes.oneOf(["field_value_selection"]).isRequired,
      field: PropTypes.string,
      name: PropTypes.string.isRequired,
      /**
         * See #FieldValueOptionType
         */
      options: PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.shape({
        field: PropTypes.string,
        value: PropTypes.oneOfType([PropTypes.string.isRequired, PropTypes.number.isRequired, PropTypes.bool.isRequired, PropTypes.shape({
          type: PropTypes.oneOf(["date"]).isRequired,
          raw: PropTypes.any.isRequired,
          granularity: PropTypes.oneOfType([PropTypes.shape({
            es: PropTypes.oneOf(["d", "w", "M", "y"]).isRequired,
            js: PropTypes.oneOf(["day", "week", "month", "year"]).isRequired,
            isSame: PropTypes.func.isRequired,
            start: PropTypes.func.isRequired,
            startOfNext: PropTypes.func.isRequired,
            iso8601: PropTypes.func.isRequired
          }).isRequired, PropTypes.oneOf([undefined])]).isRequired,
          text: PropTypes.string.isRequired,
          resolve: PropTypes.func.isRequired
        }).isRequired]).isRequired,
        name: PropTypes.string,
        view: PropTypes.node
      }).isRequired).isRequired, PropTypes.func.isRequired]).isRequired,
      filterWith: PropTypes.oneOfType([PropTypes.oneOf(["prefix", "includes"]), PropTypes.func.isRequired]),
      cache: PropTypes.number,
      multiSelect: PropTypes.oneOfType([PropTypes.bool.isRequired, PropTypes.oneOf(["and", "or"])]),
      loadingMessage: PropTypes.string,
      noOptionsMessage: PropTypes.string,
      searchThreshold: PropTypes.number,
      available: PropTypes.func,
      autoClose: PropTypes.bool,
      operator: PropTypes.oneOf(["eq", "exact", "gt", "gte", "lt", "lte"]),
      autoSortOptions: PropTypes.bool
    }).isRequired, PropTypes.shape({
      type: PropTypes.oneOf(["field_value_toggle"]).isRequired,
      field: PropTypes.string.isRequired,
      value: PropTypes.oneOfType([PropTypes.string.isRequired, PropTypes.number.isRequired, PropTypes.bool.isRequired, PropTypes.shape({
        type: PropTypes.oneOf(["date"]).isRequired,
        raw: PropTypes.any.isRequired,
        granularity: PropTypes.oneOfType([PropTypes.shape({
          es: PropTypes.oneOf(["d", "w", "M", "y"]).isRequired,
          js: PropTypes.oneOf(["day", "week", "month", "year"]).isRequired,
          isSame: PropTypes.func.isRequired,
          start: PropTypes.func.isRequired,
          startOfNext: PropTypes.func.isRequired,
          iso8601: PropTypes.func.isRequired
        }).isRequired, PropTypes.oneOf([undefined])]).isRequired,
        text: PropTypes.string.isRequired,
        resolve: PropTypes.func.isRequired
      }).isRequired]).isRequired,
      name: PropTypes.string.isRequired,
      negatedName: PropTypes.string,
      available: PropTypes.func,
      operator: PropTypes.oneOf(["eq", "exact", "gt", "gte", "lt", "lte"])
    }).isRequired, PropTypes.shape({
      type: PropTypes.oneOf(["field_value_toggle_group"]).isRequired,
      field: PropTypes.string.isRequired,
      /**
         * See #FieldValueToggleGroupFilterItemType
         */
      items: PropTypes.arrayOf(PropTypes.shape({
        value: PropTypes.oneOfType([PropTypes.string.isRequired, PropTypes.number.isRequired, PropTypes.bool.isRequired]).isRequired,
        name: PropTypes.string.isRequired,
        negatedName: PropTypes.string,
        operator: PropTypes.oneOf(["eq", "exact", "gt", "gte", "lt", "lte"])
      }).isRequired).isRequired,
      available: PropTypes.func
    }).isRequired, PropTypes.shape({
      type: PropTypes.oneOf(["custom_component"]).isRequired,
      component: PropTypes.elementType.isRequired,
      available: PropTypes.func
    }).isRequired]).isRequired),
    /**
       * Tools which go to the left of the search bar.
       */
    toolsLeft: PropTypes.oneOfType([PropTypes.element.isRequired, PropTypes.arrayOf(PropTypes.element.isRequired).isRequired]),
    /**
       * Tools which go to the right of the search bar.
       */
    toolsRight: PropTypes.oneOfType([PropTypes.element.isRequired, PropTypes.arrayOf(PropTypes.element.isRequired).isRequired]),
    /**
       * Date formatter to use when parsing date values
       */
    dateFormat: PropTypes.any,
    /**
       * Hint to render below the search bar
       */
    hint: PropTypes.shape({
      content: PropTypes.node.isRequired,
      popoverProps: PropTypes.any
    }),
    className: PropTypes.string,
    "aria-label": PropTypes.string,
    "data-test-subj": PropTypes.string,
    css: PropTypes.any
  }).isRequired]),
  /**
     * By default, tables use `eql` format for search which allows using advanced filters.
     *
     * However, certain special characters (such as quotes, parentheses, and colons)
     * are reserved for EQL syntax and will error if used.
     * If your table does not require filter search and instead requires searching for certain
     * symbols, use a plain `text` search format instead (note that filters will be ignored
     * in this format).
     *
     * @default "eql"
     */
  /**
     * By default, tables use `eql` format for search which allows using advanced filters.
     *
     * However, certain special characters (such as quotes, parentheses, and colons)
     * are reserved for EQL syntax and will error if used.
     * If your table does not require filter search and instead requires searching for certain
     * symbols, use a plain `text` search format instead (note that filters will be ignored
     * in this format).
     *
     * @default "eql"
     */
  searchFormat: PropTypes.oneOf(["eql", "text"]),
  /**
     * Configures #Pagination
     */
  pagination: PropTypes.oneOfType([PropTypes.oneOf([undefined]), PropTypes.oneOfType([PropTypes.bool.isRequired, PropTypes.shape({
    pageSizeOptions: PropTypes.arrayOf(PropTypes.number.isRequired),
    initialPageIndex: PropTypes.number,
    initialPageSize: PropTypes.number,
    pageIndex: PropTypes.number,
    pageSize: PropTypes.number,
    /**
       * Option to completely hide the "Rows per page" selector.
       *
       * @default true
       */
    showPerPageOptions: PropTypes.bool,
    /**
       * Current selection for "Rows per page".
       * Pass `0` to display the selected "Show all" option and hide the pagination.
       *
       * @default 10
       */
    itemsPerPage: PropTypes.number,
    /**
       * Custom array of options for "Rows per page".
       * Pass `0` as one of the options to create a "Show all" option.
       *
       * @default [10, 25, 50]
       */
    itemsPerPageOptions: PropTypes.arrayOf(PropTypes.number.isRequired),
    /**
       * Click handler that passes back selected `pageSize` number
       */
    onChangeItemsPerPage: PropTypes.func,
    onChangePage: PropTypes.func,
    /**
       * Requires the `id` of the table being controlled
       */
    "aria-controls": PropTypes.string,
    "aria-label": PropTypes.string
  }).isRequired])]),
  /**
     * Configures #EuiTableSortingType
     */
  /**
     * Configures #EuiTableSortingType
     */
  sorting: PropTypes.oneOfType([PropTypes.bool.isRequired, PropTypes.shape({
    sort: PropTypes.any.isRequired
  }).isRequired]),
  /**
     * Set `allowNeutralSort` to false to force column sorting. Defaults to true.
     */
  /**
     * Set `allowNeutralSort` to false to force column sorting. Defaults to true.
     */
  allowNeutralSort: PropTypes.bool,
  /**
     * `onChange` is not required when `pagination` and/or `sorting` are configured,
     * but if `onChange` is present it is responsible for handling state for each/both.
     * See #Criteria or #CriteriaWithPagination
     */
  /**
     * `onChange` is not required when `pagination` and/or `sorting` are configured,
     * but if `onChange` is present it is responsible for handling state for each/both.
     * See #Criteria or #CriteriaWithPagination
     */
  onChange: PropTypes.any,
  /**
     * Callback for when table pagination or sorting is changed. This is meant to be informational only, and not used to set any state as the in-memory table already manages this state. See #Criteria or #CriteriaWithPagination.
     */
  onTableChange: PropTypes.func,
  executeQueryOptions: PropTypes.shape({
    defaultFields: PropTypes.arrayOf(PropTypes.string.isRequired),
    isClauseMatcher: PropTypes.func,
    explain: PropTypes.bool,
    /**
         * When the search bar Query is controlled and passed to the `search` prop it is by default executed against the items passed to the table to filter them out.
         * If the filtering is already done before passing the `items` to the table we can disable the execution by setting `enabled` to `false`.
         */
    enabled: PropTypes.bool
  }),
  /**
     * Insert content between the search bar and table components.
     */
  /**
     * Insert content between the search bar and table components.
     */
  childrenBetween: PropTypes.node
};