function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
var _excluded = ["position", "paddingSize", "affordForDisplacement", "children", "className", "bodyClassName", "landmarkHeading", "usePortal", "left", "right", "bottom", "top", "style"];
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t.return && (u = t.return(), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import classNames from 'classnames';
import PropTypes from "prop-types";
import React, { forwardRef, useEffect, useState } from 'react';
import { useCombinedRefs, useEuiMemoizedStyles, EuiThemeProvider } from '../../services';
import { EuiScreenReaderOnly } from '../accessibility';
import { EuiI18n } from '../i18n';
import { useResizeObserver } from '../observer/resize_observer';
import { EuiPortal } from '../portal';
import { euiBottomBarStyles } from './bottom_bar.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var PADDING_SIZES = ['none', 's', 'm', 'l'];
export var POSITIONS = ['static', 'fixed', 'sticky'];
var _EuiBottomBar = /*#__PURE__*/forwardRef(function (_ref, ref) {
  var _ref$position = _ref.position,
    position = _ref$position === void 0 ? 'fixed' : _ref$position,
    _ref$paddingSize = _ref.paddingSize,
    paddingSize = _ref$paddingSize === void 0 ? 'm' : _ref$paddingSize,
    _ref$affordForDisplac = _ref.affordForDisplacement,
    affordForDisplacement = _ref$affordForDisplac === void 0 ? true : _ref$affordForDisplac,
    children = _ref.children,
    className = _ref.className,
    bodyClassName = _ref.bodyClassName,
    landmarkHeading = _ref.landmarkHeading,
    _ref$usePortal = _ref.usePortal,
    usePortal = _ref$usePortal === void 0 ? true : _ref$usePortal,
    _ref$left = _ref.left,
    left = _ref$left === void 0 ? 0 : _ref$left,
    _ref$right = _ref.right,
    right = _ref$right === void 0 ? 0 : _ref$right,
    _ref$bottom = _ref.bottom,
    bottom = _ref$bottom === void 0 ? 0 : _ref$bottom,
    top = _ref.top,
    style = _ref.style,
    rest = _objectWithoutProperties(_ref, _excluded);
  var styles = useEuiMemoizedStyles(euiBottomBarStyles);

  // Force some props if `fixed` position, but not if the user has supplied these
  affordForDisplacement = position !== 'fixed' ? false : affordForDisplacement;
  usePortal = position !== 'fixed' ? false : usePortal;
  var _useState = useState(null),
    _useState2 = _slicedToArray(_useState, 2),
    resizeRef = _useState2[0],
    setResizeRef = _useState2[1];
  var setRef = useCombinedRefs([setResizeRef, ref]);
  // TODO: Allow this hooke to be conditional
  var dimensions = useResizeObserver(resizeRef);
  useEffect(function () {
    if (affordForDisplacement && usePortal) {
      document.body.style.paddingBottom = "".concat(dimensions.height, "px");
    }
    if (bodyClassName) {
      document.body.classList.add(bodyClassName);
    }
    return function () {
      if (affordForDisplacement && usePortal) {
        document.body.style.paddingBottom = '';
      }
      if (bodyClassName) {
        document.body.classList.remove(bodyClassName);
      }
    };
  }, [affordForDisplacement, usePortal, dimensions, bodyClassName]);
  var classes = classNames('euiBottomBar', "euiBottomBar--".concat(position), className);
  var cssStyles = [styles.euiBottomBar, styles[position], styles[paddingSize]];
  var newStyle = _objectSpread({
    left: left,
    right: right,
    bottom: bottom,
    top: top
  }, style);
  var bar = ___EmotionJSX(React.Fragment, null, ___EmotionJSX(EuiI18n, {
    token: "euiBottomBar.screenReaderHeading",
    default: "Page level controls"
  }, function (screenReaderHeading) {
    return (
      // Though it would be better to use aria-labelledby than aria-label and not repeat the same string twice
      // A bug in voiceover won't list some landmarks in the rotor without an aria-label

      ___EmotionJSX("section", _extends({
        "aria-label": landmarkHeading ? landmarkHeading : screenReaderHeading,
        className: classes,
        css: cssStyles,
        ref: setRef,
        style: newStyle
      }, rest), ___EmotionJSX(EuiScreenReaderOnly, null, ___EmotionJSX("h2", null, landmarkHeading ? landmarkHeading : screenReaderHeading)), children)
    );
  }), ___EmotionJSX(EuiScreenReaderOnly, null, ___EmotionJSX("p", {
    "aria-live": "assertive"
  }, landmarkHeading ? ___EmotionJSX(EuiI18n, {
    token: "euiBottomBar.customScreenReaderAnnouncement",
    default: "There is a new region landmark called {landmarkHeading} with page level controls at the end of the document.",
    values: {
      landmarkHeading: landmarkHeading
    }
  }) : ___EmotionJSX(EuiI18n, {
    token: "euiBottomBar.screenReaderAnnouncement",
    default: "There is a new region landmark with page level controls at the end of the document."
  }))));
  return usePortal ? ___EmotionJSX(EuiPortal, typeof usePortal !== 'boolean' ? usePortal : undefined, bar) : bar;
});
_EuiBottomBar.propTypes = {
  className: PropTypes.string,
  "aria-label": PropTypes.string,
  "data-test-subj": PropTypes.string,
  css: PropTypes.any,
  /**
       * How to position the bottom bar against its parent.
       */
  position: PropTypes.oneOfType([PropTypes.oneOf(["fixed"]), PropTypes.oneOf(["static", "sticky"]).isRequired]),
  /**
       * Whether to wrap in an EuiPortal which appends the component to the body element.
       * Only works if `position` is `fixed`.
       */
  usePortal: PropTypes.oneOfType([PropTypes.bool.isRequired, PropTypes.shape({
    /**
       * ReactNode to render as this component's content
       */
    children: PropTypes.node.isRequired,
    /**
       * If not specified, `EuiPortal` will insert itself
       * into the end of the `document.body` by default
       */
    insert: PropTypes.shape({
      sibling: PropTypes.any.isRequired,
      position: PropTypes.any.isRequired
    }),
    /**
       * Optional ref callback
       */
    portalRef: PropTypes.func
  }).isRequired]),
  /**
       * Whether the component should apply padding on the document body element to afford for its own displacement height.
       * Only works if `usePortal` is true and `position` is `fixed`.
       */
  affordForDisplacement: PropTypes.bool,
  /**
       * Padding applied to the bar. Default is 'm'.
       */
  paddingSize: PropTypes.any,
  /**
       * Optional class applied to the body element on mount.
       */
  bodyClassName: PropTypes.string,
  /**
       * Customize the screen reader heading that helps users find this control.
       *
       * @default Page level controls
       */
  landmarkHeading: PropTypes.string,
  /**
       * Starting vertical position when `fixed` position.
       * Offset from the top of the window when `sticky` position.
       * Has no affect on `static` positions.
       */
  top: PropTypes.any,
  /**
       * Ending horizontal position when `fixed` position.
       * Has no affect on `static` or `sticky` positions.
       */
  right: PropTypes.any,
  /**
       * Starting vertical position when `fixed` position.
       * Offset from the bottom of the window when `sticky` position.
       * Has no affect on `static` positions.
       */
  bottom: PropTypes.any,
  /**
       * Starting horizontal position when `fixed` position.
       * Has no affect on `static` or `sticky` positions.
       */
  left: PropTypes.any
};
export var EuiBottomBar = /*#__PURE__*/forwardRef(function (props, ref) {
  var BottomBar = _EuiBottomBar;
  return ___EmotionJSX(EuiThemeProvider, {
    colorMode: "dark",
    wrapperProps: {
      cloneElement: true
    }
  }, ___EmotionJSX(BottomBar, _extends({
    ref: ref
  }, props)));
});
EuiBottomBar.propTypes = {
  className: PropTypes.string,
  "aria-label": PropTypes.string,
  "data-test-subj": PropTypes.string,
  css: PropTypes.any,
  /**
       * How to position the bottom bar against its parent.
       */
  position: PropTypes.oneOfType([PropTypes.oneOf(["fixed"]), PropTypes.oneOf(["static", "sticky"]).isRequired]),
  /**
       * Whether to wrap in an EuiPortal which appends the component to the body element.
       * Only works if `position` is `fixed`.
       */
  usePortal: PropTypes.oneOfType([PropTypes.bool.isRequired, PropTypes.shape({
    children: PropTypes.node.isRequired,
    insert: PropTypes.shape({
      sibling: PropTypes.any.isRequired,
      position: PropTypes.any.isRequired
    }),
    portalRef: PropTypes.func
  }).isRequired]),
  /**
       * Whether the component should apply padding on the document body element to afford for its own displacement height.
       * Only works if `usePortal` is true and `position` is `fixed`.
       */
  affordForDisplacement: PropTypes.bool,
  /**
       * Padding applied to the bar. Default is 'm'.
       */
  paddingSize: PropTypes.any,
  /**
       * Optional class applied to the body element on mount.
       */
  bodyClassName: PropTypes.string,
  /**
       * Customize the screen reader heading that helps users find this control.
       *
       * @default Page level controls
       */
  landmarkHeading: PropTypes.string,
  /**
       * Starting vertical position when `fixed` position.
       * Offset from the top of the window when `sticky` position.
       * Has no affect on `static` positions.
       */
  top: PropTypes.any,
  /**
       * Ending horizontal position when `fixed` position.
       * Has no affect on `static` or `sticky` positions.
       */
  right: PropTypes.any,
  /**
       * Starting vertical position when `fixed` position.
       * Offset from the bottom of the window when `sticky` position.
       * Has no affect on `static` positions.
       */
  bottom: PropTypes.any,
  /**
       * Starting horizontal position when `fixed` position.
       * Has no affect on `static` or `sticky` positions.
       */
  left: PropTypes.any
};
EuiBottomBar.displayName = 'EuiBottomBar';
_EuiBottomBar.displayName = 'EuiBottomBar';