function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import { css } from '@emotion/react';
import { logicalCSS } from '../../../global_styling';
import { euiFormVariables } from '../../form/form.styles';
export var euiButtonGroupStyles = {
  euiButtonGroup: /*#__PURE__*/css("display:inline-block;", logicalCSS('max-width', '100%'), " position:relative;;label:euiButtonGroup;"),
  fullWidth: process.env.NODE_ENV === "production" ? {
    name: "jl0hie-fullWidth",
    styles: "display:block;label:fullWidth;"
  } : {
    name: "jl0hie-fullWidth",
    styles: "display:block;label:fullWidth;",
    toString: _EMOTION_STRINGIFIED_CSS_ERROR__
  }
};
export var euiButtonGroupButtonsStyles = function euiButtonGroupButtonsStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  var _euiFormVariables = euiFormVariables(euiThemeContext),
    controlCompressedHeight = _euiFormVariables.controlCompressedHeight,
    controlCompressedBorderRadius = _euiFormVariables.controlCompressedBorderRadius,
    backgroundColor = _euiFormVariables.backgroundColor,
    borderColor = _euiFormVariables.borderColor;
  return {
    // Base
    euiButtonGroup__buttons: /*#__PURE__*/css(logicalCSS('max-width', '100%'), " display:flex;;label:euiButtonGroup__buttons;"),
    fullWidth: /*#__PURE__*/css(logicalCSS('width', '100%'), " .euiButtonGroupButton,.euiButtonGroup__tooltipWrapper{flex:1;", logicalCSS('width', '100%'), ";};label:fullWidth;"),
    // Sizes
    m: /*#__PURE__*/css("border-radius:", euiTheme.border.radius.medium, ";;label:m;"),
    s: /*#__PURE__*/css("border-radius:", euiTheme.border.radius.small, ";;label:s;"),
    compressed: /*#__PURE__*/css(logicalCSS('height', controlCompressedHeight), " background-color:", backgroundColor, ";border:", euiTheme.border.width.thin, " solid ", borderColor, ";border-radius:", controlCompressedBorderRadius, ";;label:compressed;")
  };
};