function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
var _excluded = ["className", "id", "isDisabled", "isIconOnly", "isSelected", "label", "value", "size", "color", "toolTipContent", "toolTipProps"];
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t.return && (u = t.return(), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import classNames from 'classnames';
import PropTypes from "prop-types";
import React from 'react';
import { useEuiMemoizedStyles } from '../../../services';
import { useEuiButtonColorCSS } from '../../../themes/amsterdam/global_styling/mixins/button';
import { useInnerText } from '../../inner_text';
import { EuiButtonDisplay } from '../button_display/_button_display';
import { euiButtonGroupButtonStyles, _compressedButtonFocusColors } from './button_group_button.styles';
import { EuiToolTip } from '../../../components/tool_tip';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiButtonGroupButton = function EuiButtonGroupButton(_ref) {
  var className = _ref.className,
    id = _ref.id,
    isDisabled = _ref.isDisabled,
    isIconOnly = _ref.isIconOnly,
    _ref$isSelected = _ref.isSelected,
    isSelected = _ref$isSelected === void 0 ? false : _ref$isSelected,
    label = _ref.label,
    value = _ref.value,
    size = _ref.size,
    _ref$color = _ref.color,
    _color = _ref$color === void 0 ? 'primary' : _ref$color,
    toolTipContent = _ref.toolTipContent,
    toolTipProps = _ref.toolTipProps,
    rest = _objectWithoutProperties(_ref, _excluded);
  var isCompressed = size === 'compressed';
  var color = isDisabled ? 'disabled' : _color;
  var display = isSelected ? 'fill' : isCompressed ? 'empty' : 'base';
  var hasToolTip = !!toolTipContent;
  var styles = useEuiMemoizedStyles(euiButtonGroupButtonStyles);
  var focusColorStyles = useEuiMemoizedStyles(_compressedButtonFocusColors);
  var buttonColorStyles = useEuiButtonColorCSS({
    display: display
  })[color];
  var cssStyles = [styles.euiButtonGroupButton, isIconOnly && styles.iconOnly, !isCompressed && (hasToolTip ? styles.uncompressed.hasToolTip : styles.uncompressed[size]), isCompressed ? styles.compressed : styles.uncompressed.uncompressed, isDisabled && isSelected ? styles.disabledAndSelected : buttonColorStyles, !isDisabled && isCompressed && focusColorStyles[color]];
  var tooltipWrapperStyles = [styles.tooltipWrapper, !isCompressed && styles.uncompressed[size]];
  var contentStyles = [styles.content.euiButtonGroupButton__content, isCompressed && styles.content.compressed];
  var textStyles = [isIconOnly ? styles.text.euiButtonGroupButton__iconOnly : styles.text.euiButtonGroupButton__text];
  var buttonClasses = classNames('euiButtonGroupButton', {
    'euiButtonGroupButton-isSelected': isSelected,
    'euiButtonGroupButton-isIconOnly': isIconOnly
  }, className);

  /**
   * Because the selected buttons also increase their text weight to 'bold',
   * we don't want the whole button size to shift when selected, so we determine
   * the base width of the button via the `euiTextShift()` method in SASS.
   */
  var _useInnerText = useInnerText(),
    _useInnerText2 = _slicedToArray(_useInnerText, 2),
    buttonTextRef = _useInnerText2[0],
    innerText = _useInnerText2[1];
  return ___EmotionJSX(EuiButtonGroupButtonWithToolTip, {
    toolTipContent: toolTipContent,
    toolTipProps: toolTipProps,
    wrapperCss: tooltipWrapperStyles,
    isSelected: isSelected
  }, ___EmotionJSX(EuiButtonDisplay, _extends({
    css: cssStyles,
    className: buttonClasses,
    isDisabled: isDisabled,
    size: size === 'compressed' ? 's' : size,
    contentProps: {
      css: contentStyles
    },
    textProps: {
      css: textStyles,
      ref: buttonTextRef,
      'data-text': innerText
    },
    title: innerText,
    "data-test-subj": id,
    isSelected: isSelected
  }, rest), label));
};
EuiButtonGroupButton.propTypes = {
  /**
     * Each option must have a unique `id` for maintaining selection
     */
  id: PropTypes.string.isRequired,
  /**
     * Each option must have a `label` even for icons which will be applied as the `aria-label`
     */
  label: PropTypes.node.isRequired,
  isDisabled: PropTypes.bool,
  /**
     * The value of the radio input.
     */
  value: PropTypes.any,
  /**
     * The type of the underlying HTML button
     */
  type: PropTypes.any,
  /**
     * By default, will use the button text for the native browser title.
     *
     * This can be either customized or unset via `title: ''` if necessary.
     */
  title: PropTypes.any,
  /**
     * Optional custom tooltip content for the button
     */
  toolTipContent: PropTypes.node,
  /**
     * Optional props to pass to the underlying **[EuiToolTip](/#/display/tooltip)**
     */
  toolTipProps: PropTypes.any,
  /**
     * Any `type` accepted by EuiIcon
     */
  iconType: PropTypes.oneOfType([PropTypes.oneOf(["accessibility", "addDataApp", "advancedSettingsApp", "agentApp", "aggregate", "analyzeEvent", "annotation", "anomalyChart", "anomalySwimLane", "apmApp", "apmTrace", "appSearchApp", "apps", "arrowDown", "arrowLeft", "arrowRight", "arrowUp", "arrowStart", "arrowEnd", "article", "asterisk", "at", "auditbeatApp", "beaker", "bell", "bellSlash", "beta", "bolt", "boxesHorizontal", "boxesVertical", "branch", "branchUser", "broom", "brush", "bug", "bullseye", "calendar", "canvasApp", "casesApp", "changePointDetection", "check", "checkInCircleFilled", "cheer", "classificationJob", "clickLeft", "clickRight", "clock", "clockCounter", "cloudDrizzle", "cloudStormy", "cloudSunny", "cluster", "codeApp", "color", "compute", "console", "consoleApp", "container", "continuityAbove", "continuityAboveBelow", "continuityBelow", "continuityWithin", "contrast", "contrastHigh", "controlsHorizontal", "controlsVertical", "copy", "copyClipboard", "createAdvancedJob", "createGenericJob", "createGeoJob", "createMultiMetricJob", "createPopulationJob", "createSingleMetricJob", "cross", "crossClusterReplicationApp", "crossInCircle", "crosshairs", "currency", "cut", "dashboardApp", "dataVisualizer", "database", "desktop", "devToolsApp", "diff", "discoverApp", "discuss", "document", "documentEdit", "documentation", "documents", "dot", "dotInCircle", "doubleArrowLeft", "doubleArrowRight", "download", "editorAlignCenter", "editorAlignLeft", "editorAlignRight", "editorBold", "editorChecklist", "editorCodeBlock", "editorComment", "editorDistributeHorizontal", "editorDistributeVertical", "editorHeading", "editorItalic", "editorItemAlignBottom", "editorItemAlignCenter", "editorItemAlignLeft", "editorItemAlignMiddle", "editorItemAlignRight", "editorItemAlignTop", "editorLink", "editorOrderedList", "editorPositionBottomLeft", "editorPositionBottomRight", "editorPositionTopLeft", "editorPositionTopRight", "editorRedo", "editorStrike", "editorTable", "editorUnderline", "editorUndo", "editorUnorderedList", "email", "empty", "emsApp", "endpoint", "eql", "eraser", "error", "errorFilled", "esqlVis", "exit", "expand", "expandMini", "exportAction", "eye", "eyeClosed", "faceHappy", "faceNeutral", "faceSad", "fieldStatistics", "filebeatApp", "filter", "filterExclude", "filterIgnore", "filterInclude", "filterInCircle", "flag", "fleetApp", "fold", "folderCheck", "folderClosed", "folderExclamation", "folderOpen", "frameNext", "framePrevious", "fullScreen", "fullScreenExit", "function", "gear", "gisApp", "glasses", "globe", "grab", "grabHorizontal", "grabOmnidirectional", "gradient", "graphApp", "grid", "grokApp", "heart", "heartbeatApp", "heatmap", "help", "home", "iInCircle", "image", "importAction", "index", "indexClose", "indexEdit", "indexFlush", "indexManagementApp", "indexMapping", "indexOpen", "indexPatternApp", "indexRollupApp", "indexRuntime", "indexSettings", "indexTemporary", "infinity", "inputOutput", "inspect", "invert", "ip", "key", "keyboard", "kqlField", "kqlFunction", "kqlOperand", "kqlSelector", "kqlValue", "kubernetesNode", "kubernetesPod", "launch", "layers", "lensApp", "lettering", "lineDashed", "lineDotted", "lineSolid", "link", "list", "listAdd", "lock", "lockOpen", "logPatternAnalysis", "logRateAnalysis", "logoAWS", "logoAWSMono", "logoAerospike", "logoApache", "logoAppSearch", "logoAzure", "logoAzureMono", "logoBeats", "logoBusinessAnalytics", "logoCeph", "logoCloud", "logoCloudEnterprise", "logoCode", "logoCodesandbox", "logoCouchbase", "logoDocker", "logoDropwizard", "logoElastic", "logoElasticStack", "logoElasticsearch", "logoEnterpriseSearch", "logoEtcd", "logoGCP", "logoGCPMono", "logoGithub", "logoGmail", "logoGolang", "logoGoogleG", "logoHAproxy", "logoIBM", "logoIBMMono", "logoKafka", "logoKibana", "logoKubernetes", "logoLogging", "logoLogstash", "logoMaps", "logoMemcached", "logoMetrics", "logoMongodb", "logoMySQL", "logoNginx", "logoObservability", "logoOsquery", "logoPhp", "logoPostgres", "logoPrometheus", "logoRabbitmq", "logoRedis", "logoSecurity", "logoSiteSearch", "logoSketch", "logoSlack", "logoUptime", "logoVulnerabilityManagement", "logoWebhook", "logoWindows", "logoWorkplaceSearch", "logsApp", "logstashFilter", "logstashIf", "logstashInput", "logstashOutput", "logstashQueue", "machineLearningApp", "magnet", "magnifyWithExclamation", "magnifyWithMinus", "magnifyWithPlus", "managementApp", "mapMarker", "memory", "menu", "menuDown", "menuLeft", "menuRight", "menuUp", "merge", "metricbeatApp", "metricsApp", "minimize", "minus", "minusInCircle", "minusInCircleFilled", "minusInSquare", "mobile", "monitoringApp", "moon", "move", "namespace", "nested", "newChat", "node", "notebookApp", "number", "offline", "online", "outlierDetectionJob", "package", "packetbeatApp", "pageSelect", "pagesSelect", "palette", "paperClip", "partial", "pause", "payment", "pencil", "percent", "pin", "pinFilled", "pipeBreaks", "pipelineApp", "pipeNoBreaks", "pivot", "play", "playFilled", "plus", "plusInCircle", "plusInCircleFilled", "plusInSquare", "popout", "push", "questionInCircle", "quote", "recentlyViewedApp", "refresh", "regressionJob", "reporter", "reportingApp", "returnKey", "save", "savedObjectsApp", "scale", "search", "searchProfilerApp", "section", "securityAnalyticsApp", "securityApp", "securitySignal", "securitySignalDetected", "securitySignalResolved", "sessionViewer", "shard", "share", "singleMetricViewer", "snowflake", "sortAscending", "sortDescending", "sortDown", "sortLeft", "sortRight", "sortUp", "sortable", "spaces", "spacesApp", "sparkles", "sqlApp", "starEmpty", "starEmptySpace", "starFilled", "starFilledSpace", "starMinusEmpty", "starMinusFilled", "starPlusEmpty", "starPlusFilled", "stats", "stop", "stopFilled", "stopSlash", "storage", "string", "submodule", "sun", "swatchInput", "symlink", "tableDensityCompact", "tableDensityExpanded", "tableDensityNormal", "tableOfContents", "tag", "tear", "temperature", "timeline", "timelineWithArrow", "timelionApp", "timeRefresh", "timeslider", "training", "transitionLeftIn", "transitionLeftOut", "transitionTopIn", "transitionTopOut", "trash", "unfold", "unlink", "upgradeAssistantApp", "uptimeApp", "user", "userAvatar", "users", "usersRolesApp", "vector", "videoPlayer", "visArea", "visAreaStacked", "visBarHorizontal", "visBarHorizontalStacked", "visBarVertical", "visBarVerticalStacked", "visGauge", "visGoal", "visLine", "visMapCoordinate", "visMapRegion", "visMetric", "visPie", "visTable", "visTagCloud", "visText", "visTimelion", "visVega", "visVisualBuilder", "visualizeApp", "vulnerabilityManagementApp", "warning", "warningFilled", "alert", "watchesApp", "wordWrap", "wordWrapDisabled", "workplaceSearchApp", "wrench", "tokenAlias", "tokenAnnotation", "tokenArray", "tokenBinary", "tokenBoolean", "tokenClass", "tokenCompletionSuggester", "tokenConstant", "tokenDate", "tokenDimension", "tokenElement", "tokenEnum", "tokenEnumMember", "tokenEvent", "tokenException", "tokenField", "tokenFile", "tokenFlattened", "tokenFunction", "tokenGeo", "tokenHistogram", "tokenInterface", "tokenIP", "tokenJoin", "tokenKey", "tokenKeyword", "tokenMethod", "tokenMetricCounter", "tokenMetricGauge", "tokenModule", "tokenNamespace", "tokenNested", "tokenNull", "tokenNumber", "tokenObject", "tokenOperator", "tokenPackage", "tokenParameter", "tokenPercolator", "tokenProperty", "tokenRange", "tokenRankFeature", "tokenRankFeatures", "tokenRepo", "tokenSearchType", "tokenSemanticText", "tokenShape", "tokenString", "tokenStruct", "tokenSymbol", "tokenTag", "tokenText", "tokenTokenCount", "tokenVariable", "tokenVectorDense", "tokenDenseVector", "tokenVectorSparse"]).isRequired, PropTypes.string.isRequired, PropTypes.elementType.isRequired]),
  /**
     * Can only be one side `left` or `right`
     */
  iconSide: PropTypes.oneOfType([PropTypes.any.isRequired, PropTypes.oneOf([undefined])]),
  isLoading: PropTypes.bool,
  /**
     * Object of props passed to the `<span>` wrapping the content's text/children only (not icon)
     *
     * This span wrapper can be removed by passing `textProps={false}`.
     */
  textProps: PropTypes.oneOfType([PropTypes.shape({
    className: PropTypes.string,
    "aria-label": PropTypes.string,
    "data-test-subj": PropTypes.string,
    css: PropTypes.any,
    ref: PropTypes.any,
    "data-text": PropTypes.string
  }).isRequired, PropTypes.oneOf([false])]),
  iconSize: PropTypes.any,
  className: PropTypes.string,
  "aria-label": PropTypes.string,
  "data-test-subj": PropTypes.string,
  css: PropTypes.any,
  /**
     * Styles the selected button to look selected (usually with `fill`)
     */
  isSelected: PropTypes.bool,
  /**
     * Inherit from EuiButtonGroup
     */
  color: PropTypes.any.isRequired,
  /**
     * Inherit from EuiButtonGroup
     */
  size: PropTypes.any.isRequired,
  /**
     * Inherit from EuiButtonGroup
     */
  isIconOnly: PropTypes.bool.isRequired,
  /**
     * Inherit from EuiButtonGroup
     */
  onClick: PropTypes.func.isRequired
};
var EuiButtonGroupButtonWithToolTip = function EuiButtonGroupButtonWithToolTip(_ref2) {
  var _toolTipProps$anchorP, _toolTipProps$anchorP2;
  var toolTipContent = _ref2.toolTipContent,
    toolTipProps = _ref2.toolTipProps,
    wrapperCss = _ref2.wrapperCss,
    isSelected = _ref2.isSelected,
    children = _ref2.children;
  return toolTipContent ? ___EmotionJSX(EuiToolTip, _extends({
    content: toolTipContent,
    position: "top"
  }, toolTipProps, {
    anchorProps: _objectSpread(_objectSpread({}, toolTipProps === null || toolTipProps === void 0 ? void 0 : toolTipProps.anchorProps), {}, {
      className: classNames('euiButtonGroup__tooltipWrapper', {
        'euiButtonGroup__tooltipWrapper-isSelected': isSelected
      }, toolTipProps === null || toolTipProps === void 0 || (_toolTipProps$anchorP = toolTipProps.anchorProps) === null || _toolTipProps$anchorP === void 0 ? void 0 : _toolTipProps$anchorP.className),
      css: [wrapperCss, toolTipProps === null || toolTipProps === void 0 || (_toolTipProps$anchorP2 = toolTipProps.anchorProps) === null || _toolTipProps$anchorP2 === void 0 ? void 0 : _toolTipProps$anchorP2.css]
    })
  }), children) : children;
};
EuiButtonGroupButtonWithToolTip.propTypes = {
  children: PropTypes.element.isRequired,
  wrapperCss: PropTypes.any.isRequired,
  isSelected: PropTypes.bool.isRequired
};