function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
var _excluded = ["className", "description", "isDisabled", "title", "titleElement", "titleSize", "icon", "image", "children", "footer", "onClick", "href", "rel", "target", "textAlign", "betaBadgeProps", "layout", "selectable", "display", "paddingSize"],
  _excluded2 = ["anchorProps"];
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { isValidElement } from 'react';
import PropTypes from "prop-types";
import classNames from 'classnames';
import { getSecureRelForTarget, useEuiTheme, cloneElementWithCss } from '../../services';
import { useGeneratedHtmlId } from '../../services/accessibility';
import { validateHref } from '../../services/security/href_validator';
import { EuiText } from '../text';
import { EuiTitle } from '../title';
import { EuiBetaBadge } from '../badge/beta_badge';
import { EuiPanel } from '../panel';
import { EuiSpacer } from '../spacer';
import { EuiCardSelect } from './card_select';
import { euiCardBetaBadgeStyles, euiCardStyles, euiCardTextStyles } from './card.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var ALIGNMENTS = ['left', 'center', 'right'];

/**
 * Certain props are only allowed when the layout is vertical
 */

export var EuiCard = function EuiCard(_ref) {
  var className = _ref.className,
    description = _ref.description,
    _isDisabled = _ref.isDisabled,
    title = _ref.title,
    _ref$titleElement = _ref.titleElement,
    titleElement = _ref$titleElement === void 0 ? 'p' : _ref$titleElement,
    _ref$titleSize = _ref.titleSize,
    titleSize = _ref$titleSize === void 0 ? 's' : _ref$titleSize,
    icon = _ref.icon,
    image = _ref.image,
    children = _ref.children,
    footer = _ref.footer,
    onClick = _ref.onClick,
    href = _ref.href,
    rel = _ref.rel,
    target = _ref.target,
    _ref$textAlign = _ref.textAlign,
    textAlign = _ref$textAlign === void 0 ? 'center' : _ref$textAlign,
    betaBadgeProps = _ref.betaBadgeProps,
    _ref$layout = _ref.layout,
    layout = _ref$layout === void 0 ? 'vertical' : _ref$layout,
    selectable = _ref.selectable,
    display = _ref.display,
    _ref$paddingSize = _ref.paddingSize,
    paddingSize = _ref$paddingSize === void 0 ? 'm' : _ref$paddingSize,
    rest = _objectWithoutProperties(_ref, _excluded);
  var isHrefValid = !href || validateHref(href);
  var isDisabled = _isDisabled || !isHrefValid;
  var isClickable = !isDisabled && (onClick || href || selectable && !selectable.isDisabled);
  var euiThemeContext = useEuiTheme();
  var styles = euiCardStyles(euiThemeContext, paddingSize);
  var cardStyles = [styles.card.euiCard,
  // Text alignment should always be left when horizontal
  styles.card.aligned[layout === 'horizontal' ? 'left' : textAlign], isDisabled && styles.card.disabled];
  var contentStyles = [styles.content.euiCard__content, styles.content.layout[layout]];
  var mainStyles = [styles.main.euiCard__main, styles.main.layout[layout]];
  var textStyles = euiCardTextStyles(euiThemeContext);
  var textCSS = [textStyles.euiCard__text,
  // Text alignment should always be left when horizontal
  textStyles.aligned[layout === 'horizontal' ? 'left' : textAlign], isClickable && textStyles.interactive, isDisabled && textStyles.disabled];

  /**
   * For a11y, we simulate the same click that's provided on the title when clicking the whole card
   * without having to make the whole card a button or anchor tag.
   * *Card Accessibility: The redundant click event https://inclusive-components.design/cards/*
   */
  var link = null;
  var outerOnClick = function outerOnClick(e) {
    if (link && link !== e.target && !link.contains(e.target)) {
      link.click();
    }
  };
  if (layout === 'horizontal') {
    if (image || footer || textAlign !== 'center') {
      throw new Error('EuiCard: `layout="horizontal"` cannot be used in conjunction with `image`, `footer`, or `textAlign`.');
    }
  }
  var classes = classNames('euiCard', className);
  var ariaId = useGeneratedHtmlId();
  var ariaDesc = description ? "".concat(ariaId, "Description") : '';

  /**
   * Top area containing image, icon or both
   */

  var imageNode;
  if (image && layout === 'vertical') {
    if ( /*#__PURE__*/isValidElement(image) || typeof image === 'string') {
      var imageStyles = [styles.image.euiCard__image, display === 'transparent' && styles.image.transparent];
      imageNode = ___EmotionJSX("div", {
        className: "euiCard__image",
        css: imageStyles
      }, /*#__PURE__*/isValidElement(image) ? image : ___EmotionJSX("img", {
        src: image,
        alt: ""
      }));
    } else {
      imageNode = null;
    }
  }
  var iconNode;
  if (icon) {
    var iconStyles = [styles.icon.euiCard__icon, styles.icon.layout[layout], imageNode && styles.icon.withImage];
    iconNode = cloneElementWithCss(icon, {
      className: classNames(icon.props.className, 'euiCard__icon'),
      css: iconStyles
    });
  }
  var optionalCardTop;
  if (imageNode || iconNode) {
    var topStyles = [styles.top.euiCard__top, styles.top.layout[layout], isDisabled && styles.top.disabled];
    optionalCardTop = ___EmotionJSX("div", {
      className: "euiCard__top",
      css: topStyles
    }, imageNode, iconNode);
  }

  /**
   * Optional EuiBetaBadge
   */

  var optionalBetaBadge;
  var optionalBetaBadgeID = '';
  var optionalBetaCSS;
  if (betaBadgeProps !== null && betaBadgeProps !== void 0 && betaBadgeProps.label) {
    var betaStyles = euiCardBetaBadgeStyles(euiThemeContext, paddingSize);
    optionalBetaCSS = betaStyles.hasBetaBadge;
    var anchorProps = betaBadgeProps.anchorProps,
      cleanedBetaBadgeProps = _objectWithoutProperties(betaBadgeProps, _excluded2);
    var anchorCSS = [betaStyles.euiCard__betaBadgeAnchor, anchorProps === null || anchorProps === void 0 ? void 0 : anchorProps.css];
    var badgeCSS = [betaStyles.euiCard__betaBadge, betaBadgeProps === null || betaBadgeProps === void 0 ? void 0 : betaBadgeProps.css];
    optionalBetaBadgeID = "".concat(ariaId, "BetaBadge");
    optionalBetaBadge = ___EmotionJSX(EuiBetaBadge, _extends({
      color: isDisabled && !betaBadgeProps.onClick && !betaBadgeProps.href ? 'subdued' : 'hollow'
    }, cleanedBetaBadgeProps, {
      css: badgeCSS,
      anchorProps: _objectSpread(_objectSpread({}, anchorProps), {}, {
        css: anchorCSS
      }),
      id: optionalBetaBadgeID
    }));

    // Increase padding size when there is a beta badge unless it's already determined
    // paddingSize = paddingSize || 'l';
  }

  /**
   * Optional selectable button
   */

  if (selectable && isDisabled && selectable.isDisabled === undefined) {
    selectable.isDisabled = isDisabled;
  }
  var optionalSelectButton;
  if (selectable) {
    optionalSelectButton = ___EmotionJSX(React.Fragment, null, paddingSize !== 'none' && ___EmotionJSX(EuiSpacer, {
      size: paddingSize || 'm'
    }), ___EmotionJSX(EuiCardSelect, _extends({
      "aria-describedby": "".concat(ariaId, "Title ").concat(ariaDesc)
    }, selectable, {
      buttonRef: function buttonRef(node) {
        link = node;
      }
    })));
  }
  var TitleElement = titleElement;

  /**
   * Wraps the title with the link (<a>) or button.
   * This makes the title element a11y friendly and gets described by its content if its interactable.
   */

  var theTitle;
  if (!isDisabled && href) {
    theTitle = ___EmotionJSX("a", {
      className: "euiCard__titleAnchor",
      css: textCSS,
      onClick: onClick,
      href: href,
      target: target,
      "aria-describedby": ariaDesc,
      rel: getSecureRelForTarget({
        href: href,
        target: target,
        rel: rel
      }),
      ref: function ref(node) {
        link = node;
      }
    }, title);
  } else if (isDisabled || onClick) {
    theTitle = ___EmotionJSX("button", {
      className: "euiCard__titleButton",
      css: textCSS,
      onClick: onClick,
      disabled: isDisabled,
      "aria-describedby": "".concat(optionalBetaBadgeID, " ").concat(ariaDesc),
      ref: function ref(node) {
        link = node;
      }
    }, title);
  } else {
    theTitle = ___EmotionJSX("span", {
      css: textCSS
    }, title);
  }

  /**
   * Children and/or Description content
   */
  var optionalChildren;
  if (children) {
    var childrenStyles = [styles.euiCard__children];
    optionalChildren = ___EmotionJSX("div", {
      css: childrenStyles
    }, children);
  }
  var optionalDescription;
  if (description) {
    var descriptionStyles = [styles.euiCard__description];
    optionalDescription = ___EmotionJSX(EuiText, {
      id: ariaDesc,
      size: "s",
      css: descriptionStyles
    }, ___EmotionJSX("p", null, description));
  }

  /**
   * Footer content
   */
  var optionalFooter;
  if (layout === 'vertical' && footer) {
    var footerStyles = [styles.euiCard__footer];
    optionalFooter = ___EmotionJSX("div", {
      css: footerStyles
    }, footer);
  }
  return ___EmotionJSX(EuiPanel, _extends({
    element: "div",
    className: classes,
    css: [].concat(cardStyles, [optionalBetaCSS]),
    onClick: isClickable ? outerOnClick : undefined,
    color: isDisabled ? 'subdued' : display,
    hasShadow: isDisabled || display ? false : true,
    hasBorder: display ? false : undefined,
    paddingSize: paddingSize
  }, rest), ___EmotionJSX("div", {
    className: "euiCard__main",
    css: mainStyles
  }, optionalCardTop, ___EmotionJSX("div", {
    className: "euiCard__content",
    css: contentStyles
  }, ___EmotionJSX(EuiTitle, {
    id: "".concat(ariaId, "Title"),
    className: "euiCard__title",
    size: titleSize
  }, ___EmotionJSX(TitleElement, null, theTitle)), optionalDescription, optionalChildren), optionalBetaBadge, optionalFooter), optionalSelectButton);
};
EuiCard.propTypes = {
  /**
       * Change to "horizontal" if you need the icon to be left of the content.
       * Horizontal layouts cannot be used in conjunction with `image`, `footer`, or `textAlign`.
       */
  layout: PropTypes.oneOfType([PropTypes.oneOf(["vertical"]), PropTypes.oneOf(["horizontal"]).isRequired]),
  /**
       * Changes alignment of the title and description
       */
  textAlign: PropTypes.any,
  /**
       * Accepts any combination of elements
       */
  footer: PropTypes.node,
  /**
       * Accepts a url in string form or ReactElement for a custom image component
       */
  image: PropTypes.oneOfType([PropTypes.string.isRequired, PropTypes.element.isRequired]),
  /**
       * Cards are required to have at least a title and a description and/or children
       */
  title: PropTypes.any.isRequired,
  /**
       * Determines the title's heading element
       */
  titleElement: PropTypes.oneOf(["h2", "h3", "h4", "h5", "h6", "span", "p"]),
  /**
       * Determines the title's size, matching that of EuiTitle.
       * Though, card titles can't be too large or small relative to the description text.
       */
  titleSize: PropTypes.oneOf(["s", "xs"]),
  /**
       * Placed within a small EuiText `<p>` tag
       */
  description: PropTypes.any,
  /**
       * Accepts an `<EuiIcon>` node or `null`
       */
  icon: PropTypes.oneOfType([PropTypes.element.isRequired, PropTypes.oneOf([null])]),
  /**
       * Custom children
       */
  children: PropTypes.node,
  /**
       * Use only if you want to forego a button in the footer and make the whole card clickable
       */
  onClick: PropTypes.oneOfType([PropTypes.func.isRequired, PropTypes.func.isRequired]),
  isDisabled: PropTypes.bool,
  href: PropTypes.string,
  target: PropTypes.string,
  rel: PropTypes.string,
  /**
       * Adds a badge to top of the card to label it as "Beta" or other non-GA state.
       * Accepts all the props of [EuiBetaBadge](#/display/badge#beta-badge-type), where `label` is required.
       */
  betaBadgeProps: PropTypes.shape({
    className: PropTypes.string,
    "aria-label": PropTypes.string,
    "data-test-subj": PropTypes.string,
    css: PropTypes.any,
    /**
       * Will apply an onclick to the badge itself
       */
    onClick: PropTypes.func,
    /**
       * Aria label applied to the onClick button
       */
    onClickAriaLabel: PropTypes.any,
    href: PropTypes.string,
    target: PropTypes.string,
    rel: PropTypes.string,
    /**
       * Supply an icon type if the badge should just be an icon
       */
    iconType: PropTypes.oneOfType([PropTypes.oneOf(["accessibility", "addDataApp", "advancedSettingsApp", "agentApp", "aggregate", "analyzeEvent", "annotation", "anomalyChart", "anomalySwimLane", "apmApp", "apmTrace", "appSearchApp", "apps", "arrowDown", "arrowLeft", "arrowRight", "arrowUp", "arrowStart", "arrowEnd", "article", "asterisk", "at", "auditbeatApp", "beaker", "bell", "bellSlash", "beta", "bolt", "boxesHorizontal", "boxesVertical", "branch", "branchUser", "broom", "brush", "bug", "bullseye", "calendar", "canvasApp", "casesApp", "changePointDetection", "check", "checkInCircleFilled", "cheer", "classificationJob", "clickLeft", "clickRight", "clock", "clockCounter", "cloudDrizzle", "cloudStormy", "cloudSunny", "cluster", "codeApp", "color", "compute", "console", "consoleApp", "container", "continuityAbove", "continuityAboveBelow", "continuityBelow", "continuityWithin", "contrast", "contrastHigh", "controlsHorizontal", "controlsVertical", "copy", "copyClipboard", "createAdvancedJob", "createGenericJob", "createGeoJob", "createMultiMetricJob", "createPopulationJob", "createSingleMetricJob", "cross", "crossClusterReplicationApp", "crossInCircle", "crosshairs", "currency", "cut", "dashboardApp", "dataVisualizer", "database", "desktop", "devToolsApp", "diff", "discoverApp", "discuss", "document", "documentEdit", "documentation", "documents", "dot", "dotInCircle", "doubleArrowLeft", "doubleArrowRight", "download", "editorAlignCenter", "editorAlignLeft", "editorAlignRight", "editorBold", "editorChecklist", "editorCodeBlock", "editorComment", "editorDistributeHorizontal", "editorDistributeVertical", "editorHeading", "editorItalic", "editorItemAlignBottom", "editorItemAlignCenter", "editorItemAlignLeft", "editorItemAlignMiddle", "editorItemAlignRight", "editorItemAlignTop", "editorLink", "editorOrderedList", "editorPositionBottomLeft", "editorPositionBottomRight", "editorPositionTopLeft", "editorPositionTopRight", "editorRedo", "editorStrike", "editorTable", "editorUnderline", "editorUndo", "editorUnorderedList", "email", "empty", "emsApp", "endpoint", "eql", "eraser", "error", "errorFilled", "esqlVis", "exit", "expand", "expandMini", "exportAction", "eye", "eyeClosed", "faceHappy", "faceNeutral", "faceSad", "fieldStatistics", "filebeatApp", "filter", "filterExclude", "filterIgnore", "filterInclude", "filterInCircle", "flag", "fleetApp", "fold", "folderCheck", "folderClosed", "folderExclamation", "folderOpen", "frameNext", "framePrevious", "fullScreen", "fullScreenExit", "function", "gear", "gisApp", "glasses", "globe", "grab", "grabHorizontal", "grabOmnidirectional", "gradient", "graphApp", "grid", "grokApp", "heart", "heartbeatApp", "heatmap", "help", "home", "iInCircle", "image", "importAction", "index", "indexClose", "indexEdit", "indexFlush", "indexManagementApp", "indexMapping", "indexOpen", "indexPatternApp", "indexRollupApp", "indexRuntime", "indexSettings", "indexTemporary", "infinity", "inputOutput", "inspect", "invert", "ip", "key", "keyboard", "kqlField", "kqlFunction", "kqlOperand", "kqlSelector", "kqlValue", "kubernetesNode", "kubernetesPod", "launch", "layers", "lensApp", "lettering", "lineDashed", "lineDotted", "lineSolid", "link", "list", "listAdd", "lock", "lockOpen", "logPatternAnalysis", "logRateAnalysis", "logoAWS", "logoAWSMono", "logoAerospike", "logoApache", "logoAppSearch", "logoAzure", "logoAzureMono", "logoBeats", "logoBusinessAnalytics", "logoCeph", "logoCloud", "logoCloudEnterprise", "logoCode", "logoCodesandbox", "logoCouchbase", "logoDocker", "logoDropwizard", "logoElastic", "logoElasticStack", "logoElasticsearch", "logoEnterpriseSearch", "logoEtcd", "logoGCP", "logoGCPMono", "logoGithub", "logoGmail", "logoGolang", "logoGoogleG", "logoHAproxy", "logoIBM", "logoIBMMono", "logoKafka", "logoKibana", "logoKubernetes", "logoLogging", "logoLogstash", "logoMaps", "logoMemcached", "logoMetrics", "logoMongodb", "logoMySQL", "logoNginx", "logoObservability", "logoOsquery", "logoPhp", "logoPostgres", "logoPrometheus", "logoRabbitmq", "logoRedis", "logoSecurity", "logoSiteSearch", "logoSketch", "logoSlack", "logoUptime", "logoVulnerabilityManagement", "logoWebhook", "logoWindows", "logoWorkplaceSearch", "logsApp", "logstashFilter", "logstashIf", "logstashInput", "logstashOutput", "logstashQueue", "machineLearningApp", "magnet", "magnifyWithExclamation", "magnifyWithMinus", "magnifyWithPlus", "managementApp", "mapMarker", "memory", "menu", "menuDown", "menuLeft", "menuRight", "menuUp", "merge", "metricbeatApp", "metricsApp", "minimize", "minus", "minusInCircle", "minusInCircleFilled", "minusInSquare", "mobile", "monitoringApp", "moon", "move", "namespace", "nested", "newChat", "node", "notebookApp", "number", "offline", "online", "outlierDetectionJob", "package", "packetbeatApp", "pageSelect", "pagesSelect", "palette", "paperClip", "partial", "pause", "payment", "pencil", "percent", "pin", "pinFilled", "pipeBreaks", "pipelineApp", "pipeNoBreaks", "pivot", "play", "playFilled", "plus", "plusInCircle", "plusInCircleFilled", "plusInSquare", "popout", "push", "questionInCircle", "quote", "recentlyViewedApp", "refresh", "regressionJob", "reporter", "reportingApp", "returnKey", "save", "savedObjectsApp", "scale", "search", "searchProfilerApp", "section", "securityAnalyticsApp", "securityApp", "securitySignal", "securitySignalDetected", "securitySignalResolved", "sessionViewer", "shard", "share", "singleMetricViewer", "snowflake", "sortAscending", "sortDescending", "sortDown", "sortLeft", "sortRight", "sortUp", "sortable", "spaces", "spacesApp", "sparkles", "sqlApp", "starEmpty", "starEmptySpace", "starFilled", "starFilledSpace", "starMinusEmpty", "starMinusFilled", "starPlusEmpty", "starPlusFilled", "stats", "stop", "stopFilled", "stopSlash", "storage", "string", "submodule", "sun", "swatchInput", "symlink", "tableDensityCompact", "tableDensityExpanded", "tableDensityNormal", "tableOfContents", "tag", "tear", "temperature", "timeline", "timelineWithArrow", "timelionApp", "timeRefresh", "timeslider", "training", "transitionLeftIn", "transitionLeftOut", "transitionTopIn", "transitionTopOut", "trash", "unfold", "unlink", "upgradeAssistantApp", "uptimeApp", "user", "userAvatar", "users", "usersRolesApp", "vector", "videoPlayer", "visArea", "visAreaStacked", "visBarHorizontal", "visBarHorizontalStacked", "visBarVertical", "visBarVerticalStacked", "visGauge", "visGoal", "visLine", "visMapCoordinate", "visMapRegion", "visMetric", "visPie", "visTable", "visTagCloud", "visText", "visTimelion", "visVega", "visVisualBuilder", "visualizeApp", "vulnerabilityManagementApp", "warning", "warningFilled", "alert", "watchesApp", "wordWrap", "wordWrapDisabled", "workplaceSearchApp", "wrench", "tokenAlias", "tokenAnnotation", "tokenArray", "tokenBinary", "tokenBoolean", "tokenClass", "tokenCompletionSuggester", "tokenConstant", "tokenDate", "tokenDimension", "tokenElement", "tokenEnum", "tokenEnumMember", "tokenEvent", "tokenException", "tokenField", "tokenFile", "tokenFlattened", "tokenFunction", "tokenGeo", "tokenHistogram", "tokenInterface", "tokenIP", "tokenJoin", "tokenKey", "tokenKeyword", "tokenMethod", "tokenMetricCounter", "tokenMetricGauge", "tokenModule", "tokenNamespace", "tokenNested", "tokenNull", "tokenNumber", "tokenObject", "tokenOperator", "tokenPackage", "tokenParameter", "tokenPercolator", "tokenProperty", "tokenRange", "tokenRankFeature", "tokenRankFeatures", "tokenRepo", "tokenSearchType", "tokenSemanticText", "tokenShape", "tokenString", "tokenStruct", "tokenSymbol", "tokenTag", "tokenText", "tokenTokenCount", "tokenVariable", "tokenVectorDense", "tokenDenseVector", "tokenVectorSparse"]).isRequired, PropTypes.string.isRequired, PropTypes.elementType.isRequired]),
    /**
       * One word label like "Beta" or "Lab"
       */
    /**
       * One word label like "Beta" or "Lab"
       */
    label: PropTypes.oneOfType([PropTypes.node.isRequired, PropTypes.oneOfType([PropTypes.node.isRequired, PropTypes.string.isRequired]).isRequired]).isRequired,
    /**
       * Content for the tooltip
       */
    tooltipContent: PropTypes.oneOfType([PropTypes.node, PropTypes.oneOfType([PropTypes.node, PropTypes.node.isRequired])]),
    /**
       * Custom position of the tooltip
       */
    tooltipPosition: PropTypes.oneOf(["top", "right", "bottom", "left"]),
    /**
       * Passes onto the span wrapping the badge
       */
    anchorProps: PropTypes.shape({
      className: PropTypes.string,
      "aria-label": PropTypes.string,
      "data-test-subj": PropTypes.string,
      css: PropTypes.any
    }),
    /**
       * Optional title will be supplied as tooltip title or title attribute
       * otherwise the label will be used
       */
    title: PropTypes.oneOfType([PropTypes.string, PropTypes.oneOfType([PropTypes.string.isRequired, PropTypes.string])]),
    /**
       * Accepts accent, subdued, hollow and warning.
       */
    color: PropTypes.any,
    size: PropTypes.any,
    /**
       * Sets the `vertical-align` CSS property
       */
    alignment: PropTypes.any
  }),
  /**
       * Matches to the color property of EuiPanel. If defined, removes any border & shadow.
       * Leave as `undefined` to display as a default panel.
       * Selectable cards will always display as a default panel.
       */
  display: PropTypes.any,
  /**
       * Padding applied around the content of the card
       */
  paddingSize: PropTypes.any,
  /**
       * Adds a button to the bottom of the card to allow for in-place selection
       */
  selectable: PropTypes.shape({
    href: PropTypes.string,
    onClick: PropTypes.func,
    children: PropTypes.node,
    /**
       * Make button a solid color for prominence
       */
    /**
       * Make button a solid color for prominence
       */
    fill: PropTypes.bool,
    /**
       * Any of the named color palette options.
       */
    color: PropTypes.any,
    /**
       * Use size `s` in confined spaces
       */
    /**
       * Use size `s` in confined spaces
       */
    size: PropTypes.any,
    /**
       * `disabled` is also allowed
       */
    /**
       * `disabled` is also allowed
       */
    isDisabled: PropTypes.bool,
    className: PropTypes.string,
    "aria-label": PropTypes.string,
    "data-test-subj": PropTypes.string,
    css: PropTypes.any,
    buttonRef: PropTypes.any,
    element: PropTypes.oneOf(["a", "button", "span"]),
    /**
       * Applies the boolean state as the `aria-pressed` property to create a toggle button.
       * *Only use when the readable text does not change between states.*
       */
    isSelected: PropTypes.bool,
    /**
       * Extends the button to 100% width
       */
    fullWidth: PropTypes.bool,
    /**
       * Override the default minimum width
       */
    minWidth: PropTypes.oneOfType([PropTypes.any.isRequired, PropTypes.oneOf([false])]),
    /**
       * Force disables the button and changes the icon to a loading spinner
       */
    isLoading: PropTypes.bool,
    /**
       * Object of props passed to the <span/> wrapping the button's content
       */
    contentProps: PropTypes.shape({
      className: PropTypes.string,
      "aria-label": PropTypes.string,
      "data-test-subj": PropTypes.string,
      css: PropTypes.any
    }),
    style: PropTypes.any,
    type: PropTypes.any,
    /**
       * Any `type` accepted by EuiIcon
       */
    iconType: PropTypes.oneOfType([PropTypes.oneOf(["accessibility", "addDataApp", "advancedSettingsApp", "agentApp", "aggregate", "analyzeEvent", "annotation", "anomalyChart", "anomalySwimLane", "apmApp", "apmTrace", "appSearchApp", "apps", "arrowDown", "arrowLeft", "arrowRight", "arrowUp", "arrowStart", "arrowEnd", "article", "asterisk", "at", "auditbeatApp", "beaker", "bell", "bellSlash", "beta", "bolt", "boxesHorizontal", "boxesVertical", "branch", "branchUser", "broom", "brush", "bug", "bullseye", "calendar", "canvasApp", "casesApp", "changePointDetection", "check", "checkInCircleFilled", "cheer", "classificationJob", "clickLeft", "clickRight", "clock", "clockCounter", "cloudDrizzle", "cloudStormy", "cloudSunny", "cluster", "codeApp", "color", "compute", "console", "consoleApp", "container", "continuityAbove", "continuityAboveBelow", "continuityBelow", "continuityWithin", "contrast", "contrastHigh", "controlsHorizontal", "controlsVertical", "copy", "copyClipboard", "createAdvancedJob", "createGenericJob", "createGeoJob", "createMultiMetricJob", "createPopulationJob", "createSingleMetricJob", "cross", "crossClusterReplicationApp", "crossInCircle", "crosshairs", "currency", "cut", "dashboardApp", "dataVisualizer", "database", "desktop", "devToolsApp", "diff", "discoverApp", "discuss", "document", "documentEdit", "documentation", "documents", "dot", "dotInCircle", "doubleArrowLeft", "doubleArrowRight", "download", "editorAlignCenter", "editorAlignLeft", "editorAlignRight", "editorBold", "editorChecklist", "editorCodeBlock", "editorComment", "editorDistributeHorizontal", "editorDistributeVertical", "editorHeading", "editorItalic", "editorItemAlignBottom", "editorItemAlignCenter", "editorItemAlignLeft", "editorItemAlignMiddle", "editorItemAlignRight", "editorItemAlignTop", "editorLink", "editorOrderedList", "editorPositionBottomLeft", "editorPositionBottomRight", "editorPositionTopLeft", "editorPositionTopRight", "editorRedo", "editorStrike", "editorTable", "editorUnderline", "editorUndo", "editorUnorderedList", "email", "empty", "emsApp", "endpoint", "eql", "eraser", "error", "errorFilled", "esqlVis", "exit", "expand", "expandMini", "exportAction", "eye", "eyeClosed", "faceHappy", "faceNeutral", "faceSad", "fieldStatistics", "filebeatApp", "filter", "filterExclude", "filterIgnore", "filterInclude", "filterInCircle", "flag", "fleetApp", "fold", "folderCheck", "folderClosed", "folderExclamation", "folderOpen", "frameNext", "framePrevious", "fullScreen", "fullScreenExit", "function", "gear", "gisApp", "glasses", "globe", "grab", "grabHorizontal", "grabOmnidirectional", "gradient", "graphApp", "grid", "grokApp", "heart", "heartbeatApp", "heatmap", "help", "home", "iInCircle", "image", "importAction", "index", "indexClose", "indexEdit", "indexFlush", "indexManagementApp", "indexMapping", "indexOpen", "indexPatternApp", "indexRollupApp", "indexRuntime", "indexSettings", "indexTemporary", "infinity", "inputOutput", "inspect", "invert", "ip", "key", "keyboard", "kqlField", "kqlFunction", "kqlOperand", "kqlSelector", "kqlValue", "kubernetesNode", "kubernetesPod", "launch", "layers", "lensApp", "lettering", "lineDashed", "lineDotted", "lineSolid", "link", "list", "listAdd", "lock", "lockOpen", "logPatternAnalysis", "logRateAnalysis", "logoAWS", "logoAWSMono", "logoAerospike", "logoApache", "logoAppSearch", "logoAzure", "logoAzureMono", "logoBeats", "logoBusinessAnalytics", "logoCeph", "logoCloud", "logoCloudEnterprise", "logoCode", "logoCodesandbox", "logoCouchbase", "logoDocker", "logoDropwizard", "logoElastic", "logoElasticStack", "logoElasticsearch", "logoEnterpriseSearch", "logoEtcd", "logoGCP", "logoGCPMono", "logoGithub", "logoGmail", "logoGolang", "logoGoogleG", "logoHAproxy", "logoIBM", "logoIBMMono", "logoKafka", "logoKibana", "logoKubernetes", "logoLogging", "logoLogstash", "logoMaps", "logoMemcached", "logoMetrics", "logoMongodb", "logoMySQL", "logoNginx", "logoObservability", "logoOsquery", "logoPhp", "logoPostgres", "logoPrometheus", "logoRabbitmq", "logoRedis", "logoSecurity", "logoSiteSearch", "logoSketch", "logoSlack", "logoUptime", "logoVulnerabilityManagement", "logoWebhook", "logoWindows", "logoWorkplaceSearch", "logsApp", "logstashFilter", "logstashIf", "logstashInput", "logstashOutput", "logstashQueue", "machineLearningApp", "magnet", "magnifyWithExclamation", "magnifyWithMinus", "magnifyWithPlus", "managementApp", "mapMarker", "memory", "menu", "menuDown", "menuLeft", "menuRight", "menuUp", "merge", "metricbeatApp", "metricsApp", "minimize", "minus", "minusInCircle", "minusInCircleFilled", "minusInSquare", "mobile", "monitoringApp", "moon", "move", "namespace", "nested", "newChat", "node", "notebookApp", "number", "offline", "online", "outlierDetectionJob", "package", "packetbeatApp", "pageSelect", "pagesSelect", "palette", "paperClip", "partial", "pause", "payment", "pencil", "percent", "pin", "pinFilled", "pipeBreaks", "pipelineApp", "pipeNoBreaks", "pivot", "play", "playFilled", "plus", "plusInCircle", "plusInCircleFilled", "plusInSquare", "popout", "push", "questionInCircle", "quote", "recentlyViewedApp", "refresh", "regressionJob", "reporter", "reportingApp", "returnKey", "save", "savedObjectsApp", "scale", "search", "searchProfilerApp", "section", "securityAnalyticsApp", "securityApp", "securitySignal", "securitySignalDetected", "securitySignalResolved", "sessionViewer", "shard", "share", "singleMetricViewer", "snowflake", "sortAscending", "sortDescending", "sortDown", "sortLeft", "sortRight", "sortUp", "sortable", "spaces", "spacesApp", "sparkles", "sqlApp", "starEmpty", "starEmptySpace", "starFilled", "starFilledSpace", "starMinusEmpty", "starMinusFilled", "starPlusEmpty", "starPlusFilled", "stats", "stop", "stopFilled", "stopSlash", "storage", "string", "submodule", "sun", "swatchInput", "symlink", "tableDensityCompact", "tableDensityExpanded", "tableDensityNormal", "tableOfContents", "tag", "tear", "temperature", "timeline", "timelineWithArrow", "timelionApp", "timeRefresh", "timeslider", "training", "transitionLeftIn", "transitionLeftOut", "transitionTopIn", "transitionTopOut", "trash", "unfold", "unlink", "upgradeAssistantApp", "uptimeApp", "user", "userAvatar", "users", "usersRolesApp", "vector", "videoPlayer", "visArea", "visAreaStacked", "visBarHorizontal", "visBarHorizontalStacked", "visBarVertical", "visBarVerticalStacked", "visGauge", "visGoal", "visLine", "visMapCoordinate", "visMapRegion", "visMetric", "visPie", "visTable", "visTagCloud", "visText", "visTimelion", "visVega", "visVisualBuilder", "visualizeApp", "vulnerabilityManagementApp", "warning", "warningFilled", "alert", "watchesApp", "wordWrap", "wordWrapDisabled", "workplaceSearchApp", "wrench", "tokenAlias", "tokenAnnotation", "tokenArray", "tokenBinary", "tokenBoolean", "tokenClass", "tokenCompletionSuggester", "tokenConstant", "tokenDate", "tokenDimension", "tokenElement", "tokenEnum", "tokenEnumMember", "tokenEvent", "tokenException", "tokenField", "tokenFile", "tokenFlattened", "tokenFunction", "tokenGeo", "tokenHistogram", "tokenInterface", "tokenIP", "tokenJoin", "tokenKey", "tokenKeyword", "tokenMethod", "tokenMetricCounter", "tokenMetricGauge", "tokenModule", "tokenNamespace", "tokenNested", "tokenNull", "tokenNumber", "tokenObject", "tokenOperator", "tokenPackage", "tokenParameter", "tokenPercolator", "tokenProperty", "tokenRange", "tokenRankFeature", "tokenRankFeatures", "tokenRepo", "tokenSearchType", "tokenSemanticText", "tokenShape", "tokenString", "tokenStruct", "tokenSymbol", "tokenTag", "tokenText", "tokenTokenCount", "tokenVariable", "tokenVectorDense", "tokenDenseVector", "tokenVectorSparse"]).isRequired, PropTypes.string.isRequired, PropTypes.elementType.isRequired]),
    /**
       * Can only be one side `left` or `right`
       */
    iconSide: PropTypes.oneOfType([PropTypes.any.isRequired, PropTypes.oneOf([undefined])]),
    /**
       * Object of props passed to the `<span>` wrapping the content's text/children only (not icon)
       *
       * This span wrapper can be removed by passing `textProps={false}`.
       */
    textProps: PropTypes.oneOfType([PropTypes.shape({
      className: PropTypes.string,
      "aria-label": PropTypes.string,
      "data-test-subj": PropTypes.string,
      css: PropTypes.any,
      ref: PropTypes.any,
      "data-text": PropTypes.string
    }).isRequired, PropTypes.oneOf([false])]),
    iconSize: PropTypes.any
  }),
  /**
       * Use a border style of card instead of shadow
       */
  hasBorder: PropTypes.bool
};