var _excluded = ["children", "className", "css", "checkableType", "label", "checked", "disabled", "hasShadow", "hasBorder"];
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { useRef } from 'react';
import PropTypes from "prop-types";
import classNames from 'classnames';
import { EuiRadio, EuiCheckbox } from '../../form';
import { EuiSplitPanel } from '../../panel';
import { useEuiTheme } from '../../../services';
import { euiCheckableCardStyles } from './checkable_card.styles';

// if `checkableType` is left out or set to 'radio', use EuiRadioProps

// if `checkableType` is set to 'checkbox', use EuiCheckboxProps
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiCheckableCard = function EuiCheckableCard(_ref) {
  var children = _ref.children,
    className = _ref.className,
    css = _ref.css,
    _ref$checkableType = _ref.checkableType,
    checkableType = _ref$checkableType === void 0 ? 'radio' : _ref$checkableType,
    label = _ref.label,
    checked = _ref.checked,
    disabled = _ref.disabled,
    hasShadow = _ref.hasShadow,
    _ref$hasBorder = _ref.hasBorder,
    hasBorder = _ref$hasBorder === void 0 ? true : _ref$hasBorder,
    rest = _objectWithoutProperties(_ref, _excluded);
  var euiThemeContext = useEuiTheme();
  var styles = euiCheckableCardStyles(euiThemeContext);
  var baseStyles = [styles.euiCheckableCard, checked && !disabled && styles.isChecked, css];
  var labelStyles = [styles.label.euiCheckableCard__label, disabled && styles.label.isDisabled];
  var childStyles = [styles.euiCheckableCard__children];
  var id = rest.id;
  var labelEl = useRef(null);
  var classes = classNames('euiCheckableCard', className);
  var checkableElement;
  if (checkableType === 'radio') {
    checkableElement = ___EmotionJSX(EuiRadio, _extends({
      checked: checked,
      disabled: disabled
    }, rest));
  } else {
    checkableElement = ___EmotionJSX(EuiCheckbox, _extends({
      checked: checked,
      disabled: disabled
    }, rest));
  }
  var labelClasses = classNames('euiCheckableCard__label');
  var onChangeAffordance = function onChangeAffordance() {
    if (labelEl.current) {
      labelEl.current.click();
    }
  };
  return ___EmotionJSX(EuiSplitPanel.Outer, {
    responsive: false,
    hasShadow: hasShadow,
    hasBorder: hasBorder,
    direction: "row",
    className: classes,
    css: baseStyles
  }, ___EmotionJSX(EuiSplitPanel.Inner, {
    // Bubbles up the change event when clicking on the whole div for extra affordance
    onClick: disabled ? undefined : onChangeAffordance,
    color: checked ? 'primary' : 'subdued',
    grow: false
  }, checkableElement), ___EmotionJSX(EuiSplitPanel.Inner, null, ___EmotionJSX("label", {
    ref: labelEl,
    className: labelClasses,
    css: labelStyles,
    htmlFor: id,
    "aria-describedby": children ? "".concat(id, "-details") : undefined
  }, label), children && ___EmotionJSX("div", {
    id: "".concat(id, "-details"),
    className: "euiCheckableCard__children",
    css: childStyles
  }, children)));
};
EuiCheckableCard.propTypes = {
  id: PropTypes.string.isRequired,
  label: PropTypes.node.isRequired,
  hasShadow: PropTypes.any,
  hasBorder: PropTypes.any
};