var _excluded = ["transparentBackground", "language", "children", "className"];
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { useMemo } from 'react';
import PropTypes from "prop-types";
import { highlight } from 'refractor';
import classNames from 'classnames';
import { DEFAULT_LANGUAGE, checkSupportedLanguage, getHtmlContent } from './utils';
import { useEuiMemoizedStyles } from '../../services';
import { euiCodeStyles } from './code.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiCode = function EuiCode(_ref) {
  var _ref$transparentBackg = _ref.transparentBackground,
    transparentBackground = _ref$transparentBackg === void 0 ? false : _ref$transparentBackg,
    _ref$language = _ref.language,
    _language = _ref$language === void 0 ? DEFAULT_LANGUAGE : _ref$language,
    children = _ref.children,
    className = _ref.className,
    rest = _objectWithoutProperties(_ref, _excluded);
  var language = useMemo(function () {
    return checkSupportedLanguage(_language);
  }, [_language]);
  var data = useMemo(function () {
    if (typeof children !== 'string') {
      return [];
    }
    return highlight(children, language);
  }, [children, language]);
  var content = useMemo(function () {
    return getHtmlContent(data, children);
  }, [data, children]);
  var classes = classNames('euiCode', className);
  var styles = useEuiMemoizedStyles(euiCodeStyles);
  var cssStyles = [styles.euiCode, transparentBackground && styles.transparentBackground];
  return ___EmotionJSX("code", _extends({
    className: classes,
    css: cssStyles,
    "data-code-language": language
  }, rest), content);
};
EuiCode.propTypes = {
  className: PropTypes.string,
  "aria-label": PropTypes.string,
  "data-test-subj": PropTypes.string,
  css: PropTypes.any,
  /**
       * Sets the syntax highlighting for a specific language
       * @see [https://prismjs.com/#supported-languages](https://prismjs.com/#supported-languages) for options
       */
  language: PropTypes.string,
  transparentBackground: PropTypes.bool
};