var _excluded = ["lineNumber", "children"];
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t.return && (u = t.return(), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { useState } from 'react';
import PropTypes from "prop-types";
import { useEuiTheme, useEuiMemoizedStyles } from '../../services';
import { useEuiButtonFocusCSS } from '../../themes/amsterdam/global_styling/mixins/button';
import { useEuiI18n } from '../i18n';
import { EuiPopover } from '../popover';
import { EuiIcon } from '../icon';
import { euiCodeBlockAnnotationsStyles } from './code_block_annotations.style';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiCodeBlockAnnotation = function EuiCodeBlockAnnotation(_ref) {
  var lineNumber = _ref.lineNumber,
    children = _ref.children,
    rest = _objectWithoutProperties(_ref, _excluded);
  var _useState = useState(false),
    _useState2 = _slicedToArray(_useState, 2),
    isOpen = _useState2[0],
    setIsOpen = _useState2[1];
  var ariaLabel = useEuiI18n('euiCodeBlockAnnotations.ariaLabel', 'Click to view a code annotation for line {lineNumber}', {
    lineNumber: lineNumber
  });
  var styles = useEuiMemoizedStyles(euiCodeBlockAnnotationsStyles);
  var buttonIconFocusStyle = useEuiButtonFocusCSS();
  var cssButtonIconStyles = [styles.euiCodeBlockAnnotation__buttonIcon, buttonIconFocusStyle];
  var _useEuiTheme = useEuiTheme(),
    euiTheme = _useEuiTheme.euiTheme,
    colorMode = _useEuiTheme.colorMode;
  var isDarkMode = colorMode === 'DARK';
  var iconColor = isDarkMode ? euiTheme.colors.ink : 'ghost';
  return ___EmotionJSX(EuiPopover, _extends({
    css: styles.euiCodeBlockAnnotation
  }, rest, {
    isOpen: isOpen,
    closePopover: function closePopover() {
      return setIsOpen(false);
    },
    button: ___EmotionJSX("button", {
      onClick: function onClick() {
        return setIsOpen(!isOpen);
      },
      "aria-label": ariaLabel,
      css: cssButtonIconStyles,
      "data-test-subj": "euiCodeBlockAnnotationIcon"
    }, ___EmotionJSX(EuiIcon, {
      type: AnnotationInfoIcon,
      size: "s",
      color: iconColor
    })),
    zIndex: Number(euiTheme.levels.mask) + 1 // Ensure fullscreen annotation popovers sit above the mask
    ,
    anchorPosition: "downLeft",
    panelProps: {
      'data-test-subj': 'euiCodeBlockAnnotationPopover'
    }
  }), children);
};
EuiCodeBlockAnnotation.propTypes = {
  className: PropTypes.string,
  "aria-label": PropTypes.string,
  "data-test-subj": PropTypes.string,
  css: PropTypes.any,
  lineNumber: PropTypes.number.isRequired
};
var AnnotationInfoIcon = function AnnotationInfoIcon(props) {
  return ___EmotionJSX("svg", _extends({
    width: 11,
    height: 11,
    viewBox: "0 0 16 16",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, props), ___EmotionJSX("path", {
    fillRule: "evenodd",
    clipRule: "evenodd",
    d: "M7.139 14l-.052-6.007H5V6.28h4.111l.052 6.007h1.915V14h-3.94zM6.712 3.38c0-.396.118-.725.354-.987S7.639 2 8.077 2c.438 0 .777.131 1.016.393.24.262.359.591.359.987 0 .39-.12.714-.359.972s-.578.388-1.016.388c-.438 0-.775-.13-1.011-.388-.236-.258-.354-.582-.354-.972z"
  }));
};