function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
var _excluded = ["id", "children", "className", "isDocked", "isOpen", "button", "showButtonIfDocked", "dockedBreakpoint", "as", "size", "side", "ownFocus", "outsideClickCloses", "closeButtonPosition", "paddingSize", "focusTrapProps"];
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _toConsumableArray(r) { return _arrayWithoutHoles(r) || _iterableToArray(r) || _unsupportedIterableToArray(r) || _nonIterableSpread(); }
function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _iterableToArray(r) { if ("undefined" != typeof Symbol && null != r[Symbol.iterator] || null != r["@@iterator"]) return Array.from(r); }
function _arrayWithoutHoles(r) { if (Array.isArray(r)) return _arrayLikeToArray(r); }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { cloneElement, useRef } from 'react';
import PropTypes from "prop-types";
import classNames from 'classnames';
import { useEuiMemoizedStyles, useGeneratedHtmlId, useIsWithinMinBreakpoint, useCombinedRefs } from '../../services';
import { EuiFlyout } from '../flyout';
import { euiCollapsibleNavStyles } from './collapsible_nav.styles';

// Extend all the flyout props except `onClose` because we handle this internally
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiCollapsibleNav = function EuiCollapsibleNav(_ref) {
  var id = _ref.id,
    children = _ref.children,
    className = _ref.className,
    _ref$isDocked = _ref.isDocked,
    isDocked = _ref$isDocked === void 0 ? false : _ref$isDocked,
    _ref$isOpen = _ref.isOpen,
    isOpen = _ref$isOpen === void 0 ? false : _ref$isOpen,
    button = _ref.button,
    _ref$showButtonIfDock = _ref.showButtonIfDocked,
    showButtonIfDocked = _ref$showButtonIfDock === void 0 ? false : _ref$showButtonIfDock,
    _ref$dockedBreakpoint = _ref.dockedBreakpoint,
    dockedBreakpoint = _ref$dockedBreakpoint === void 0 ? 'l' : _ref$dockedBreakpoint,
    _ref$as = _ref.as,
    as = _ref$as === void 0 ? 'nav' : _ref$as,
    _ref$size = _ref.size,
    size = _ref$size === void 0 ? 320 : _ref$size,
    _ref$side = _ref.side,
    side = _ref$side === void 0 ? 'left' : _ref$side,
    _ref$ownFocus = _ref.ownFocus,
    ownFocus = _ref$ownFocus === void 0 ? true : _ref$ownFocus,
    _ref$outsideClickClos = _ref.outsideClickCloses,
    outsideClickCloses = _ref$outsideClickClos === void 0 ? true : _ref$outsideClickClos,
    _ref$closeButtonPosit = _ref.closeButtonPosition,
    closeButtonPosition = _ref$closeButtonPosit === void 0 ? 'outside' : _ref$closeButtonPosit,
    _ref$paddingSize = _ref.paddingSize,
    paddingSize = _ref$paddingSize === void 0 ? 'none' : _ref$paddingSize,
    _ref$focusTrapProps = _ref.focusTrapProps,
    _focusTrapProps = _ref$focusTrapProps === void 0 ? {} : _ref$focusTrapProps,
    rest = _objectWithoutProperties(_ref, _excluded);
  var flyoutID = useGeneratedHtmlId({
    conditionalId: id,
    suffix: 'euiCollapsibleNav'
  });
  var buttonRef = useRef();
  var combinedButtonRef = useCombinedRefs([button === null || button === void 0 ? void 0 : button.props.ref, buttonRef]);
  var focusTrapProps = _objectSpread(_objectSpread({}, _focusTrapProps), {}, {
    shards: [buttonRef].concat(_toConsumableArray(_focusTrapProps.shards || []))
  });
  var windowIsLargeEnoughToPush = useIsWithinMinBreakpoint(dockedBreakpoint);
  var navIsDocked = isDocked && windowIsLargeEnoughToPush;
  var flyoutType = navIsDocked ? 'push' : 'overlay';
  var classes = classNames('euiCollapsibleNav', className);
  var styles = useEuiMemoizedStyles(euiCollapsibleNavStyles);
  var cssStyles = [styles.euiCollapsibleNav, styles[flyoutType]];

  // Show a trigger button if one was passed but
  // not if navIsDocked and showButtonIfDocked is false
  var trigger = navIsDocked && !showButtonIfDocked ? undefined : button && /*#__PURE__*/cloneElement(button, {
    'aria-controls': flyoutID,
    'aria-expanded': isOpen,
    'aria-pressed': isOpen,
    // When EuiOutsideClickDetector is enabled, we don't want both the toggle button and document touches/clicks to happen, they'll cancel eachother out
    onTouchEnd: function onTouchEnd(e) {
      e.nativeEvent.stopImmediatePropagation();
    },
    onMouseUpCapture: function onMouseUpCapture(e) {
      e.nativeEvent.stopImmediatePropagation();
    },
    ref: combinedButtonRef
  });
  var flyout = ___EmotionJSX(EuiFlyout, _extends({
    id: flyoutID,
    css: cssStyles,
    className: classes
    // Flyout props we set different defaults for
    ,
    as: as,
    size: size,
    side: side,
    ownFocus: ownFocus,
    outsideClickCloses: outsideClickCloses,
    closeButtonPosition: closeButtonPosition,
    paddingSize: paddingSize,
    focusTrapProps: focusTrapProps
  }, rest, {
    // Props dependent on internal docked status
    type: flyoutType,
    hideCloseButton: navIsDocked,
    pushMinBreakpoint: dockedBreakpoint
  }), children);
  return ___EmotionJSX(React.Fragment, null, trigger, (isOpen || navIsDocked) && flyout);
};
EuiCollapsibleNav.propTypes = {
  className: PropTypes.string,
  "aria-label": PropTypes.string,
  "data-test-subj": PropTypes.string,
  css: PropTypes.any,
  /**
     * Sets the HTML element for `EuiFlyout`
     */
  as: PropTypes.any,
  onClose: PropTypes.func.isRequired,
  /**
     * Defines the width of the panel.
     * Pass a predefined size of `s | m | l`, or pass any number/string compatible with the CSS `width` attribute
     * @default m
     */
  size: PropTypes.oneOfType([PropTypes.any.isRequired, PropTypes.any.isRequired]),
  /**
     * Sets the max-width of the panel,
     * set to `true` to use the default size,
     * set to `false` to not restrict the width,
     * set to a number for a custom width in px,
     * set to a string for a custom width in custom measurement.
     * @default false
     */
  maxWidth: PropTypes.oneOfType([PropTypes.bool.isRequired, PropTypes.number.isRequired, PropTypes.string.isRequired]),
  /**
     * Customize the padding around the content of the flyout header, body and footer
     * @default l
     */
  paddingSize: PropTypes.any,
  /**
     * Adds an EuiOverlayMask and wraps in an EuiPortal
     * @default true
     */
  ownFocus: PropTypes.bool,
  /**
     * Hides the default close button. You must provide another close button somewhere within the flyout.
     * @default false
     */
  hideCloseButton: PropTypes.bool,
  /**
     * Extends EuiButtonIconProps onto the close button
     */
  closeButtonProps: PropTypes.any,
  /**
     * Position of close button.
     * `inside`: Floating to just inside the flyout, always top right;
     * `outside`: Floating just outside the flyout near the top (side dependent on `side`). Helpful when the close button may cover other interactable content.
     * @default inside
     */
  closeButtonPosition: PropTypes.oneOf(["inside", "outside"]),
  /**
     * Adjustments to the EuiOverlayMask that is added when `ownFocus = true`
     */
  maskProps: PropTypes.shape({
    /**
       * ReactNode to render as this component's content
       */
    children: PropTypes.node,
    /**
       * Should the mask visually sit above or below the EuiHeader (controlled by z-index)
       */
    headerZindexLocation: PropTypes.oneOf(["above", "below"]),
    /**
       * React ref to be passed to the wrapping container
       */
    maskRef: PropTypes.oneOfType([PropTypes.any.isRequired, PropTypes.any.isRequired])
  }),
  /**
     * Forces this interaction on the mask overlay or body content.
     * Defaults depend on `ownFocus` and `type` values
     */
  outsideClickCloses: PropTypes.bool,
  /**
     * Which side of the window to attach to.
     * The `left` option should only be used for navigation.
     * @default right
     */
  side: PropTypes.any,
  /**
     * Named breakpoint (`xs` through `xl`) for customizing the minimum window width to enable docking
     */
  pushMinBreakpoint: PropTypes.any,
  /**
     * Enables a slide in animation on push flyouts
     * @default false
     */
  pushAnimation: PropTypes.bool,
  style: PropTypes.any,
  /**
     * Object of props passed to EuiFocusTrap.
     * `shards` specifies an array of elements that will be considered part of the flyout, preventing the flyout from being closed when clicked.
     * `closeOnMouseup` will delay the close callback, allowing time for external toggle buttons to handle close behavior.
     */
  focusTrapProps: PropTypes.any,
  /**
     * By default, EuiFlyout will consider any fixed `EuiHeader`s that sit alongside or above the EuiFlyout
     * as part of the flyout's focus trap. This prevents focus fighting with interactive elements
     * within fixed headers.
     *
     * Set this to `false` if you need to disable this behavior for a specific reason.
     */
  includeFixedHeadersInFocusTrap: PropTypes.bool,
  /**
     * ReactNode to render as this component's content
     */
  children: PropTypes.node,
  /**
     * Shows the navigation flyout
     */
  isOpen: PropTypes.bool,
  /**
     * Keeps navigation flyout visible and push `<body>` content via padding
     */
  isDocked: PropTypes.bool,
  dockedBreakpoint: PropTypes.any,
  /**
     * Button for controlling visible state of the nav
     */
  button: PropTypes.element,
  /**
     * Keeps the display of toggle button when in docked state
     */
  showButtonIfDocked: PropTypes.bool
};