/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import { css } from '@emotion/react';
import { shade } from '../../../services';
import { logicalCSS } from '../../../global_styling';
export var euiCollapsibleNavGroupStyles = function euiCollapsibleNavGroupStyles(_ref) {
  var euiTheme = _ref.euiTheme,
    colorMode = _ref.colorMode;
  return {
    euiCollapsibleNavGroup: /*#__PURE__*/css("&:not(:first-child){", logicalCSS('border-top', euiTheme.border.thin), ";};label:euiCollapsibleNavGroup;"),
    // Background colors
    none: /*#__PURE__*/css(";label:none;"),
    light: /*#__PURE__*/css("background-color:", euiTheme.colors.body, ";;label:light;"),
    dark: /*#__PURE__*/css("background-color:", colorMode === 'DARK' ? shade(euiTheme.colors.lightestShade, 0.5) : shade(euiTheme.colors.darkestShade, 0.2), ";.euiCollapsibleNavGroup__title,.euiCollapsibleNavGroup__heading,.euiAccordion__arrow{color:", euiTheme.colors.ghost, ";};label:dark;"),
    // Header padding
    isCollapsible: /*#__PURE__*/css(".euiAccordion__triggerWrapper{padding:", euiTheme.size.base, ";};label:isCollapsible;"),
    notCollapsible: /*#__PURE__*/css(".euiCollapsibleNavGroup__heading{padding:", euiTheme.size.base, ";};label:notCollapsible;"),
    // Children padding
    childrenWrapper: {
      euiCollapsibleNavGroup__children: /*#__PURE__*/css("padding:", euiTheme.size.s, ";;label:euiCollapsibleNavGroup__children;"),
      withHeading: /*#__PURE__*/css(logicalCSS('padding-top', 0), ";;label:withHeading;")
    }
  };
};