function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
var _excluded = ["id", "children", "className", "initialIsCollapsed", "isCollapsed", "onCollapseToggle", "width", "side", "focusTrapProps"];
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _toConsumableArray(r) { return _arrayWithoutHoles(r) || _iterableToArray(r) || _unsupportedIterableToArray(r) || _nonIterableSpread(); }
function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _iterableToArray(r) { if ("undefined" != typeof Symbol && null != r[Symbol.iterator] || null != r["@@iterator"]) return Array.from(r); }
function _arrayWithoutHoles(r) { if (Array.isArray(r)) return _arrayLikeToArray(r); }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t.return && (u = t.return(), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { useRef, useMemo, useState, useEffect, useCallback } from 'react';
import PropTypes from "prop-types";
import classNames from 'classnames';
import { useEuiMemoizedStyles, useEuiThemeCSSVariables, useGeneratedHtmlId, throttle } from '../../services';
import { EuiFlyout } from '../flyout';
import { useEuiI18n } from '../i18n';
import { euiHeaderVariables } from '../header/header.styles';
import { EuiCollapsibleNavContext } from './context';
import { EuiCollapsibleNavButton } from './collapsible_nav_button';
import { euiCollapsibleNavBetaStyles } from './collapsible_nav_beta.styles';
var _EuiCollapsibleNavBeta = function _EuiCollapsibleNavBeta(_ref) {
  var id = _ref.id,
    children = _ref.children,
    className = _ref.className,
    _ref$initialIsCollaps = _ref.initialIsCollapsed,
    initialIsCollapsed = _ref$initialIsCollaps === void 0 ? false : _ref$initialIsCollaps,
    propsIsCollapsed = _ref.isCollapsed,
    onCollapseToggle = _ref.onCollapseToggle,
    _ref$width = _ref.width,
    _width = _ref$width === void 0 ? 248 : _ref$width,
    _ref$side = _ref.side,
    side = _ref$side === void 0 ? 'left' : _ref$side,
    _focusTrapProps = _ref.focusTrapProps,
    rest = _objectWithoutProperties(_ref, _excluded);
  var _useEuiThemeCSSVariab = useEuiThemeCSSVariables(),
    setGlobalCSSVariables = _useEuiThemeCSSVariab.setGlobalCSSVariables;
  var _useEuiMemoizedStyles = useEuiMemoizedStyles(euiHeaderVariables),
    headerHeight = _useEuiMemoizedStyles.height;

  /**
   * Collapsed state
   */
  var _useState = useState(initialIsCollapsed),
    _useState2 = _slicedToArray(_useState, 2),
    isCollapsed = _useState2[0],
    setIsCollapsed = _useState2[1];
  var toggleCollapsed = useCallback(function () {
    return setIsCollapsed(function (isCollapsed) {
      onCollapseToggle === null || onCollapseToggle === void 0 || onCollapseToggle(!isCollapsed);
      return !isCollapsed;
    });
  }, [onCollapseToggle]);
  var onClose = useCallback(function () {
    setIsCollapsed(true);
    onCollapseToggle === null || onCollapseToggle === void 0 || onCollapseToggle(true);
  }, [onCollapseToggle]);

  // Controlled state
  useEffect(function () {
    if (propsIsCollapsed !== undefined) {
      setIsCollapsed(propsIsCollapsed);
    }
  }, [propsIsCollapsed]);

  /**
   * Responsive behavior
   * By default on large enough screens, the nav is always a push flyout,
   * but on smaller/mobile screens, the nav overlays the page instead
   */
  var _useState3 = useState(false),
    _useState4 = _slicedToArray(_useState3, 2),
    isOverlay = _useState4[0],
    setIsOverlay = _useState4[1];
  var _useState5 = useState(false),
    _useState6 = _slicedToArray(_useState5, 2),
    isOverlayFullWidth = _useState6[0],
    setIsOverlayFullWidth = _useState6[1];
  var _useState7 = useState(false),
    _useState8 = _slicedToArray(_useState7, 2),
    isOverlayOpen = _useState8[0],
    setIsOverlayOpen = _useState8[1];
  var toggleOverlayFlyout = useCallback(function () {
    setIsOverlayOpen(function (isOpen) {
      return !isOpen;
    });
  }, []);
  var closeOverlayFlyout = useCallback(function () {
    return setIsOverlayOpen(false);
  }, []);
  var flyoutType = isOverlay ? 'overlay' : 'push';
  var isPush = !isOverlay;

  // Set up a window resize listener that determines breakpoint behavior
  useEffect(function () {
    var getBreakpoints = function getBreakpoints() {
      setIsOverlay(window.innerWidth < _width * 3);
      setIsOverlayFullWidth(window.innerWidth < _width * 1.5);
    };
    getBreakpoints();
    var onWindowResize = throttle(getBreakpoints, 50);
    window.addEventListener('resize', onWindowResize);
    return function () {
      return window.removeEventListener('resize', onWindowResize);
    };
  }, [_width]);
  var width = useMemo(function () {
    if (isOverlayFullWidth) return '100%';
    if (isPush && isCollapsed) return headerHeight;
    return "".concat(_width, "px");
  }, [_width, isOverlayFullWidth, isPush, isCollapsed, headerHeight]);

  // Other UI elements may need to account for the nav width -
  // set a global CSS variable that they can use
  useEffect(function () {
    setGlobalCSSVariables({
      '--euiCollapsibleNavOffset': isOverlay ? '0' : width
    });
  }, [width, isOverlay, setGlobalCSSVariables]);

  /**
   * Prop setup
   */
  var flyoutID = useGeneratedHtmlId({
    conditionalId: id,
    suffix: 'euiCollapsibleNav'
  });
  var defaultAriaLabel = useEuiI18n('euiCollapsibleNavBeta.ariaLabel', 'Site menu');
  var buttonRef = useRef(null);
  var focusTrapProps = useMemo(function () {
    return _objectSpread(_objectSpread({}, _focusTrapProps), {}, {
      shards: [buttonRef].concat(_toConsumableArray((_focusTrapProps === null || _focusTrapProps === void 0 ? void 0 : _focusTrapProps.shards) || []))
    });
  }, [_focusTrapProps]);
  var classes = classNames('euiCollapsibleNav', 'euiCollapsibleNavBeta', className);
  var styles = useEuiMemoizedStyles(euiCollapsibleNavBetaStyles);
  var cssStyles = [styles.euiCollapsibleNavBeta, styles[side], isPush && styles.isPush, isPush && isCollapsed && styles.isPushCollapsed, isOverlayFullWidth && styles.isOverlayFullWidth];
  var flyout = ___EmotionJSX(EuiFlyout, _extends({
    "aria-label": defaultAriaLabel
  }, rest, {
    // EuiCollapsibleNav is significantly less permissive than EuiFlyout
    id: flyoutID,
    css: cssStyles,
    className: classes,
    size: width,
    side: side,
    focusTrapProps: focusTrapProps,
    as: "nav",
    type: flyoutType,
    paddingSize: "none",
    pushMinBreakpoint: "xs",
    onClose: isPush ? onClose : closeOverlayFlyout,
    hideCloseButton: true
  }), children);
  var hideFlyout = isOverlay && !isOverlayOpen;
  return ___EmotionJSX(EuiCollapsibleNavContext.Provider, {
    value: {
      isPush: isPush,
      isCollapsed: isCollapsed,
      isOverlayOpen: isOverlayOpen,
      side: side,
      closePortals: closeOverlayFlyout
    }
  }, ___EmotionJSX(EuiCollapsibleNavButton, {
    ref: buttonRef,
    onClick: isPush ? toggleCollapsed : toggleOverlayFlyout,
    "aria-controls": flyoutID
  }), !hideFlyout && flyout);
};

/**
 * Combined export with subcomponents
 */
_EuiCollapsibleNavBeta.propTypes = {
  className: PropTypes.string,
  /**
       * Overlay flyouts are considered dialogs, and dialogs must have a label.
       * By default, a label of `Site menu` will be applied.
       *
       * If your usage of this component is not actually for site-wide navigation,
       * please set your own `aria-label` or `aria-labelledby`.
       *
       * @default 'Site menu'
       */
  "aria-label": PropTypes.string,
  "data-test-subj": PropTypes.string,
  css: PropTypes.any,
  /**
       * ReactNode(s) to render as navigation flyout content, typically `EuiCollapsibleNavBeta.Item`s.
       * You will likely want to use `EuiCollapsibleNavBeta.Body` and `EuiCollapsibleNavBeta.Footer`
       * for organization.
       */
  children: PropTypes.node,
  /**
       * Whether the navigation flyout should default to initially collapsed or expanded.
       * Used for **uncontrolled** state.
       */
  initialIsCollapsed: PropTypes.bool,
  /**
       * If defined, the navigation collapsed/expanded state is **controlled**
       * by the consumer and `onCollapseToggle` must be passed as well.
       * This prop supercedes `initialIsCollapsed`.
       */
  isCollapsed: PropTypes.bool,
  /**
       * Optional callback that fires when the user toggles the nav between
       * collapsed and uncollapsed states
       */
  onCollapseToggle: PropTypes.func,
  /**
       * Defaults to 248px wide. The navigation width determines behavior at
       * various responsive breakpoints.
       *
       * At larger screen sizes (at least 3x the width of the nav), the nav will
       * be able to be toggled between a docked full width nav and a collapsed
       * side bar that only shows the icon of each item.
       *
       * At under 3 times the width of the nav, the behavior will lose the collapsed
       * side bar behavior, and switch from a docked flyout to an overlay flyout only.
       *
       * If the page is under 1.5 times the width of the nav, the overlay will
       * take up the full width of the page.
       */
  width: PropTypes.number
};
import { EuiCollapsibleNavBody, EuiCollapsibleNavFooter } from './collapsible_nav_body_footer';
import { EuiCollapsibleNavItem } from './collapsible_nav_item';
import { KibanaCollapsibleNavSolution } from './_kibana_solution';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiCollapsibleNavBeta = Object.assign(_EuiCollapsibleNavBeta, {
  Body: EuiCollapsibleNavBody,
  Footer: EuiCollapsibleNavFooter,
  Item: EuiCollapsibleNavItem,
  KibanaSolution: KibanaCollapsibleNavSolution
});