/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import { css } from '@emotion/react';
import { logicalCSS } from '../../global_styling';
import { euiShadowFlat } from '../../themes';
import { euiHeaderVariables } from '../header/header.styles';
import { hideScrollbars } from './collapsible_nav_body_footer.styles';
export var euiCollapsibleNavBetaStyles = function euiCollapsibleNavBetaStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;

  // At least for serverless, EuiCollapsibleNav is only going to be used with 1
  // fixed header. For those scenarios, we can prevent a minor layout jump on
  // page load by setting the CSS var fallback to the height of a single header
  var defaultHeaderHeight = euiHeaderVariables(euiThemeContext).height;
  var fixedHeaderOffset = "var(--euiFixedHeadersOffset, ".concat(defaultHeaderHeight, ")");
  return {
    euiCollapsibleNavBeta: /*#__PURE__*/css(logicalCSS('top', fixedHeaderOffset), logicalCSS('padding-bottom', euiTheme.size.xs), ";;label:euiCollapsibleNavBeta;"),
    left: /*#__PURE__*/css(logicalCSS('border-right', euiTheme.border.thin), ";;label:left;"),
    right: /*#__PURE__*/css(logicalCSS('border-left', euiTheme.border.thin), ";;label:right;"),
    isPush: /*#__PURE__*/css(euiShadowFlat(euiThemeContext), ";;label:isPush;"),
    isPushCollapsed: /*#__PURE__*/css(hideScrollbars, ";;label:isPushCollapsed;"),
    isOverlayFullWidth: /*#__PURE__*/css("&.euiFlyout{", logicalCSS('max-width', '100% !important'), ";};label:isOverlayFullWidth;")
  };
};