var _excluded = ["className"],
  _excluded2 = ["className", "children"];
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { useContext } from 'react';
import classNames from 'classnames';
import { useEuiMemoizedStyles } from '../../services';
import { EuiFlyoutBody, EuiFlyoutFooter } from '../flyout';
import { EuiCollapsibleNavContext } from './context';
import { euiCollapsibleNavBodyStyles as bodyStyles, euiCollapsibleNavFooterStyles } from './collapsible_nav_body_footer.styles';

/**
 * These components are incredibly light wrappers around `EuiFlyoutBody`
 * and `EuiFlyoutFooter` with collapsible nav-specific styling/considerations.
 *
 * Note: They are not intended to be used standalone outside of EuiCollapsibleNav
 */
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiCollapsibleNavBody = function EuiCollapsibleNavBody(_ref) {
  var className = _ref.className,
    props = _objectWithoutProperties(_ref, _excluded);
  var classes = classNames('euiCollapsibleNav__body', className);
  var _useContext = useContext(EuiCollapsibleNavContext),
    isCollapsed = _useContext.isCollapsed,
    isPush = _useContext.isPush;
  var cssStyles = [bodyStyles.euiCollapsibleNav__body, isCollapsed && isPush && bodyStyles.isPushCollapsed];
  return ___EmotionJSX(EuiFlyoutBody, _extends({
    className: classes,
    css: cssStyles
    // Since this is a nav, we can almost guarantee there will be clickable
    // children/links that will enable scrolling. As such, we're optimistically
    // removing the extra tab stop
    ,
    scrollableTabIndex: -1
  }, props));
};
export var EuiCollapsibleNavFooter = function EuiCollapsibleNavFooter(_ref2) {
  var className = _ref2.className,
    children = _ref2.children,
    props = _objectWithoutProperties(_ref2, _excluded2);
  var classes = classNames('euiCollapsibleNav__footer', className);
  var _useContext2 = useContext(EuiCollapsibleNavContext),
    isCollapsed = _useContext2.isCollapsed,
    isPush = _useContext2.isPush;
  var styles = useEuiMemoizedStyles(euiCollapsibleNavFooterStyles);
  var cssStyles = styles.euiCollapsibleNav__footer;
  var overflowWrapperStyles = [styles.euiFlyoutFooter__overflow, isCollapsed && isPush && styles.isPushCollapsed];
  return ___EmotionJSX(EuiFlyoutFooter, _extends({
    className: classes,
    css: cssStyles
  }, props), ___EmotionJSX("div", {
    css: overflowWrapperStyles
  }, children));
};