/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import { css } from '@emotion/react';
import { logicalCSS, euiYScrollWithShadows } from '../../global_styling';

// Hide the scrollbar for docked mode (while still keeping the nav scrollable)
// Otherwise if scrollbars are visible, button icon visibility suffers.
export var hideScrollbars = "\n  scrollbar-width: none; /* Firefox */\n\n  &::-webkit-scrollbar {\n    display: none; /* Chrome, Edge, & Safari */\n  }\n";
export var euiCollapsibleNavBodyStyles = {
  euiCollapsibleNav__body: /*#__PURE__*/css(";label:euiCollapsibleNav__body;"),
  isPushCollapsed: /*#__PURE__*/css(".euiFlyoutBody__overflow{", hideScrollbars, ";};label:isPushCollapsed;")
};
export var euiCollapsibleNavFooterStyles = function euiCollapsibleNavFooterStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  return {
    euiCollapsibleNav__footer: /*#__PURE__*/css(logicalCSS('max-height', '50%'), " background-color:", euiTheme.colors.emptyShade, ";", logicalCSS('border-top', euiTheme.border.thin), ";;label:euiCollapsibleNav__footer;"),
    euiFlyoutFooter__overflow: /*#__PURE__*/css(euiYScrollWithShadows(euiThemeContext, {
      side: 'end'
    }), ";;label:euiFlyoutFooter__overflow;"),
    isPushCollapsed: /*#__PURE__*/css(hideScrollbars, ";;label:isPushCollapsed;")
  };
};