var _excluded = ["className", "css"];
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { forwardRef, useContext } from 'react';
import PropTypes from "prop-types";
import { useEuiMemoizedStyles } from '../../../services';
import { EuiButtonIcon } from '../../button';
import { useEuiI18n } from '../../i18n';
import { EuiCollapsibleNavContext } from '../context';
import { euiCollapsibleNavButtonWrapperStyles } from './collapsible_nav_button.styles';
import classNames from 'classnames';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiCollapsibleNavButton = /*#__PURE__*/forwardRef(function (_ref, ref) {
  var className = _ref.className,
    css = _ref.css,
    rest = _objectWithoutProperties(_ref, _excluded);
  var _useContext = useContext(EuiCollapsibleNavContext),
    side = _useContext.side,
    isPush = _useContext.isPush,
    isCollapsed = _useContext.isCollapsed,
    isOverlayOpen = _useContext.isOverlayOpen;
  var styles = useEuiMemoizedStyles(euiCollapsibleNavButtonWrapperStyles);
  var cssStyles = [styles.euiCollapsibleNavButtonWrapper, styles[side]];
  var buttonStyles = [styles.euiCollapsibleNavButton, css];
  var classes = classNames('euiCollapsibleNavButton', className);
  var toggleExpandLabel = useEuiI18n('euiCollapsibleNavButton.ariaLabelExpand', 'Expand navigation');
  var toggleCollapseLabel = useEuiI18n('euiCollapsibleNavButton.ariaLabelCollapse', 'Collapse navigation');
  var toggleOpenLabel = useEuiI18n('euiCollapsibleNavButton.ariaLabelOpen', 'Open navigation');
  var toggleCloseLabel = useEuiI18n('euiCollapsibleNavButton.ariaLabelClose', 'Close navigation');
  var ariaLabel;
  var iconType;
  if (isPush) {
    ariaLabel = isCollapsed ? toggleExpandLabel : toggleCollapseLabel;
    if (side === 'left') {
      iconType = isCollapsed ? 'menuRight' : 'menuLeft';
    } else {
      iconType = isCollapsed ? 'menuLeft' : 'menuRight';
    }
  } else {
    ariaLabel = isOverlayOpen ? toggleCloseLabel : toggleOpenLabel;
    iconType = isOverlayOpen ? 'cross' : 'menu';
  }
  return ___EmotionJSX("div", {
    className: "euiCollapsibleNavButtonWrapper",
    css: cssStyles,
    ref: ref
  }, ___EmotionJSX(EuiButtonIcon, _extends({
    "data-test-subj": "euiCollapsibleNavButton",
    className: classes,
    css: buttonStyles,
    size: "s",
    color: "text",
    iconType: iconType,
    "aria-label": ariaLabel,
    "aria-pressed": isPush ? !isCollapsed : isOverlayOpen,
    "aria-expanded": isPush ? !isCollapsed : isOverlayOpen
  }, rest)));
});
EuiCollapsibleNavButton.propTypes = {
  className: PropTypes.string,
  "aria-label": PropTypes.string,
  "data-test-subj": PropTypes.string,
  css: PropTypes.any
};
EuiCollapsibleNavButton.displayName = 'EuiCollapsibleNavButton';