var _excluded = ["className", "header", "items", "isSubItem", "isSelected", "children"];
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React from 'react';
import PropTypes from "prop-types";
import classNames from 'classnames';
import { useEuiMemoizedStyles, useGeneratedHtmlId } from '../../../services';
import { EuiCollapsibleNavSubItems } from './collapsible_nav_item';
import { euiCollapsibleNavItemVariables } from './collapsible_nav_item.styles';
import { EuiCollapsibleNavLink } from './collapsible_nav_link';
import { jsx as ___EmotionJSX } from "@emotion/react";
/**
 * Internal nav group. Should look the same as an open accordion,
 * but not be toggle-able to close.
 *
 * Yes, I know this is the 3rd component in EUI named EuiCollapsibleNavGroup :|
 * I'm waiting for serverless's design architecture to settle before untangling
 * this pasghetti
 */
export var EuiCollapsibleNavGroup = function EuiCollapsibleNavGroup(_ref) {
  var className = _ref.className,
    header = _ref.header,
    items = _ref.items,
    isSubItem = _ref.isSubItem,
    isSelected = _ref.isSelected,
    _children = _ref.children,
    rest = _objectWithoutProperties(_ref, _excluded);
  var classes = classNames('euiCollapsibleNavGroup', className);
  var sharedStyles = useEuiMemoizedStyles(euiCollapsibleNavItemVariables);
  var cssStyles = !isSubItem ? {
    css: {
      margin: sharedStyles.padding,
      label: 'euiCollapsibleNavGroup-isTopItem'
    }
  } : undefined; // Prevents Emotion from generating a selector if no styles need to be applied

  var labelledById = useGeneratedHtmlId();
  return ___EmotionJSX("div", _extends({
    className: classes
  }, cssStyles, rest), ___EmotionJSX(EuiCollapsibleNavLink, {
    id: labelledById,
    isSelected: isSelected,
    isSubItem: isSubItem,
    isInteractive: false
  }, header), ___EmotionJSX(EuiCollapsibleNavSubItems, {
    items: items,
    isSubItem: isSubItem,
    className: "euiCollapsibleNavGroup__children",
    role: "group",
    "aria-labelledby": labelledById
  }));
};
EuiCollapsibleNavGroup.propTypes = {
  className: PropTypes.string,
  "aria-label": PropTypes.string,
  "data-test-subj": PropTypes.string,
  css: PropTypes.any,
  /**
       * Highlights whether an item is currently selected, e.g.
       * if the user is on the same page as the nav link
       */
  isSelected: PropTypes.bool,
  /**
     * Determines whether the item should render as a top-level nav item
     * or a nested nav subitem. Set internally by EUI
     */
  isSubItem: PropTypes.bool,
  header: PropTypes.node.isRequired
};