function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import { css } from '@emotion/react';
import { logicalCSS, mathWithUnits, euiFontSize } from '../../../global_styling';
import { euiButtonColor } from '../../../themes/amsterdam/global_styling/mixins/button';

/**
 * Style variables shared between accordion, link, and sub items
 */
export var euiCollapsibleNavItemVariables = function euiCollapsibleNavItemVariables(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  return _objectSpread(_objectSpread({
    height: euiTheme.size.xl,
    padding: euiTheme.size.s
  }, euiFontSize(euiThemeContext, 's')), {}, {
    animation: "".concat(euiTheme.animation.normal, " ease-in-out"),
    // Matches EuiButton
    borderRadius: euiTheme.border.radius.small,
    backgroundHoverColor: euiTheme.colors.lightestShade,
    backgroundSelectedColor: euiButtonColor(euiThemeContext, 'text').backgroundColor,
    color: euiTheme.colors.text,
    rightIconColor: euiTheme.colors.disabledText
  });
};

/**
 * Title styles
 */

export var euiCollapsibleNavItemTitleStyles = {
  euiCollapsibleNavItem__title: process.env.NODE_ENV === "production" ? {
    name: "i246l1-euiCollapsibleNavItem__title",
    styles: "flex-grow:1;label:euiCollapsibleNavItem__title;"
  } : {
    name: "i246l1-euiCollapsibleNavItem__title",
    styles: "flex-grow:1;label:euiCollapsibleNavItem__title;",
    toString: _EMOTION_STRINGIFIED_CSS_ERROR__
  }
};

/**
 * Sub item groups
 */

export var euiCollapsibleNavSubItemsStyles = function euiCollapsibleNavSubItemsStyles(_ref) {
  var euiTheme = _ref.euiTheme;
  return {
    euiCollapsibleNavItem__items: /*#__PURE__*/css(";label:euiCollapsibleNavItem__items;"),
    isTopItem: /*#__PURE__*/css(logicalCSS('padding-top', euiTheme.size.xs), " ", logicalCSS('padding-left', euiTheme.size.xl), ";;label:isTopItem;"),
    isSubItem: /*#__PURE__*/css(logicalCSS('border-left', euiTheme.border.thin), " ", logicalCSS('margin-left', euiTheme.size.s), " ", logicalCSS('padding-left', mathWithUnits([euiTheme.size.s, euiTheme.border.width.thin], function (x, y) {
      return x - y;
    })), ";;label:isSubItem;")
  };
};

/**
 * Top-level item only styles
 */

export var euiCollapsibleNavTopItemStyles = function euiCollapsibleNavTopItemStyles(_ref2) {
  var euiTheme = _ref2.euiTheme;
  return {
    // If this is the only top-level item in the list, assume it's a solution nav and
    // reduce its default left padding + increase its relative icon size
    euiCollapsibleNavTopItem: /*#__PURE__*/css("&:only-child{.euiCollapsibleNavItem__items{", logicalCSS('padding-left', euiTheme.size.s), ";}.euiCollapsibleNavItem__icon{transform:scale(1.25);}};label:euiCollapsibleNavTopItem;")
  };
};