function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
var _excluded = ["href", "rel", "children", "className", "isSelected", "isInteractive", "isNotAccordion", "isSubItem", "linkProps"];
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { useCallback, useContext } from 'react';
import PropTypes from "prop-types";
import classNames from 'classnames';
import { useEuiMemoizedStyles } from '../../../services';
import { EuiLink } from '../../link';
import { EuiCollapsibleNavContext } from '../context';
import { euiCollapsibleNavLinkStyles } from './collapsible_nav_link.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
/**
 * Internal nav link component.
 *
 * Can be rendered as a standalone nav item, or as part of an accordion header.
 * Can also be rendered as top-level item (has a background hover) or as a
 * sub-item (renders closer to plain text).
 *
 * In terms of DOM output, follows the same logic as EuiLink (renders either
 * an `a` tag or a `button` if no valid link exists), and can also additionally
 * rendered a plain `span` if the item is not interactive.
 */
export var EuiCollapsibleNavLink = function EuiCollapsibleNavLink(_ref) {
  var href = _ref.href,
    rel = _ref.rel,
    children = _ref.children,
    className = _ref.className,
    isSelected = _ref.isSelected,
    _ref$isInteractive = _ref.isInteractive,
    isInteractive = _ref$isInteractive === void 0 ? true : _ref$isInteractive,
    isNotAccordion = _ref.isNotAccordion,
    isSubItem = _ref.isSubItem,
    linkProps = _ref.linkProps,
    rest = _objectWithoutProperties(_ref, _excluded);
  var classes = classNames('euiCollapsibleNavLink', className, isInteractive && (linkProps === null || linkProps === void 0 ? void 0 : linkProps.className));
  var styles = useEuiMemoizedStyles(euiCollapsibleNavLinkStyles);
  var cssStyles = [styles.euiCollapsibleNavLink, isSelected && styles.isSelected, isSubItem ? styles.isSubItem : styles.isTopItem.isTopItem, isNotAccordion && !isSubItem && styles.isTopItem.isNotAccordion, isInteractive && !isSelected && !isSubItem && styles.isTopItem.isInteractive, isInteractive && (linkProps === null || linkProps === void 0 ? void 0 : linkProps.css)];
  var _useContext = useContext(EuiCollapsibleNavContext),
    closePortals = _useContext.closePortals;
  var onClick = useCallback(function (event) {
    var _rest$onClick, _linkProps$onClick;
    (_rest$onClick = rest.onClick) === null || _rest$onClick === void 0 || _rest$onClick.call(rest, event);
    linkProps === null || linkProps === void 0 || (_linkProps$onClick = linkProps.onClick) === null || _linkProps$onClick === void 0 || _linkProps$onClick.call(linkProps, event);
    if (!event.defaultPrevented) {
      closePortals === null || closePortals === void 0 || closePortals(event);
    }
  },
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [rest.onClick, linkProps === null || linkProps === void 0 ? void 0 : linkProps.onClick, closePortals]);
  return isInteractive ? ___EmotionJSX(EuiLink, _extends({
    href: href,
    rel: rel
  }, _objectSpread(_objectSpread({}, rest), linkProps), {
    // EuiLink ExclusiveUnion shenanigans
    onClick: onClick,
    className: classes,
    css: cssStyles
  }), children) : ___EmotionJSX("span", _extends({
    className: classes,
    css: cssStyles
  }, rest), children);
};
EuiCollapsibleNavLink.propTypes = {
  className: PropTypes.string,
  "aria-label": PropTypes.string,
  "data-test-subj": PropTypes.string,
  css: PropTypes.any,
  /**
       * Highlights whether an item is currently selected, e.g.
       * if the user is on the same page as the nav link
       */
  isSelected: PropTypes.bool,
  /**
     * Determines whether the item should render as a top-level nav item
     * or a nested nav subitem. Set internally by EUI
     */
  isSubItem: PropTypes.bool,
  children: PropTypes.node.isRequired,
  isInteractive: PropTypes.bool,
  isNotAccordion: PropTypes.bool
};