/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import { css } from '@emotion/react';
import { euiCanAnimate, logicalCSS, mathWithUnits } from '../../../global_styling';
import { euiCollapsibleNavItemVariables } from './collapsible_nav_item.styles';
export var euiCollapsibleNavLinkStyles = function euiCollapsibleNavLinkStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  var sharedStyles = euiCollapsibleNavItemVariables(euiThemeContext);
  return {
    // Shared between all links
    euiCollapsibleNavLink: /*#__PURE__*/css("display:flex;align-items:center;", logicalCSS('height', sharedStyles.height), " padding:", sharedStyles.padding, ";font-size:", sharedStyles.fontSize, ";line-height:", sharedStyles.lineHeight, ";color:", sharedStyles.color, ";border-radius:", sharedStyles.borderRadius, ";&:focus{outline-offset:-", euiTheme.focus.width, ";text-decoration-thickness:unset;}[class*='euiLink__externalIcon']{", logicalCSS('margin-right', euiTheme.size.xxs), " color:", sharedStyles.rightIconColor, ";};label:euiCollapsibleNavLink;"),
    isSelected: /*#__PURE__*/css("background-color:", sharedStyles.backgroundSelectedColor, ";;label:isSelected;"),
    isTopItem: {
      isTopItem: /*#__PURE__*/css("font-weight:", euiTheme.font.weight.semiBold, ";gap:", euiTheme.size.base, ";&:is(button){inline-size:calc(\n            100% - ", mathWithUnits(sharedStyles.padding, function (x) {
        return x * 2;
      }), "\n          );};label:isTopItem;"),
      isNotAccordion: /*#__PURE__*/css("margin:", sharedStyles.padding, ";;label:isNotAccordion;"),
      isInteractive: /*#__PURE__*/css(euiCanAnimate, "{transition:background-color ", sharedStyles.animation, ";}&:hover,&:focus-visible{background-color:", sharedStyles.backgroundHoverColor, ";};label:isInteractive;")
    },
    isSubItem: /*#__PURE__*/css("font-weight:", euiTheme.font.weight.regular, ";gap:", euiTheme.size.s, ";;label:isSubItem;")
  };
};