var _excluded = ["type", "palette", "className", "size"];
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React from 'react';
import PropTypes from "prop-types";
import classnames from 'classnames';
import { useEuiMemoizedStyles } from '../../../services';
import { EuiColorPaletteDisplayFixed } from './color_palette_display_fixed';
import { EuiColorPaletteDisplayGradient } from './color_palette_display_gradient';
import { euiColorPaletteDisplayStyles } from './color_palette_display.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var SIZES = ['xs', 's', 'm'];
export var EuiColorPaletteDisplay = function EuiColorPaletteDisplay(_ref) {
  var _ref$type = _ref.type,
    type = _ref$type === void 0 ? 'fixed' : _ref$type,
    palette = _ref.palette,
    className = _ref.className,
    _ref$size = _ref.size,
    size = _ref$size === void 0 ? 's' : _ref$size,
    rest = _objectWithoutProperties(_ref, _excluded);
  var classes = classnames('euiColorPaletteDisplay', className);
  var styles = useEuiMemoizedStyles(euiColorPaletteDisplayStyles);
  var cssStyles = [styles.euiColorPaletteDisplay, styles[size]];
  return ___EmotionJSX(React.Fragment, null, type === 'fixed' ? ___EmotionJSX(EuiColorPaletteDisplayFixed, _extends({
    css: cssStyles,
    className: classes,
    palette: palette
  }, rest)) : ___EmotionJSX(EuiColorPaletteDisplayGradient, _extends({
    css: cssStyles,
    className: classes,
    palette: palette
  }, rest)));
};
EuiColorPaletteDisplay.propTypes = {
  /**
     * Height of the palette display
     */
  size: PropTypes.any,
  /**
     *   Specify the type of palette.
     *  `gradient`: each color fades into the next.
     */
  /**
     *  `fixed`: individual color blocks.
     */
  type: PropTypes.oneOfType([PropTypes.oneOf(["fixed"]), PropTypes.oneOf(["gradient"]).isRequired]),
  className: PropTypes.string,
  "aria-label": PropTypes.string,
  "data-test-subj": PropTypes.string,
  css: PropTypes.any,
  /**
     * Array of color `strings` or an array of #PaletteColorStop. The stops must be numbers in an ordered range.
     */
  /**
     * Array of color `strings` or an array of #PaletteColorStop. The stops must be numbers in an ordered range.
     */
  palette: PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.string.isRequired).isRequired, PropTypes.arrayOf(PropTypes.any.isRequired).isRequired]).isRequired
};