/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import { css } from '@emotion/react';
import { transparentize } from '../../../services';
import { logicalCSS } from '../../../global_styling';
export var euiColorPaletteDisplayStyles = function euiColorPaletteDisplayStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;

  // Border is a pseudo element with transparency
  var border = "".concat(euiTheme.border.width.thin, " solid ").concat(transparentize(euiTheme.colors.darkestShade, 0.2));
  return {
    euiColorPaletteDisplay: /*#__PURE__*/css("position:relative;display:flex;flex-direction:row;overflow:hidden;&::after{content:'';position:absolute;inset:0;pointer-events:none;border:", border, ";border-radius:inherit;};label:euiColorPaletteDisplay;"),
    // Sizes
    xs: /*#__PURE__*/css(logicalCSS('height', euiTheme.size.xs), " border-radius:", euiTheme.size.xs, ";;label:xs;"),
    s: /*#__PURE__*/css(logicalCSS('height', euiTheme.size.s), " border-radius:", euiTheme.size.s, ";;label:s;"),
    m: /*#__PURE__*/css(logicalCSS('height', euiTheme.size.base), " border-radius:", euiTheme.size.base, ";;label:m;")
  };
};