function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
var _excluded = ["className", "compressed", "disabled", "fullWidth", "isInvalid", "onChange", "readOnly", "valueOfSelected", "palettes", "append", "prepend", "selectionDisplay"],
  _excluded2 = ["type", "value", "title", "palette"];
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { useCallback, useMemo } from 'react';
import PropTypes from "prop-types";
import { EuiSpacer } from '../../spacer';
import { EuiText } from '../../text';
import { EuiSuperSelect } from '../../form/super_select'; // Note: needs to be pointed at this specific subdir for Storybook to inherit types correctly??

import { EuiColorPaletteDisplay } from '../color_palette_display';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiColorPalettePicker = function EuiColorPalettePicker(_ref) {
  var className = _ref.className,
    _ref$compressed = _ref.compressed,
    compressed = _ref$compressed === void 0 ? false : _ref$compressed,
    disabled = _ref.disabled,
    _ref$fullWidth = _ref.fullWidth,
    fullWidth = _ref$fullWidth === void 0 ? false : _ref$fullWidth,
    _ref$isInvalid = _ref.isInvalid,
    isInvalid = _ref$isInvalid === void 0 ? false : _ref$isInvalid,
    onChange = _ref.onChange,
    _ref$readOnly = _ref.readOnly,
    readOnly = _ref$readOnly === void 0 ? false : _ref$readOnly,
    valueOfSelected = _ref.valueOfSelected,
    palettes = _ref.palettes,
    append = _ref.append,
    prepend = _ref.prepend,
    _ref$selectionDisplay = _ref.selectionDisplay,
    selectionDisplay = _ref$selectionDisplay === void 0 ? 'palette' : _ref$selectionDisplay,
    rest = _objectWithoutProperties(_ref, _excluded);
  var getPalette = useCallback(function (_ref2) {
    var type = _ref2.type,
      palette = _ref2.palette,
      title = _ref2.title;
    return ___EmotionJSX(EuiColorPaletteDisplay, {
      type: type,
      palette: palette,
      title: title
    });
  }, []);
  var paletteOptions = useMemo(function () {
    return palettes.map(function (item) {
      var type = item.type,
        value = item.value,
        title = item.title,
        palette = item.palette,
        rest = _objectWithoutProperties(item, _excluded2);
      var paletteForDisplay = item.type !== 'text' ? getPalette(item) : null;
      return _objectSpread({
        value: String(value),
        inputDisplay: selectionDisplay === 'title' || type === 'text' ? title : paletteForDisplay,
        dropdownDisplay: ___EmotionJSX("div", {
          className: "euiColorPalettePicker__item"
        }, title && type !== 'text' &&
        // Accessible labels are managed by color_palette_display_fixed and
        // color_palette_display_gradient. Adding the aria-hidden attribute
        // here to ensure screen readers don't speak the listbox options twice.
        ___EmotionJSX(React.Fragment, null, ___EmotionJSX(EuiText, {
          "aria-hidden": "true",
          className: "euiColorPalettePicker__itemTitle",
          size: "xs"
        }, title), ___EmotionJSX(EuiSpacer, {
          size: "xs"
        })), type === 'text' ? title : paletteForDisplay)
      }, rest);
    });
  }, [getPalette, palettes, selectionDisplay]);
  return ___EmotionJSX(EuiSuperSelect, _extends({
    className: className,
    options: paletteOptions,
    valueOfSelected: valueOfSelected,
    onChange: onChange,
    hasDividers: true,
    isInvalid: isInvalid,
    compressed: compressed,
    disabled: disabled,
    readOnly: readOnly,
    fullWidth: fullWidth,
    append: append,
    prepend: prepend
  }, rest));
};
EuiColorPalettePicker.propTypes = {
  className: PropTypes.string,
  "aria-label": PropTypes.string,
  "data-test-subj": PropTypes.string,
  css: PropTypes.any,
  buttonRef: PropTypes.any,
  /**
     * @default false
     */
  compressed: PropTypes.bool,
  /**
     * Expand to fill 100% of the parent.
     * Defaults to `fullWidth` prop of `<EuiForm>`.
     * @default false
     */
  fullWidth: PropTypes.bool,
  /**
     * @default false
     */
  isInvalid: PropTypes.bool,
  /**
     * @default false
     */
  isLoading: PropTypes.bool,
  readOnly: PropTypes.bool,
  name: PropTypes.string,
  /**
       * Placeholder to display when the current selected value is empty.
       */
  placeholder: PropTypes.node,
  /**
     * Creates an input group with element(s) coming before input.
     * `string` | `ReactElement` or an array of these
     */
  prepend: PropTypes.oneOfType([PropTypes.oneOfType([PropTypes.string.isRequired, PropTypes.element.isRequired]).isRequired, PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.string.isRequired, PropTypes.element.isRequired]).isRequired).isRequired]),
  /**
     * Creates an input group with element(s) coming after input.
     * `string` | `ReactElement` or an array of these
     */
  append: PropTypes.oneOfType([PropTypes.oneOfType([PropTypes.string.isRequired, PropTypes.element.isRequired]).isRequired, PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.string.isRequired, PropTypes.element.isRequired]).isRequired).isRequired]),
  valueOfSelected: PropTypes.any,
  /**
       * Classes for the context menu item
       */
  itemClassName: PropTypes.string,
  /**
       * You must pass an `onChange` function to handle the update of the value
       */
  onChange: PropTypes.func,
  onFocus: PropTypes.func,
  onBlur: PropTypes.func,
  /**
       * Controls whether the options are shown. Default: false
       */
  isOpen: PropTypes.bool,
  /**
       * Optional props to pass to the underlying [EuiInputPopover](/#/layout/popover#popover-attached-to-input-element).
       * Allows fine-grained control of the popover dropdown menu, including
       * `repositionOnScroll` for EuiSuperSelects used within scrollable containers,
       * and customizing popover panel styling.
       *
       * Does not accept a nested `popoverProps.isOpen` property - use the top level
       * `isOpen` API instead.
       */
  popoverProps: PropTypes.any,
  /**
       *  Specify what should be displayed after a selection: a `palette` or `title`
       */
  selectionDisplay: PropTypes.oneOf(["palette", "title"]),
  /**
       * An array of one of the following objects: #EuiColorPalettePickerPaletteText, #EuiColorPalettePickerPaletteFixed, #EuiColorPalettePickerPaletteGradient
       */
  palettes: PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.shape({
    /**
       *  For storing unique value of item
       */
    value: PropTypes.string.isRequired,
    /**
       *  The name of your palette
       */
    title: PropTypes.string.isRequired,
    /**
       * `text`: a text only option (a title is required).
       */
    type: PropTypes.oneOf(["text"]).isRequired,
    /**
       * Array of color `strings` or an array of #PaletteColorStop. The stops must be numbers in an ordered range.
       */
    palette: PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.string.isRequired).isRequired, PropTypes.arrayOf(PropTypes.shape({
      stop: PropTypes.number.isRequired,
      color: PropTypes.string.isRequired
    }).isRequired).isRequired]),
    className: PropTypes.string,
    "aria-label": PropTypes.string,
    "data-test-subj": PropTypes.string,
    css: PropTypes.any
  }).isRequired, PropTypes.shape({
    /**
       *  For storing unique value of item
       */
    value: PropTypes.string.isRequired,
    /**
       *  The name of your palette
       */
    title: PropTypes.string,
    /**
       * `fixed`: individual color blocks
       */
    type: PropTypes.oneOf(["fixed"]).isRequired,
    /**
       * Array of color `strings` or an array of #PaletteColorStop. The stops must be numbers in an ordered range.
       */
    palette: PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.string.isRequired).isRequired, PropTypes.arrayOf(PropTypes.shape({
      stop: PropTypes.number.isRequired,
      color: PropTypes.string.isRequired
    }).isRequired).isRequired]).isRequired,
    className: PropTypes.string,
    "aria-label": PropTypes.string,
    "data-test-subj": PropTypes.string,
    css: PropTypes.any
  }).isRequired, PropTypes.shape({
    /**
       *  For storing unique value of item
       */
    value: PropTypes.string.isRequired,
    /**
       *  The name of your palette
       */
    title: PropTypes.string,
    /**
       * `gradient`: each color fades into the next
       */
    type: PropTypes.oneOf(["gradient"]).isRequired,
    /**
       * Array of color `strings` or an array of #PaletteColorStop. The stops must be numbers in an ordered range.
       */
    palette: PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.string.isRequired).isRequired, PropTypes.arrayOf(PropTypes.shape({
      stop: PropTypes.number.isRequired,
      color: PropTypes.string.isRequired
    }).isRequired).isRequired]).isRequired,
    className: PropTypes.string,
    "aria-label": PropTypes.string,
    "data-test-subj": PropTypes.string,
    css: PropTypes.any
  }).isRequired]).isRequired).isRequired
};