function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t.return && (u = t.return(), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/// <reference types="cypress" />
/// <reference types="cypress-real-events" />
/// <reference types="../../../cypress/support" />

import React from 'react';
import { EuiColorPicker } from './color_picker';
import { EuiFormRow } from '../form';
import { useColorPickerState } from '../../services';
import { jsx as ___EmotionJSX } from "@emotion/react";
var ColorPicker = function ColorPicker() {
  var _useColorPickerState = useColorPickerState('#D36086'),
    _useColorPickerState2 = _slicedToArray(_useColorPickerState, 3),
    color = _useColorPickerState2[0],
    setColor = _useColorPickerState2[1],
    errors = _useColorPickerState2[2];
  return ___EmotionJSX(EuiFormRow, {
    label: "Pick a color",
    isInvalid: !!errors,
    error: errors
  }, ___EmotionJSX(EuiColorPicker, {
    onChange: setColor,
    color: color,
    isInvalid: !!errors
  }));
};
beforeEach(function () {
  cy.realMount(___EmotionJSX(ColorPicker, null));
});
describe('EuiColorPicker', function () {
  describe('Automated accessibility check', function () {
    it('has zero violations on render', function () {
      cy.checkAxe();
    });
    it('has zero violations when the picker is opened', function () {
      cy.get('input[data-test-subj="euiColorPickerAnchor"]').realClick();
      cy.get('div[data-test-subj="euiColorPickerPopover"]').should('exist');
      cy.checkAxe();
      cy.realPress('Escape');
      cy.get('div[data-test-subj="euiColorPickerPopover"]').should('not.exist');
      cy.checkAxe();
    });
    it('has zero violations after keyboard interaction', function () {
      cy.realPress('Tab');
      cy.get('input[data-test-subj="euiColorPickerAnchor"]').should('have.focus');
      cy.realPress('Enter');
      cy.repeatRealPress('ArrowDown', 5);
      cy.repeatRealPress('ArrowRight', 3);
      cy.realPress('Escape');
      cy.get('input[data-test-subj="euiColorPickerAnchor"]').should('have.focus');
      cy.get('input[data-test-subj="euiColorPickerAnchor"]').should('have.attr', 'value', '#C9557B');
      cy.checkAxe();
    });
  });
});