/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import { css } from '@emotion/react';
import { transparentize } from '../../services';
import { logicalCSS, mathWithUnits } from '../../global_styling';
export var euiColorPickerStyles = function euiColorPickerStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;

  // 5 columns of swatches + margins + border
  var colorPickerWidth = mathWithUnits([euiTheme.size.l, euiTheme.size.s], function (x, y) {
    return x * 5 + y * 4;
  });
  return {
    euiColorPicker: /*#__PURE__*/css("position:relative;", logicalCSS('width', colorPickerWidth), "display:flex;flex-direction:column;gap:", euiTheme.size.s, ";;label:euiColorPicker;"),
    euiColorPicker__swatches: /*#__PURE__*/css("display:flex;flex-wrap:wrap;gap:", euiTheme.size.s, ";;label:euiColorPicker__swatches;"),
    euiColorPicker__alphaRange: /*#__PURE__*/css(".euiRangeInput{", logicalCSS('min-width', 0), ";};label:euiColorPicker__alphaRange;"),
    // Adds a stroke color for the swatchInput icon. Unlike most EuiIcons it has a stroke in the SVG
    // Targets a custom className applied directly to the <svg> icon
    euiColorPicker__swatchInputIcon: /*#__PURE__*/css(".euiSwatchInput__stroke{fill:none;stroke:", transparentize(euiTheme.colors.fullShade, 0.2), ";};label:euiColorPicker__swatchInputIcon;")
  };
};