/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import { css } from '@emotion/react';
import { transparentize } from '../../services';
import { logicalSizeCSS, mathWithUnits, euiOutline } from '../../global_styling';
export var euiColorPickerSwatchStyles = function euiColorPickerSwatchStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  return {
    euiColorPickerSwatch: /*#__PURE__*/css("display:inline-block;", logicalSizeCSS(euiTheme.size.l), " border-radius:", mathWithUnits(euiTheme.border.radius.medium, function (x) {
      return x / 2;
    }), ";border:", euiTheme.border.width.thin, " solid ", transparentize(euiTheme.colors.fullShade, 0.1), ";box-shadow:inset 0 0 0 ", euiTheme.border.width.thin, " ", transparentize(euiTheme.colors.emptyShade, 0.05), ";cursor:pointer;&:disabled{cursor:default;}&:focus{", euiOutline(euiThemeContext, 'center'), ";};label:euiColorPickerSwatch;")
  };
};