/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import { css } from '@emotion/react';
import { logicalCSS, logicalSizeCSS, mathWithUnits } from '../../global_styling';
export var euiSaturationStyles = function euiSaturationStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  var indicatorSize = euiTheme.size.m;
  var borderRadius = mathWithUnits(euiTheme.border.radius.medium, function (x) {
    return x / 2;
  });
  return {
    euiSaturation: /*#__PURE__*/css("z-index:3;position:relative;", logicalCSS('width', '100%'), " ", logicalCSS('padding-bottom', '100%'), " border-radius:", borderRadius, ";touch-action:none;&:focus,&:focus-within{outline:none;.euiSaturation__indicator{outline:none;box-shadow:0 0 0 ", euiTheme.focus.width, " ", euiTheme.colors.primary, ";border-color:", euiTheme.colors.primary, ";}};label:euiSaturation;"),
    euiSaturation__lightness: /*#__PURE__*/css("position:absolute;inset:0;", logicalCSS('top', '-1px'), "border-radius:", borderRadius, ";background:linear-gradient(\n        to right,\n        rgba(255, 255, 255, 1),\n        rgba(255, 255, 255, 0)\n      );;label:euiSaturation__lightness;"),
    euiSaturation__saturation: /*#__PURE__*/css("position:absolute;inset:0;", logicalCSS('top', '-1px'), "border-radius:", borderRadius, ";background:linear-gradient(to top, rgba(0, 0, 0, 1), rgba(0, 0, 0, 0));;label:euiSaturation__saturation;"),
    euiSaturation__indicator: /*#__PURE__*/css("position:absolute;", logicalSizeCSS(indicatorSize), " transform:translateX(-50%) translateY(-50%);border:", euiTheme.border.width.thin, " solid ", euiTheme.colors.darkestShade, ";border-radius:100%;&::before{content:'';position:absolute;inset:0;border-radius:100%;border:", euiTheme.border.width.thin, " solid ", euiTheme.colors.lightestShade, ";};label:euiSaturation__indicator;")
  };
};