var _excluded = ["children"],
  _excluded2 = ["key", "isGroupLabelOption", "label", "value", "prepend", "append", "truncationProps"],
  _excluded3 = ["data-test-subj", "activeOptionIndex", "areAllOptionsSelected", "customOptionText", "fullWidth", "getSelectedOptionForSearchValue", "isCaseSensitive", "isLoading", "listRef", "matchingOptions", "onCloseList", "onCreateOption", "onOptionClick", "onOptionEnterKey", "onScroll", "options", "renderOption", "rootId", "rowHeight", "scrollToIndex", "searchValue", "selectedOptions", "singleSelection", "delimiter", "truncationProps", "listboxAriaLabel"];
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { Component } from 'react';
import PropTypes from "prop-types";
import classNames from 'classnames';
import { FixedSizeList } from 'react-window';
import { RenderWithEuiStylesMemoizer } from '../../../services';
import { EuiFlexGroup, EuiFlexItem } from '../../flex';
import { EuiHighlight } from '../../highlight';
import { EuiMark } from '../../mark';
import { EuiText } from '../../text';
import { EuiLoadingSpinner } from '../../loading';
import { EuiI18n } from '../../i18n';
import { EuiFilterSelectItem } from '../../filter_group/filter_select_item';
import { EuiBadge } from '../../badge';
import { EuiTextTruncate } from '../../text_truncate';
import { EuiInputPopoverWidthContext } from '../../popover/input_popover';
import { EuiComboBoxOptionAppendPrepend } from '../utils';
import { EuiComboBoxTitle } from './combo_box_title';
import { euiComboBoxOptionListStyles, LIST_MAX_HEIGHT } from './combo_box_options_list.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
var hitEnterBadge = ___EmotionJSX(EuiBadge, {
  className: "euiComboBoxOption__enterBadge",
  color: "hollow",
  iconType: "returnKey",
  "aria-hidden": "true"
});
export var EuiComboBoxOptionsList = /*#__PURE__*/function (_Component) {
  function EuiComboBoxOptionsList() {
    var _this;
    _classCallCheck(this, EuiComboBoxOptionsList);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _callSuper(this, EuiComboBoxOptionsList, [].concat(args));
    _defineProperty(_this, "listRef", null);
    _defineProperty(_this, "setListRef", function (ref) {
      _this.listRef = ref;
    });
    _defineProperty(_this, "ListInnerElement", function (_ref) {
      var children = _ref.children,
        rest = _objectWithoutProperties(_ref, _excluded);
      return ___EmotionJSX("div", _extends({}, rest, {
        "aria-label": _this.props.listboxAriaLabel,
        id: _this.props.rootId('listbox'),
        role: "listbox",
        tabIndex: "0"
      }), children);
    });
    _defineProperty(_this, "ListRow", function (_ref2) {
      var _option$key;
      var data = _ref2.data,
        index = _ref2.index,
        style = _ref2.style;
      var option = data[index];
      var key = option.key,
        isGroupLabelOption = option.isGroupLabelOption,
        label = option.label,
        value = option.value,
        prepend = option.prepend,
        append = option.append,
        _truncationProps = option.truncationProps,
        rest = _objectWithoutProperties(option, _excluded2);
      var _this$props = _this.props,
        singleSelection = _this$props.singleSelection,
        selectedOptions = _this$props.selectedOptions,
        onOptionClick = _this$props.onOptionClick,
        activeOptionIndex = _this$props.activeOptionIndex,
        renderOption = _this$props.renderOption,
        searchValue = _this$props.searchValue,
        rootId = _this$props.rootId;
      var hasTruncationProps = _this.props.truncationProps || _truncationProps;
      var truncationProps = hasTruncationProps ? // Individual truncation settings should override component prop
      _objectSpread(_objectSpread({}, _this.props.truncationProps), _truncationProps) : undefined;
      if (isGroupLabelOption) {
        return ___EmotionJSX("div", {
          key: key !== null && key !== void 0 ? key : label,
          style: style
        }, ___EmotionJSX(EuiComboBoxTitle, null, prepend, label, append));
      }
      var checked = undefined;
      if (singleSelection && selectedOptions.length && selectedOptions[0].label === label && selectedOptions[0].key === key) {
        checked = 'on';
      }
      var optionIsFocused = activeOptionIndex === index;
      var optionIsDisabled = option.hasOwnProperty('disabled') && option.disabled === true;
      return ___EmotionJSX(EuiFilterSelectItem, _extends({
        style: style,
        key: (_option$key = option.key) !== null && _option$key !== void 0 ? _option$key : option.label,
        onClick: function onClick() {
          if (onOptionClick) {
            onOptionClick(option);
          }
        },
        isFocused: optionIsFocused,
        checked: checked,
        showIcons: singleSelection ? true : false,
        id: rootId("_option-".concat(index)),
        title: label
      }, rest), ___EmotionJSX("span", {
        className: "euiComboBoxOption__contentWrapper"
      }, ___EmotionJSX(EuiComboBoxOptionAppendPrepend, {
        option: option,
        classNamePrefix: "euiComboBoxOption",
        marginSize: "s"
      }, ___EmotionJSX("span", {
        className: "euiComboBoxOption__content"
      }, renderOption ? renderOption(option, searchValue, 'euiComboBoxOption__renderOption') : _this.renderTruncatedOption(label, truncationProps))), optionIsFocused && !optionIsDisabled ? hitEnterBadge : null));
    });
    _defineProperty(_this, "optionWidth", void 0);
    _defineProperty(_this, "setOptionWidth", function (width) {
      _this.optionWidth = width;
    });
    _defineProperty(_this, "renderTruncatedOption", function (text, truncationProps) {
      var searchValue = _this.props.searchValue.trim();
      if (!truncationProps && !searchValue) {
        // Default to CSS text-overflow
        return text;
      }
      if (!searchValue) {
        return ___EmotionJSX(EuiTextTruncate, _extends({
          width: _this.optionWidth,
          onResize: _this.setOptionWidth
        }, truncationProps, {
          text: text
        }), function (text) {
          return text;
        });
      }
      var searchPositionStart = _this.props.isCaseSensitive ? text.indexOf(searchValue) : text.toLowerCase().indexOf(searchValue.toLowerCase());
      var searchPositionCenter = searchPositionStart + Math.floor(searchValue.length / 2);
      return ___EmotionJSX(EuiTextTruncate, _extends({
        width: _this.optionWidth,
        onResize: _this.setOptionWidth
      }, truncationProps, {
        // When searching, don't allow overriding the truncation settings
        truncation: "startEnd",
        truncationPosition: searchPositionCenter,
        text: text
      }), function (text) {
        return ___EmotionJSX(React.Fragment, null, text.length >= searchValue.length ? ___EmotionJSX(EuiHighlight, {
          search: searchValue,
          strict: _this.props.isCaseSensitive
        }, text) :
        // If the available truncated text is shorter than the full search string,
        // just highlight the entire truncated text
        ___EmotionJSX(EuiMark, null, text));
      });
    });
    return _this;
  }
  _inherits(EuiComboBoxOptionsList, _Component);
  return _createClass(EuiComboBoxOptionsList, [{
    key: "componentDidUpdate",
    value: function componentDidUpdate(prevProps) {
      if (this.listRef && typeof this.props.activeOptionIndex !== 'undefined' && this.props.activeOptionIndex !== prevProps.activeOptionIndex) {
        this.listRef.scrollToItem(this.props.activeOptionIndex, 'auto');
      }
    }
  }, {
    key: "render",
    value: function render() {
      var _this2 = this;
      var _this$props2 = this.props,
        dataTestSubj = _this$props2['data-test-subj'],
        activeOptionIndex = _this$props2.activeOptionIndex,
        areAllOptionsSelected = _this$props2.areAllOptionsSelected,
        customOptionText = _this$props2.customOptionText,
        fullWidth = _this$props2.fullWidth,
        getSelectedOptionForSearchValue = _this$props2.getSelectedOptionForSearchValue,
        isCaseSensitive = _this$props2.isCaseSensitive,
        isLoading = _this$props2.isLoading,
        listRef = _this$props2.listRef,
        matchingOptions = _this$props2.matchingOptions,
        onCloseList = _this$props2.onCloseList,
        onCreateOption = _this$props2.onCreateOption,
        onOptionClick = _this$props2.onOptionClick,
        onOptionEnterKey = _this$props2.onOptionEnterKey,
        onScroll = _this$props2.onScroll,
        options = _this$props2.options,
        renderOption = _this$props2.renderOption,
        rootId = _this$props2.rootId,
        rowHeight = _this$props2.rowHeight,
        scrollToIndex = _this$props2.scrollToIndex,
        searchValue = _this$props2.searchValue,
        selectedOptions = _this$props2.selectedOptions,
        singleSelection = _this$props2.singleSelection,
        delimiter = _this$props2.delimiter,
        truncationProps = _this$props2.truncationProps,
        listboxAriaLabel = _this$props2.listboxAriaLabel,
        rest = _objectWithoutProperties(_this$props2, _excluded3);
      var emptyStateContent;
      if (isLoading) {
        emptyStateContent = ___EmotionJSX(EuiFlexGroup, {
          gutterSize: "s",
          justifyContent: "center",
          responsive: false
        }, ___EmotionJSX(EuiFlexItem, {
          grow: false
        }, ___EmotionJSX(EuiLoadingSpinner, {
          size: "m"
        })), ___EmotionJSX(EuiFlexItem, {
          grow: false
        }, ___EmotionJSX(EuiI18n, {
          token: "euiComboBoxOptionsList.loadingOptions",
          default: "Loading options"
        })));
      } else if (searchValue && matchingOptions && matchingOptions.length === 0) {
        if (onCreateOption && getSelectedOptionForSearchValue) {
          if (delimiter && searchValue.includes(delimiter)) {
            emptyStateContent = ___EmotionJSX("div", {
              className: "euiComboBoxOption__contentWrapper"
            }, ___EmotionJSX("p", {
              className: "euiComboBoxOption__emptyStateText"
            }, ___EmotionJSX(EuiI18n, {
              token: "euiComboBoxOptionsList.delimiterMessage",
              default: "Add each item separated by {delimiter}",
              values: {
                delimiter: ___EmotionJSX("strong", null, delimiter)
              }
            })), hitEnterBadge);
          } else {
            var selectedOptionForValue = getSelectedOptionForSearchValue({
              isCaseSensitive: isCaseSensitive,
              searchValue: searchValue,
              selectedOptions: selectedOptions
            });
            if (selectedOptionForValue) {
              // Disallow duplicate custom options.
              emptyStateContent = ___EmotionJSX("p", null, ___EmotionJSX(EuiI18n, {
                token: "euiComboBoxOptionsList.alreadyAdded",
                default: "{label} has already been added",
                values: {
                  label: ___EmotionJSX("strong", null, selectedOptionForValue.label)
                }
              }));
            } else {
              var highlightSearchValue = function highlightSearchValue(text, searchValue) {
                var reg = new RegExp(/(\{searchValue})/, 'gi');
                var parts = text.split(reg);
                return ___EmotionJSX("p", {
                  className: "euiComboBoxOption__emptyStateText"
                }, parts.map(function (part, idx) {
                  return part.match(reg) ? ___EmotionJSX("strong", {
                    key: idx
                  }, searchValue) : part;
                }));
              };
              emptyStateContent = ___EmotionJSX("div", {
                className: "euiComboBoxOption__contentWrapper"
              }, customOptionText ? highlightSearchValue(customOptionText, searchValue) : ___EmotionJSX("p", {
                className: "euiComboBoxOption__emptyStateText"
              }, ___EmotionJSX(EuiI18n, {
                token: "euiComboBoxOptionsList.createCustomOption",
                default: "Add {searchValue} as a custom option",
                values: {
                  searchValue: ___EmotionJSX("strong", null, searchValue)
                }
              })), hitEnterBadge);
            }
          }
        } else {
          emptyStateContent = ___EmotionJSX("p", null, ___EmotionJSX(EuiI18n, {
            token: "euiComboBoxOptionsList.noMatchingOptions",
            default: "{searchValue} doesn't match any options",
            values: {
              searchValue: ___EmotionJSX("strong", null, searchValue)
            }
          }));
        }
      } else if (!options.length) {
        emptyStateContent = ___EmotionJSX("p", null, ___EmotionJSX(EuiI18n, {
          token: "euiComboBoxOptionsList.noAvailableOptions",
          default: "There aren't any options available"
        }));
      } else if (areAllOptionsSelected) {
        emptyStateContent = ___EmotionJSX("p", null, ___EmotionJSX(EuiI18n, {
          token: "euiComboBoxOptionsList.allOptionsSelected",
          default: "You've selected all available options"
        }));
      }
      var numVisibleOptions = matchingOptions.length < 7 ? matchingOptions.length : 7;
      var height = numVisibleOptions * (rowHeight + 1); // Add one for the border

      // bounded by max-height of .euiComboBoxOptionsList
      var boundedHeight = height > LIST_MAX_HEIGHT ? LIST_MAX_HEIGHT : height;
      return ___EmotionJSX(RenderWithEuiStylesMemoizer, null, function (stylesMemoizer) {
        var styles = stylesMemoizer(euiComboBoxOptionListStyles);
        return ___EmotionJSX("div", _extends({
          css: styles.euiComboBoxOptionList,
          className: "euiComboBoxOptionsList",
          "data-test-subj": classNames('comboBoxOptionsList', dataTestSubj),
          ref: listRef
        }, rest), emptyStateContent ? ___EmotionJSX(EuiText, {
          size: "xs",
          css: styles.euiComboBoxOptionsList__empty,
          className: "euiComboBoxOptionsList__empty"
        }, emptyStateContent) : ___EmotionJSX(FixedSizeList, {
          css: styles.euiComboBoxOptionList__virtualization,
          className: "euiComboBoxOptionsList__virtualization",
          height: boundedHeight,
          onScroll: onScroll,
          itemCount: matchingOptions.length,
          itemSize: rowHeight,
          itemData: matchingOptions,
          ref: _this2.setListRef,
          innerElementType: _this2.ListInnerElement,
          width: _this2.context
        }, _this2.ListRow));
      });
    }
  }]);
}(Component);
_defineProperty(EuiComboBoxOptionsList, "contextType", EuiInputPopoverWidthContext);
_defineProperty(EuiComboBoxOptionsList, "defaultProps", {
  'data-test-subj': '',
  rowHeight: 29,
  // row height of default option renderer
  isCaseSensitive: false
});
EuiComboBoxOptionsList.propTypes = {
  className: PropTypes.string,
  "aria-label": PropTypes.string,
  "data-test-subj": PropTypes.string,
  css: PropTypes.any,
  activeOptionIndex: PropTypes.number,
  areAllOptionsSelected: PropTypes.bool,
  listboxAriaLabel: PropTypes.string.isRequired,
  /**
     * Creates a custom text option. You can use `{searchValue}` inside your string to better customize your text.
     * It won't show if there's no onCreateOption.
     */
  customOptionText: PropTypes.string,
  fullWidth: PropTypes.bool,
  getSelectedOptionForSearchValue: PropTypes.func,
  isCaseSensitive: PropTypes.bool,
  isLoading: PropTypes.bool,
  listRef: PropTypes.any.isRequired,
  matchingOptions: PropTypes.arrayOf(PropTypes.shape({
    isGroupLabelOption: PropTypes.bool,
    label: PropTypes.string.isRequired,
    key: PropTypes.string,
    options: PropTypes.arrayOf(PropTypes.shape({
      isGroupLabelOption: PropTypes.bool,
      label: PropTypes.string.isRequired,
      key: PropTypes.string,
      options: PropTypes.arrayOf(PropTypes.any.isRequired),
      value: PropTypes.any,
      prepend: PropTypes.node,
      append: PropTypes.node,
      truncationProps: PropTypes.any,
      /**
         * Optional custom tooltip content for the button
         */
      toolTipContent: PropTypes.node,
      /**
         * Optional props to pass to the underlying **[EuiToolTip](/#/display/tooltip)**
         */
      toolTipProps: PropTypes.any,
      className: PropTypes.string,
      "aria-label": PropTypes.string,
      "data-test-subj": PropTypes.string,
      css: PropTypes.any
    }).isRequired),
    value: PropTypes.any,
    prepend: PropTypes.node,
    append: PropTypes.node,
    truncationProps: PropTypes.any,
    /**
       * Optional custom tooltip content for the button
       */
    toolTipContent: PropTypes.node,
    /**
       * Optional props to pass to the underlying **[EuiToolTip](/#/display/tooltip)**
       */
    toolTipProps: PropTypes.any,
    className: PropTypes.string,
    "aria-label": PropTypes.string,
    "data-test-subj": PropTypes.string,
    css: PropTypes.any
  }).isRequired).isRequired,
  onCloseList: PropTypes.func.isRequired,
  onCreateOption: PropTypes.func,
  onOptionClick: PropTypes.func,
  onOptionEnterKey: PropTypes.func,
  onScroll: PropTypes.any,
  /**
     * Array of EuiComboBoxOptionOption objects. See #EuiComboBoxOptionOption
     */
  options: PropTypes.arrayOf(PropTypes.shape({
    isGroupLabelOption: PropTypes.bool,
    label: PropTypes.string.isRequired,
    key: PropTypes.string,
    options: PropTypes.arrayOf(PropTypes.shape({
      isGroupLabelOption: PropTypes.bool,
      label: PropTypes.string.isRequired,
      key: PropTypes.string,
      options: PropTypes.arrayOf(PropTypes.any.isRequired),
      value: PropTypes.any,
      prepend: PropTypes.node,
      append: PropTypes.node,
      truncationProps: PropTypes.any,
      toolTipContent: PropTypes.node,
      toolTipProps: PropTypes.any,
      className: PropTypes.string,
      "aria-label": PropTypes.string,
      "data-test-subj": PropTypes.string,
      css: PropTypes.any
    }).isRequired),
    value: PropTypes.any,
    prepend: PropTypes.node,
    append: PropTypes.node,
    truncationProps: PropTypes.any,
    toolTipContent: PropTypes.node,
    toolTipProps: PropTypes.any,
    className: PropTypes.string,
    "aria-label": PropTypes.string,
    "data-test-subj": PropTypes.string,
    css: PropTypes.any
  }).isRequired).isRequired,
  renderOption: PropTypes.func,
  rootId: PropTypes.any.isRequired,
  rowHeight: PropTypes.number.isRequired,
  scrollToIndex: PropTypes.number,
  searchValue: PropTypes.string.isRequired,
  selectedOptions: PropTypes.arrayOf(PropTypes.shape({
    isGroupLabelOption: PropTypes.bool,
    label: PropTypes.string.isRequired,
    key: PropTypes.string,
    options: PropTypes.arrayOf(PropTypes.shape({
      isGroupLabelOption: PropTypes.bool,
      label: PropTypes.string.isRequired,
      key: PropTypes.string,
      options: PropTypes.arrayOf(PropTypes.any.isRequired),
      value: PropTypes.any,
      prepend: PropTypes.node,
      append: PropTypes.node,
      truncationProps: PropTypes.any,
      toolTipContent: PropTypes.node,
      toolTipProps: PropTypes.any,
      className: PropTypes.string,
      "aria-label": PropTypes.string,
      "data-test-subj": PropTypes.string,
      css: PropTypes.any
    }).isRequired),
    value: PropTypes.any,
    prepend: PropTypes.node,
    append: PropTypes.node,
    truncationProps: PropTypes.any,
    toolTipContent: PropTypes.node,
    toolTipProps: PropTypes.any,
    className: PropTypes.string,
    "aria-label": PropTypes.string,
    "data-test-subj": PropTypes.string,
    css: PropTypes.any
  }).isRequired).isRequired,
  singleSelection: PropTypes.oneOfType([PropTypes.bool.isRequired, PropTypes.shape({
    asPlainText: PropTypes.bool
  }).isRequired]),
  delimiter: PropTypes.string,
  truncationProps: PropTypes.any
};