var _templateObject, _templateObject2, _templateObject3, _templateObject4;
function _taggedTemplateLiteral(e, t) { return t || (t = e.slice(0)), Object.freeze(Object.defineProperties(e, { raw: { value: Object.freeze(t) } })); }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import { css, keyframes } from '@emotion/react';
import { logicalCSS, euiCantAnimate } from '../../global_styling';
import { euiTitle } from '../title/title.styles';
import { euiContextMenuVariables } from './context_menu.styles';
export var euiContextMenuPanelStyles = function euiContextMenuPanelStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  var _euiContextMenuVariab = euiContextMenuVariables(euiThemeContext),
    panelWidth = _euiContextMenuVariab.panelWidth;
  var animations = {
    transitioning: /*#__PURE__*/css("pointer-events:none;animation-fill-mode:forwards;animation-duration:", euiTheme.animation.normal, ";animation-timing-function:", euiTheme.animation.resistance, ";", euiCantAnimate, "{animation-duration:0s;};label:transitioning;"),
    inLeft: keyframes(_templateObject || (_templateObject = _taggedTemplateLiteral(["\n      0% { transform: translateX(", "); }\n      100% { transform: translateX(0); }\n    "])), panelWidth),
    outLeft: keyframes(_templateObject2 || (_templateObject2 = _taggedTemplateLiteral(["\n      0% { transform: translateX(0); }\n      100% { transform: translateX(-", "); }\n    "])), panelWidth),
    inRight: keyframes(_templateObject3 || (_templateObject3 = _taggedTemplateLiteral(["\n      0% { transform: translateX(-", "); }\n      100% { transform: translateX(0); }\n    "])), panelWidth),
    outRight: keyframes(_templateObject4 || (_templateObject4 = _taggedTemplateLiteral(["\n      0% { transform: translateX(0); }\n      100% { transform: translateX(", "); }\n    "])), panelWidth)
  };
  return {
    euiContextMenuPanel: /*#__PURE__*/css(logicalCSS('width', '100%'), " visibility:visible;outline-offset:-", euiTheme.focus.width, ";&:focus{outline:none;};label:euiContextMenuPanel;"),
    // Panel animations
    next: {
      in: /*#__PURE__*/css(animations.transitioning, " animation-name:", animations.inLeft, ";;label:in;"),
      out: /*#__PURE__*/css(animations.transitioning, " animation-name:", animations.outLeft, ";;label:out;")
    },
    previous: {
      in: /*#__PURE__*/css(animations.transitioning, " animation-name:", animations.inRight, ";;label:in;"),
      out: /*#__PURE__*/css(animations.transitioning, " animation-name:", animations.outRight, ";;label:out;")
    },
    // Children
    euiContextMenuPanel__title: /*#__PURE__*/css(euiTitle(euiThemeContext, 'xxs'), " ", logicalCSS('border-bottom', euiTheme.border.thin), " &:enabled:focus{background-color:unset;};label:euiContextMenuPanel__title;")
  };
};