function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t.return && (u = t.return(), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/// <reference types="cypress" />
/// <reference types="cypress-real-events" />
/// <reference types="../../../cypress/support" />

import React, { useState } from 'react';
import { EuiButton } from '../button';
import { EuiCopy } from './copy';
import { EuiFormRow, EuiFieldText } from '../form';
import { EuiSpacer } from '../spacer';
import { jsx as ___EmotionJSX } from "@emotion/react";
var Copy = function Copy() {
  var _useState = useState('I am the text that will be copied'),
    _useState2 = _slicedToArray(_useState, 2),
    copyText = _useState2[0],
    setCopyText = _useState2[1];
  return ___EmotionJSX("div", null, ___EmotionJSX(EuiFormRow, {
    label: "Enter text that will be copied to clipboard"
  }, ___EmotionJSX(EuiFieldText, {
    value: copyText,
    onChange: function onChange(e) {
      return setCopyText(e.target.value);
    }
  })), ___EmotionJSX(EuiSpacer, {
    size: "m"
  }), ___EmotionJSX(EuiCopy, {
    textToCopy: copyText
  }, function (copy) {
    return ___EmotionJSX(EuiButton, {
      onClick: copy,
      "data-test-subj": "cy-copy-button"
    }, "Click to copy input text");
  }));
};
beforeEach(function () {
  cy.realMount(___EmotionJSX(Copy, null));
});
describe('EuiCopy', function () {
  describe('Automated accessibility check', function () {
    it('has zero violations on render', function () {
      cy.checkAxe();
    });
    it('has zero violations after the copy button is clicked', function () {
      cy.get('button[data-test-subj="cy-copy-button"]').realClick();
      cy.checkAxe();
    });
    it('has zero violations after keyboard interaction', function () {
      cy.repeatRealPress('Tab');
      cy.realPress('Enter');
      cy.checkAxe();
    });
  });
});