function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import { css } from '@emotion/react';
import { logicalCSS, logicalTextAlignCSS, mathWithUnits } from '../../../../global_styling';
export var euiDataGridCellOutlineStyles = function euiDataGridCellOutlineStyles(_ref2) {
  var euiTheme = _ref2.euiTheme;
  var focusColor = euiTheme.colors.primary;
  var hoverColor = euiTheme.colors.darkShade;
  var outlineWidth = euiTheme.border.width.thick;
  var borderRadius = mathWithUnits(euiTheme.border.radius.medium, function (x) {
    return x / 2;
  });

  // Note: We use a pseudo element for the 'outline' over any other CSS approaches
  // (outline, border, box-shadow) because it gives us the most control and reduces
  // overlap with other cells or inner elements
  return {
    borderRadius: borderRadius,
    focusColor: focusColor,
    focusStyles: "\n      /* Remove outline as we're handling it manually. Needed to override global styles */\n      &:focus-visible {\n        outline: none;\n      }\n\n      &::after {\n        content: '';\n        /* We want this to be visually on top of cell content but not interactive */\n        z-index: 2;\n        pointer-events: none;\n        position: absolute;\n        inset: 0;\n        border: ".concat(outlineWidth, " solid ").concat(focusColor, ";\n        border-radius: ").concat(borderRadius, ";\n      }\n    "),
    hoverColor: hoverColor,
    hoverStyles: "\n      &::after {\n        border-color: ".concat(hoverColor, ";\n      }\n    ")
  };
};
export var euiDataGridCellOutlineSelectors = function euiDataGridCellOutlineSelectors() {
  var parentSelector = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : '&';
  // Focus selectors
  var focus = ':focus'; // cell has been clicked or keyboard navigated to
  var isOpen = '.euiDataGridRowCell--open'; // always show when the cell expansion popover is open
  var isClosing = '[data-keyboard-closing]'; // prevents the animation from replaying when keyboard focus is moved from the popover back to the cell
  var isEntered = ':has([data-focus-lock-disabled="false"])'; // cell focus trap has been entered - ideally show the outline still, but grayed out

  // Hover selectors
  var hover = ':hover'; // hover styles should not supercede focus styles
  var focusWithin = ':focus-within'; // used by :hover:not() to prevent flash of gray when mouse users are opening/closing the expansion popover via cell action click

  // Cell header specific selectors
  var headerActionsOpen = '.euiDataGridHeaderCell--isActionsPopoverOpen';
  var isMoving = '[data-column-moving]'; // prevents the header column actions hover animation from replaying on column move

  // Utils
  var selectors = function selectors() {
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    return [].concat(args).join(', ');
  };
  var is = function is(selectors) {
    return "".concat(parentSelector, ":is(").concat(selectors, ")");
  };
  var not = function not(selectors) {
    return "".concat(parentSelector, ":not(").concat(selectors, ")");
  };
  var hoverNot = function hoverNot(selectors) {
    return "".concat(parentSelector, ":hover:not(").concat(selectors, ")");
  };
  var _ = function _(selectors) {
    return "".concat(parentSelector).concat(selectors);
  };
  return {
    outline: {
      show: is(selectors(hover, focus, isOpen, isEntered)),
      hover: hoverNot(selectors(focus, focusWithin, isOpen)),
      focusTrapped: _(isEntered)
    },
    actions: {
      hoverZone: hoverNot(selectors(focus, isOpen)),
      hoverColor: hoverNot(selectors(focus, focusWithin, isOpen)),
      showAnimation: is(selectors(hover, focus, isOpen, isClosing)),
      hoverAnimation: hoverNot(selectors(focus, isOpen, isClosing))
    },
    header: {
      focus: is(selectors(focus, focusWithin, headerActionsOpen, isMoving)),
      // :focus-within here is primarily intended for when the column actions button has been clicked twice
      focusTrapped: _(isEntered),
      showActions: is(selectors(hover, focusWithin, headerActionsOpen, isMoving)),
      hideActions: not(selectors(hover, focusWithin, headerActionsOpen, isMoving))
    }
  };
};
var _ref = process.env.NODE_ENV === "production" ? {
  name: "12y9ria-euiDataGridRowCell__content",
  styles: "overflow:hidden;label:euiDataGridRowCell__content;"
} : {
  name: "12y9ria-euiDataGridRowCell__content",
  styles: "overflow:hidden;label:euiDataGridRowCell__content;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
export var euiDataGridRowCellStyles = function euiDataGridRowCellStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  var cellOutline = euiDataGridCellOutlineStyles(euiThemeContext);
  var _euiDataGridCellOutli = euiDataGridCellOutlineSelectors(),
    outlineSelectors = _euiDataGridCellOutli.outline;
  return {
    euiDataGridRowCell: /*#__PURE__*/css("position:relative;", outlineSelectors.show, "{", cellOutline.focusStyles, ";}", outlineSelectors.hover, "{", cellOutline.hoverStyles, ";}", outlineSelectors.focusTrapped, "{", cellOutline.hoverStyles, ";}&>[data-focus-lock-disabled]{", logicalCSS('height', '100%'), ";}&:where(.euiDataGridRowCell--numeric, .euiDataGridRowCell--currency){", logicalTextAlignCSS('right'), ";}&:where(.euiDataGridRowCell--uppercase){text-transform:uppercase;}&:where(.euiDataGridRowCell--lowercase){text-transform:lowercase;}&:where(.euiDataGridRowCell--capitalize){text-transform:capitalize;};label:euiDataGridRowCell;"),
    content: {
      euiDataGridRowCell__content: _ref,
      autoHeight: /*#__PURE__*/css(logicalCSS('height', 'auto'), ";;label:autoHeight;"),
      defaultHeight: /*#__PURE__*/css(logicalCSS('height', '100%'), ";;label:defaultHeight;"),
      // Control columns should be vertically centered with the *first line* of text
      // for both single and multi-line heights (see https://github.com/elastic/eui/issues/7897)
      controlColumn: /*#__PURE__*/css(
      // ❗ For some reason Chromium browsers will scrollbar stutter without this :|||
      logicalCSS('max-height', '100%'), " display:inline-flex;align-items:start;gap:", euiTheme.size.xxs, ";vertical-align:-webkit-baseline-middle;vertical-align:-moz-middle-with-baseline;.euiDataGrid--fontSizeSmall &:where(.euiDataGridRowCell__content--defaultHeight){", logicalCSS('height', '100%'), " align-items:center;}.euiCheckbox:not(:has(label)){display:inline;.euiCheckbox__square{display:inline-flex;vertical-align:text-bottom;@supports (vertical-align: -moz-middle-with-baseline){vertical-align:sub;}}};label:controlColumn;")
    }
  };
};