/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import { css } from '@emotion/react';
import { logicalCSS } from '../../../../global_styling';
import { euiDataGridVariables } from '../../data_grid.styles';
export var euiDataGridFooterStyles = function euiDataGridFooterStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  var _euiDataGridVariables = euiDataGridVariables(euiThemeContext),
    levels = _euiDataGridVariables.levels;
  return {
    euiDataGridFooter: /*#__PURE__*/css("display:flex;", logicalCSS('width', 'fit-content'), " background-color:", euiTheme.colors.emptyShade, ";;label:euiDataGridFooter;"),
    sticky: /*#__PURE__*/css("z-index:", levels.stickyHeader, ";position:sticky;", logicalCSS('bottom', 0), ";;label:sticky;"),
    overline: /*#__PURE__*/css(logicalCSS('border-top', "".concat(euiTheme.border.width.thick, " solid ").concat(euiTheme.colors.text)), ";;label:overline;"),
    shade: /*#__PURE__*/css("background-color:", euiTheme.colors.lightestShade, ";;label:shade;"),
    striped: /*#__PURE__*/css(".euiDataGrid--stripes &{background-color:", euiTheme.colors.lightestShade, ";};label:striped;"),
    euiDataGridFooterCell: /*#__PURE__*/css("flex:0 0 auto;font-weight:", euiTheme.font.weight.bold, ";;label:euiDataGridFooterCell;")
  };
};