var _excluded = ["leadingControlColumns", "trailingControlColumns", "columns", "schema", "columnWidths", "defaultColumnWidth", "className", "renderCellValue", "renderCellPopover", "rowIndex", "interactiveCellId", "data-test-subj", "visibleRowIndex", "visibleColCount", "gridStyles"];
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { forwardRef, memo, useCallback, useContext } from 'react';
import classNames from 'classnames';
import { useEuiMemoizedStyles } from '../../../../services';
import { EuiDataGridCell, DataGridCellPopoverContext } from '../cell';
import { euiDataGridFooterStyles } from './data_grid_footer.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
var renderEmpty = function renderEmpty() {
  return null;
};
var EuiDataGridFooterRow = /*#__PURE__*/memo( /*#__PURE__*/forwardRef(function (_ref, ref) {
  var leadingControlColumns = _ref.leadingControlColumns,
    trailingControlColumns = _ref.trailingControlColumns,
    columns = _ref.columns,
    schema = _ref.schema,
    columnWidths = _ref.columnWidths,
    defaultColumnWidth = _ref.defaultColumnWidth,
    className = _ref.className,
    renderCellValue = _ref.renderCellValue,
    renderCellPopover = _ref.renderCellPopover,
    rowIndex = _ref.rowIndex,
    interactiveCellId = _ref.interactiveCellId,
    _dataTestSubj = _ref['data-test-subj'],
    _ref$visibleRowIndex = _ref.visibleRowIndex,
    visibleRowIndex = _ref$visibleRowIndex === void 0 ? rowIndex : _ref$visibleRowIndex,
    visibleColCount = _ref.visibleColCount,
    gridStyles = _ref.gridStyles,
    rest = _objectWithoutProperties(_ref, _excluded);
  var styles = useEuiMemoizedStyles(euiDataGridFooterStyles);
  var cssStyles = [styles.euiDataGridFooter, gridStyles.stickyFooter && styles.sticky, gridStyles.footer === 'striped' ? visibleRowIndex % 2 !== 0 && styles.striped : styles[gridStyles.footer]];
  var classes = classNames('euiDataGridFooter', className);
  var dataTestSubj = classNames('dataGridRow', 'dataGridFooterRow', _dataTestSubj);
  var getCellClasses = useCallback(function (columnIndex, classes) {
    return classNames('euiDataGridFooterCell', {
      'euiDataGridRowCell--firstColumn': columnIndex === 0,
      'euiDataGridRowCell--lastColumn': columnIndex === visibleColCount - 1
    }, classes);
  }, [visibleColCount]);
  var popoverContext = useContext(DataGridCellPopoverContext);
  var sharedCellProps = {
    css: styles.euiDataGridFooterCell,
    rowIndex: rowIndex,
    visibleRowIndex: visibleRowIndex,
    interactiveCellId: interactiveCellId,
    popoverContext: popoverContext,
    gridStyles: gridStyles
  };
  return ___EmotionJSX("div", _extends({
    ref: ref,
    role: "row",
    css: cssStyles,
    className: classes,
    "data-test-subj": dataTestSubj
  }, rest), leadingControlColumns.map(function (_ref2, i) {
    var id = _ref2.id,
      width = _ref2.width,
      footerCellRender = _ref2.footerCellRender,
      footerCellProps = _ref2.footerCellProps;
    return ___EmotionJSX(EuiDataGridCell, _extends({}, footerCellProps, sharedCellProps, {
      key: "".concat(id, "-").concat(rowIndex),
      colIndex: i,
      columnId: id,
      width: width,
      renderCellValue: footerCellRender !== null && footerCellRender !== void 0 ? footerCellRender : renderEmpty,
      isExpandable: false,
      className: getCellClasses(i, classNames('euiDataGridRowCell--controlColumn', footerCellProps === null || footerCellProps === void 0 ? void 0 : footerCellProps.className))
    }));
  }), columns.map(function (_ref3, i) {
    var id = _ref3.id;
    var columnType = schema[id] ? schema[id].columnType : null;
    var width = columnWidths[id] || defaultColumnWidth;
    var columnPosition = i + leadingControlColumns.length;
    return ___EmotionJSX(EuiDataGridCell, _extends({}, sharedCellProps, {
      key: "".concat(columnPosition, ",").concat(visibleRowIndex) // Note: this key should use cell position to match react-window/data cell behavior. See #5720
      ,
      colIndex: columnPosition,
      columnId: id,
      columnType: columnType,
      width: width || undefined,
      renderCellValue: renderCellValue,
      renderCellPopover: renderCellPopover,
      isExpandable: true,
      className: getCellClasses(columnPosition)
    }));
  }), trailingControlColumns.map(function (_ref4, i) {
    var id = _ref4.id,
      width = _ref4.width,
      footerCellRender = _ref4.footerCellRender,
      footerCellProps = _ref4.footerCellProps;
    var colIndex = i + columns.length + leadingControlColumns.length;
    return ___EmotionJSX(EuiDataGridCell, _extends({}, footerCellProps, sharedCellProps, {
      key: "".concat(id, "-").concat(rowIndex),
      colIndex: colIndex,
      columnId: id,
      width: width,
      renderCellValue: footerCellRender !== null && footerCellRender !== void 0 ? footerCellRender : renderEmpty,
      isExpandable: false,
      className: getCellClasses(colIndex, classNames('euiDataGridRowCell--controlColumn', footerCellProps === null || footerCellProps === void 0 ? void 0 : footerCellProps.className))
    }));
  }));
}));
EuiDataGridFooterRow.displayName = 'EuiDataGridFooterRow';
export { EuiDataGridFooterRow };