function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _toConsumableArray(r) { return _arrayWithoutHoles(r) || _iterableToArray(r) || _unsupportedIterableToArray(r) || _nonIterableSpread(); }
function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _iterableToArray(r) { if ("undefined" != typeof Symbol && null != r[Symbol.iterator] || null != r["@@iterator"]) return Array.from(r); }
function _arrayWithoutHoles(r) { if (Array.isArray(r)) return _arrayLikeToArray(r); }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t.return && (u = t.return(), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { useContext, useState, useMemo, useCallback, useRef, memo, useEffect } from 'react';
import PropTypes from "prop-types";
import { tabbable } from 'tabbable';
import { keys, useEuiMemoizedStyles } from '../../../../services';
// Keep the i18n scope the same as EuiDataGridHeaderCell
/* eslint-disable local/i18n */
import { EuiI18n, useEuiI18n } from '../../../i18n';
import { EuiPopover } from '../../../popover';
import { EuiListGroup } from '../../../list_group';
import { EuiButtonIcon } from '../../../button';
import { DataGridFocusContext } from '../../utils/focus';
import { getDetailsForSchema } from '../../utils/data_grid_schema';
import { defaultSortAscLabel, defaultSortDescLabel } from '../../controls/column_sorting_draggable';
import { euiDataGridHeaderCellStyles } from './data_grid_header_cell.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var useHasColumnActions = function useHasColumnActions(columnActions) {
  return useMemo(function () {
    // By default, all column actions are enabled
    if (columnActions === undefined) return true;
    if (columnActions === false) return false;
    if (columnActions.additional && columnActions.additional.length) return true;
    // Check if all (currently 5) default column actions have been manually disabled
    var disabledActions = Object.values(columnActions).filter(function (action) {
      return action === false;
    });
    return disabledActions.length < 5;
  }, [columnActions]);
};

// Props to pass back to EuiDataGridHeaderCell and set on EuiDataGridHeaderCellWrapper

export var ColumnActions = /*#__PURE__*/memo(function (_ref) {
  var index = _ref.index,
    id = _ref.id,
    title = _ref.title,
    column = _ref.column,
    columns = _ref.columns,
    schema = _ref.schema,
    schemaDetectors = _ref.schemaDetectors,
    setVisibleColumns = _ref.setVisibleColumns,
    switchColumnPos = _ref.switchColumnPos,
    sorting = _ref.sorting,
    hasFocusTrap = _ref.hasFocusTrap,
    setPropsFromColumnActions = _ref.setPropsFromColumnActions,
    actionsButtonRef = _ref.actionsButtonRef;
  /**
   * Popover logic and accessibility
   */
  var _useState = useState(false),
    _useState2 = _slicedToArray(_useState, 2),
    isPopoverOpen = _useState2[0],
    setIsPopoverOpen = _useState2[1];
  var togglePopover = useCallback(function () {
    setIsPopoverOpen(function (isOpen) {
      return !isOpen;
    });
  }, []);
  var closePopover = useCallback(function () {
    setIsPopoverOpen(false);
  }, []);
  var _useState3 = useState(false),
    _useState4 = _slicedToArray(_useState3, 2),
    isActionsButtonFocused = _useState4[0],
    setIsActionsButtonFocused = _useState4[1];
  var onFocus = useCallback(function () {
    return setIsActionsButtonFocused(true);
  }, []);
  var onBlur = useCallback(function () {
    return setIsActionsButtonFocused(false);
  }, []);
  var actionsButtonAriaLabel = useEuiI18n('euiDataGridHeaderCell.actionsButtonAriaLabel', '{title}. Click to view column header actions.', {
    title: title
  });
  var actionsEnterKeyInstructions = useEuiI18n('euiDataGridHeaderCell.actionsEnterKeyInstructions', "Press the Enter key to view this column's actions");
  var openActionsPopoverOnEnter = useCallback(function (e) {
    if (e.key === keys.ENTER) {
      setIsPopoverOpen(true);
    }
  }, []);
  var popoverArrowNavigationProps = usePopoverArrowNavigation();

  /**
   * Props to set on parent EuiDataGridHeaderCell
   */
  var _useState5 = useState(false),
    _useState6 = _slicedToArray(_useState5, 2),
    isColumnMoving = _useState6[0],
    setIsColumnMoving = _useState6[1];
  useEffect(function () {
    setPropsFromColumnActions({
      className: isPopoverOpen ? 'euiDataGridHeaderCell--isActionsPopoverOpen' : '',
      onKeyDown: openActionsPopoverOnEnter,
      'data-column-moving': isColumnMoving || undefined
    });
  }, [setPropsFromColumnActions, isPopoverOpen, openActionsPopoverOnEnter, isColumnMoving]);

  /**
   * Get column actions as an array of EuiListGroup items
   */
  var _useContext = useContext(DataGridFocusContext),
    setFocusedCell = _useContext.setFocusedCell,
    focusFirstVisibleInteractiveCell = _useContext.focusFirstVisibleInteractiveCell;
  var columnActions = useMemo(function () {
    return getColumnActions({
      column: column,
      columns: columns,
      schema: schema,
      schemaDetectors: schemaDetectors,
      setVisibleColumns: setVisibleColumns,
      focusFirstVisibleInteractiveCell: focusFirstVisibleInteractiveCell,
      sorting: sorting,
      switchColumnPos: switchColumnPos,
      setIsPopoverOpen: setIsPopoverOpen,
      setIsColumnMoving: setIsColumnMoving,
      setFocusedCell: setFocusedCell,
      columnFocusIndex: index
    });
  }, [column, columns, schema, schemaDetectors, setVisibleColumns, focusFirstVisibleInteractiveCell, sorting, switchColumnPos, setFocusedCell, index]);

  /**
   * Rendering
   */
  var styles = useEuiMemoizedStyles(euiDataGridHeaderCellStyles);
  return ___EmotionJSX(EuiPopover, _extends({
    display: "block",
    panelPaddingSize: "none",
    offset: 7,
    anchorPosition: "downRight",
    css: styles.euiDataGridHeaderCell__popover,
    button: ___EmotionJSX(EuiButtonIcon, {
      iconType: "boxesVertical",
      iconSize: "s",
      color: "text",
      css: styles.euiDataGridHeaderCell__actions,
      className: "euiDataGridHeaderCell__button",
      onClick: togglePopover,
      buttonRef: actionsButtonRef,
      onFocus: onFocus,
      onBlur: onBlur,
      tabIndex: 0 // Override EuiButtonIcon's conditional tabindex based on aria-hidden
      ,
      "aria-hidden": hasFocusTrap && !isActionsButtonFocused ? 'true' // prevent the actions button from being read on cell focus
      : undefined,
      "aria-label": hasFocusTrap ? actionsButtonAriaLabel : actionsEnterKeyInstructions,
      "data-test-subj": "dataGridHeaderCellActionButton-".concat(id)
    }),
    isOpen: isPopoverOpen,
    closePopover: closePopover
  }, popoverArrowNavigationProps), ___EmotionJSX(EuiListGroup, {
    listItems: columnActions,
    gutterSize: "none",
    "data-test-subj": "dataGridHeaderCellActionGroup-".concat(id)
  }));
});
ColumnActions.propTypes = {
  id: PropTypes.string.isRequired,
  title: PropTypes.string.isRequired,
  hasFocusTrap: PropTypes.bool.isRequired,
  setPropsFromColumnActions: PropTypes.func.isRequired,
  actionsButtonRef: PropTypes.any.isRequired
};
ColumnActions.displayName = 'EuiDataGridHeaderCellColumnActions';

/**
 * Add keyboard arrow navigation to the cell actions popover
 * to match the UX of the rest of EuiDataGrid
 */
export var usePopoverArrowNavigation = function usePopoverArrowNavigation() {
  var popoverPanelRef = useRef(null);
  var actionsRef = useRef(undefined);
  var panelRef = useCallback(function (ref) {
    popoverPanelRef.current = ref;
    actionsRef.current = ref ? tabbable(ref) : undefined;
  }, []);
  var onKeyDown = useCallback(function (e) {
    var _actionsRef$current;
    if (e.key !== keys.ARROW_DOWN && e.key !== keys.ARROW_UP) return;
    if (!((_actionsRef$current = actionsRef.current) !== null && _actionsRef$current !== void 0 && _actionsRef$current.length)) return;
    e.preventDefault();
    var initialState = document.activeElement === popoverPanelRef.current;
    var currentIndex = !initialState ? actionsRef.current.findIndex(function (el) {
      return document.activeElement === el;
    }) : -1;
    var lastIndex = actionsRef.current.length - 1;
    var indexToFocus;
    if (initialState) {
      if (e.key === keys.ARROW_DOWN) {
        indexToFocus = 0;
      } else if (e.key === keys.ARROW_UP) {
        indexToFocus = lastIndex;
      }
    } else {
      if (e.key === keys.ARROW_DOWN) {
        indexToFocus = currentIndex + 1;
        if (indexToFocus > lastIndex) {
          indexToFocus = 0;
        }
      } else if (e.key === keys.ARROW_UP) {
        indexToFocus = currentIndex - 1;
        if (indexToFocus < 0) {
          indexToFocus = lastIndex;
        }
      }
    }
    actionsRef.current[indexToFocus].focus();
  }, []);
  return {
    panelRef: panelRef,
    panelProps: {
      onKeyDown: onKeyDown
    },
    popoverScreenReaderText: ___EmotionJSX(EuiI18n, {
      token: "euiDataGridHeaderCell.actionsPopoverScreenReaderText",
      default: "To navigate through the list of column actions, press the Tab or Up and Down arrow keys."
    })
  };
};

/**
 * Logic for returning an array of actions/items to pass to EuiListGroup
 */

export var getColumnActions = function getColumnActions(_ref2) {
  var _column$actions;
  var column = _ref2.column,
    columns = _ref2.columns,
    schema = _ref2.schema,
    schemaDetectors = _ref2.schemaDetectors,
    setVisibleColumns = _ref2.setVisibleColumns,
    focusFirstVisibleInteractiveCell = _ref2.focusFirstVisibleInteractiveCell,
    setIsPopoverOpen = _ref2.setIsPopoverOpen,
    sorting = _ref2.sorting,
    switchColumnPos = _ref2.switchColumnPos,
    setIsColumnMoving = _ref2.setIsColumnMoving,
    setFocusedCell = _ref2.setFocusedCell,
    columnFocusIndex = _ref2.columnFocusIndex;
  if (column.actions === false) {
    return [];
  }
  var actions = [].concat(_toConsumableArray(getHideColumnAction({
    column: column,
    columns: columns,
    setVisibleColumns: setVisibleColumns,
    focusFirstVisibleInteractiveCell: focusFirstVisibleInteractiveCell
  })), _toConsumableArray(getSortColumnActions({
    column: column,
    sorting: sorting,
    schema: schema,
    schemaDetectors: schemaDetectors
  })), _toConsumableArray(getMoveColumnActions({
    column: column,
    columns: columns,
    switchColumnPos: switchColumnPos,
    setIsColumnMoving: setIsColumnMoving,
    setFocusedCell: setFocusedCell,
    columnFocusIndex: columnFocusIndex
  })), _toConsumableArray(((_column$actions = column.actions) === null || _column$actions === void 0 ? void 0 : _column$actions.additional) || []));
  return actions.map(function (action) {
    return _objectSpread(_objectSpread({}, action), {}, {
      // Wrap EuiListGroupItem onClick function to close the popover and prevent bubbling up
      onClick: function onClick(e) {
        e.stopPropagation();
        setIsPopoverOpen(false);
        if (action !== null && action !== void 0 && action.onClick) {
          action.onClick(e);
        }
      }
    });
  });
};

/**
 * Hide column action
 */

export var getHideColumnAction = function getHideColumnAction(_ref3) {
  var column = _ref3.column,
    columns = _ref3.columns,
    setVisibleColumns = _ref3.setVisibleColumns,
    focusFirstVisibleInteractiveCell = _ref3.focusFirstVisibleInteractiveCell;
  var items = [];
  var onClickHideColumn = function onClickHideColumn() {
    setVisibleColumns(columns.filter(function (col) {
      return col.id !== column.id;
    }).map(function (col) {
      return col.id;
    }));
    // Since we hid the current column, we need to manually set focus back onto the grid
    focusFirstVisibleInteractiveCell();
  };
  var action = {
    label: ___EmotionJSX(EuiI18n, {
      token: "euiColumnActions.hideColumn",
      default: "Hide column"
    }),
    onClick: onClickHideColumn,
    iconType: 'eyeClosed',
    size: 'xs',
    color: 'text'
  };
  if (isColumnActionEnabled('showHide', column.actions)) {
    items.push(getColumnActionConfig(action, 'showHide', column.actions));
  }
  return items;
};

/**
 * Move column actions
 */

var getMoveColumnActions = function getMoveColumnActions(_ref4) {
  var column = _ref4.column,
    columns = _ref4.columns,
    switchColumnPos = _ref4.switchColumnPos,
    setIsColumnMoving = _ref4.setIsColumnMoving,
    setFocusedCell = _ref4.setFocusedCell,
    columnFocusIndex = _ref4.columnFocusIndex;
  var items = [];
  var colIdx = columns.findIndex(function (col) {
    return col.id === column.id;
  });

  // UX polish: prevent the column actions hover animation from flashing after column move
  var handleAnimationFlash = function handleAnimationFlash() {
    setIsColumnMoving(true);
    requestAnimationFrame(function () {
      return setIsColumnMoving(false);
    });
  };
  var moveFocus = function moveFocus(direction) {
    var newIndex = direction === 'left' ? -1 : 1;
    // Wait a beat to move focus, otherwise the EuiPopover's EuiFocusTrap's
    // returnFocus logic sometimes steals it (depending on rerenders)
    setTimeout(function () {
      setFocusedCell([columnFocusIndex + newIndex, -1]); // -1 is the static y-index of the header
    });
  };
  if (isColumnActionEnabled('showMoveLeft', column.actions)) {
    var onClickMoveLeft = function onClickMoveLeft() {
      var targetCol = columns[colIdx - 1];
      if (targetCol) {
        switchColumnPos(column.id, targetCol.id);
        handleAnimationFlash();
        moveFocus('left');
      }
    };
    var action = {
      label: ___EmotionJSX(EuiI18n, {
        token: "euiColumnActions.moveLeft",
        default: "Move left"
      }),
      iconType: 'sortLeft',
      size: 'xs',
      color: 'text',
      onClick: onClickMoveLeft,
      isDisabled: colIdx === 0
    };
    items.push(getColumnActionConfig(action, 'showMoveLeft', column.actions));
  }
  if (isColumnActionEnabled('showMoveRight', column.actions)) {
    var onClickMoveRight = function onClickMoveRight() {
      var targetCol = columns[colIdx + 1];
      if (targetCol) {
        switchColumnPos(column.id, targetCol.id);
        handleAnimationFlash();
        moveFocus('right');
      }
    };
    var _action = {
      label: ___EmotionJSX(EuiI18n, {
        token: "euiColumnActions.moveRight",
        default: "Move right"
      }),
      iconType: 'sortRight',
      size: 'xs',
      color: 'text',
      onClick: onClickMoveRight,
      isDisabled: colIdx === columns.length - 1
    };
    items.push(getColumnActionConfig(_action, 'showMoveRight', column.actions));
  }
  return items;
};

/**
 * Sort column actions
 */

export var getSortColumnActions = function getSortColumnActions(_ref5) {
  var column = _ref5.column,
    sorting = _ref5.sorting,
    schema = _ref5.schema,
    schemaDetectors = _ref5.schemaDetectors;
  if (!sorting) return [];
  var items = [];
  var sortingIdx = sorting.columns.findIndex(function (col) {
    return col.id === column.id;
  });
  var schemaDetails = schema.hasOwnProperty(column.id) && schema[column.id].columnType != null ? getDetailsForSchema(schemaDetectors, schema[column.id].columnType) : null;
  var sortBy = function sortBy(direction) {
    var _sorting$columns$sort;
    if (sortingIdx >= 0 && ((_sorting$columns$sort = sorting.columns[sortingIdx]) === null || _sorting$columns$sort === void 0 ? void 0 : _sorting$columns$sort.direction) === direction) {
      // unsort if the same current and new direction are same
      var newColumns = sorting.columns.filter(function (_, idx) {
        return idx !== sortingIdx;
      });
      sorting.onSort(newColumns);
    } else if (sortingIdx >= 0) {
      // replace existing sort
      var _newColumns = Object.values(_objectSpread(_objectSpread({}, sorting.columns), {}, _defineProperty({}, sortingIdx, {
        id: column.id,
        direction: direction
      })));
      sorting.onSort(_newColumns);
    } else {
      // add new sort
      var _newColumns2 = [].concat(_toConsumableArray(sorting.columns), [{
        id: column.id,
        direction: direction
      }]);
      sorting.onSort(_newColumns2);
    }
  };
  if (isColumnActionEnabled('showSortAsc', column.actions)) {
    var label = schemaDetails ? schemaDetails.sortTextAsc : defaultSortAscLabel;
    var onClickSortAsc = function onClickSortAsc() {
      sortBy('asc');
    };
    var isSorted = sortingIdx >= 0 && sorting.columns[sortingIdx].direction === 'asc';
    var action = {
      label: isSorted ? ___EmotionJSX(EuiI18n, {
        token: "euiColumnActions.unsort",
        default: "Unsort {schemaLabel}",
        values: {
          schemaLabel: label
        }
      }) : ___EmotionJSX(EuiI18n, {
        token: "euiColumnActions.sort",
        default: "Sort {schemaLabel}",
        values: {
          schemaLabel: label
        }
      }),
      onClick: onClickSortAsc,
      isDisabled: column.isSortable === false,
      iconType: 'sortUp',
      size: 'xs',
      color: 'text'
    };
    items.push(getColumnActionConfig(action, 'showSortAsc', column.actions));
  }
  if (isColumnActionEnabled('showSortDesc', column.actions)) {
    var _label = schemaDetails ? schemaDetails.sortTextDesc : defaultSortDescLabel;
    var onClickSortDesc = function onClickSortDesc() {
      sortBy('desc');
    };
    var _isSorted = sortingIdx >= 0 && sorting.columns[sortingIdx].direction === 'desc';
    var _action2 = {
      label: _isSorted ? ___EmotionJSX(EuiI18n, {
        token: "euiColumnActions.unsort",
        default: "Unsort {schemaLabel}",
        values: {
          schemaLabel: _label
        }
      }) : ___EmotionJSX(EuiI18n, {
        token: "euiColumnActions.sort",
        default: "Sort {schemaLabel}",
        values: {
          schemaLabel: _label
        }
      }),
      onClick: onClickSortDesc,
      isDisabled: column.isSortable === false,
      iconType: 'sortDown',
      size: 'xs',
      color: 'text'
    };
    items.push(getColumnActionConfig(_action2, 'showSortDesc', column.actions));
  }
  return items;
};

/**
 * Column action utility helpers - mostly syntactical sugar for adding an extra
 * actions !== false checks, which we make an early return for in the main fn,
 * but that the individual utils don't know about and Typescript complains about
 */

// Check whether an action is enabled/should be appended to the actions array
export var isColumnActionEnabled = function isColumnActionEnabled(actionKey, actions) {
  if (actions === false) return false;
  if ((actions === null || actions === void 0 ? void 0 : actions[actionKey]) === false) return false;
  return true;
};

// Utility helper for appending any custom EuiDataGridColumnActions configuration to its action
export var getColumnActionConfig = function getColumnActionConfig(action, actionKey, actions) {
  var configuration = actions !== false && (actions === null || actions === void 0 ? void 0 : actions[actionKey]);
  return _typeof(configuration) === 'object' ? _objectSpread(_objectSpread({}, action), configuration) : action;
};