function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import { css } from '@emotion/react';
import { logicalCSS, mathWithUnits } from '../../../../global_styling';

// Resizer straddles the column border and is an invisible hitzone for dragging
var _ref = process.env.NODE_ENV === "production" ? {
  name: "1i9vv3a-isDragging",
  styles: "opacity:1;label:isDragging;"
} : {
  name: "1i9vv3a-isDragging",
  styles: "opacity:1;label:isDragging;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
export var euiDataGridColumnResizerStyles = function euiDataGridColumnResizerStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  var clickableWidth = euiTheme.size.base;
  var positionOffset = mathWithUnits(clickableWidth, function (x) {
    return x / -2;
  });
  var indicatorWidth = mathWithUnits([euiTheme.border.width.thin, euiTheme.border.width.thick], function (x, y) {
    return x + y;
  }); // Odd number because it straddles a border
  var indicatorOffset = "-".concat(euiTheme.border.width.thin);
  return {
    euiDataGridColumnResizer: /*#__PURE__*/css("z-index:2;position:absolute;", logicalCSS('vertical', 0), " ", logicalCSS('right', positionOffset), " cursor:ew-resize;opacity:0;&:hover,&:active{opacity:1;}&::after{content:'';position:absolute;", logicalCSS('vertical', 0), " ", logicalCSS('left', positionOffset), " ", logicalCSS('margin-left', indicatorOffset), " ", logicalCSS('width', indicatorWidth), " background-color:", euiTheme.colors.primary, ";};label:euiDataGridColumnResizer;"),
    /* Because the resizer sits in the negative space to the right of the column,
     * it can cause the full grid to be a few pixels longer than it actually is.
     * So for the last cell, we don't use negative positioning and the borders from
     * the cell will match the container. */
    isLastColumn: /*#__PURE__*/css(logicalCSS('right', 0), " ", logicalCSS('width', euiTheme.size.s), " &::after{", logicalCSS('left', 'auto'), " ", logicalCSS('right', 0), ";};label:isLastColumn;"),
    isDragging: _ref
  };
};