function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { memo } from 'react';
import PropTypes from "prop-types";
import classNames from 'classnames';
import { EuiDataGridHeaderCellWrapper } from './data_grid_header_cell_wrapper';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiDataGridControlHeaderCell = /*#__PURE__*/memo(function (_ref) {
  var controlColumn = _ref.controlColumn,
    index = _ref.index,
    isLastColumn = _ref.isLastColumn;
  var HeaderCellRender = controlColumn.headerCellRender,
    headerCellProps = controlColumn.headerCellProps,
    width = controlColumn.width,
    id = controlColumn.id;
  return ___EmotionJSX(EuiDataGridHeaderCellWrapper, _extends({}, headerCellProps, {
    className: classNames('euiDataGridHeaderCell--controlColumn', headerCellProps === null || headerCellProps === void 0 ? void 0 : headerCellProps.className),
    id: id,
    index: index,
    width: width,
    isLastColumn: isLastColumn
  }), ___EmotionJSX(HeaderCellRender, null));
});
EuiDataGridControlHeaderCell.propTypes = {
  index: PropTypes.number.isRequired,
  isLastColumn: PropTypes.bool.isRequired,
  controlColumn: PropTypes.shape({
    /**
       * Used as the React `key` when rendering content
       */
    id: PropTypes.string.isRequired,
    /**
       * Width of the column, users are unable to change this
       */
    width: PropTypes.number.isRequired,
    /**
       * Component to render in the column header
       */
    headerCellRender: PropTypes.elementType.isRequired,
    /**
       * Optional props to pass to the column header cell
       */
    headerCellProps: PropTypes.any,
    /**
       * Component to render for each row in the column
       */
    rowCellRender: PropTypes.oneOfType([PropTypes.func.isRequired, PropTypes.element.isRequired]).isRequired,
    /**
       * Component to render in the optional column footer
       */
    footerCellRender: PropTypes.oneOfType([PropTypes.func.isRequired, PropTypes.element.isRequired]),
    /**
       * Optional props to pass to the column footer cell
       */
    footerCellProps: PropTypes.any
  }).isRequired
};
EuiDataGridControlHeaderCell.displayName = 'EuiDataGridControlHeaderCell';