var _excluded = ["id", "index", "isLastColumn", "width", "className", "children", "hasColumnActions", "isDragging", "onKeyDown", "aria-label"];
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t.return && (u = t.return(), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { useContext, useEffect, useState, useCallback } from 'react';
import PropTypes from "prop-types";
import classnames from 'classnames';
import { keys, tabularCopyMarkers, useEuiMemoizedStyles } from '../../../../services';
import { DataGridFocusContext } from '../../utils/focus';
import { HandleInteractiveChildren } from '../cell/focus_utils';
import { euiDataGridHeaderCellWrapperStyles } from './data_grid_header_cell_wrapper.styles';

/**
 * This is a wrapper that handles repeated concerns between control &
 * standard header cells. Most of its shared logic is around focus state/UX,
 * but it also DRY's out certain class/data-test-subj/style attributes
 */
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiDataGridHeaderCellWrapper = function EuiDataGridHeaderCellWrapper(_ref) {
  var id = _ref.id,
    index = _ref.index,
    isLastColumn = _ref.isLastColumn,
    width = _ref.width,
    className = _ref.className,
    children = _ref.children,
    hasColumnActions = _ref.hasColumnActions,
    isDragging = _ref.isDragging,
    _onKeyDown = _ref.onKeyDown,
    ariaLabel = _ref['aria-label'],
    rest = _objectWithoutProperties(_ref, _excluded);
  var classes = classnames('euiDataGridHeaderCell', className);
  var styles = useEuiMemoizedStyles(euiDataGridHeaderCellWrapperStyles);

  // Must be a state and not a ref to trigger a HandleInteractiveChildren rerender
  var _useState = useState(null),
    _useState2 = _slicedToArray(_useState, 2),
    headerEl = _useState2[0],
    setHeaderEl = _useState2[1];
  var _useState3 = useState(false),
    _useState4 = _slicedToArray(_useState3, 2),
    renderFocusTrap = _useState4[0],
    setRenderFocusTrap = _useState4[1];
  var _useState5 = useState([]),
    _useState6 = _slicedToArray(_useState5, 2),
    interactiveChildren = _useState6[0],
    setInteractiveChildren = _useState6[1];
  useEffect(function () {
    // We're checking for interactive children outside of the default actions button
    setRenderFocusTrap(interactiveChildren.length > (hasColumnActions ? 1 : 0));
  }, [hasColumnActions, interactiveChildren]);
  var _useContext = useContext(DataGridFocusContext),
    setFocusedCell = _useContext.setFocusedCell,
    onFocusUpdate = _useContext.onFocusUpdate;
  var updateCellFocusContext = useCallback(function () {
    setFocusedCell([index, -1]);
  }, [index, setFocusedCell]);
  var _useState7 = useState(false),
    _useState8 = _slicedToArray(_useState7, 2),
    isFocused = _useState8[0],
    setIsFocused = _useState8[1];
  useEffect(function () {
    onFocusUpdate([index, -1], function (isFocused) {
      setIsFocused(isFocused);
      if (isFocused && headerEl) {
        // Only focus the cell if not already focused on something in the cell
        if (!headerEl.contains(document.activeElement)) {
          headerEl.focus();
        }
      }
    });
  }, [index, onFocusUpdate, headerEl]);
  var onKeyDown = useCallback(function (e) {
    // Ignore keys that conflict with the focus trap being entered/exited
    if (renderFocusTrap && (e.key === keys.ENTER || e.key === keys.ESCAPE)) {
      return;
    }
    // Otherwise, continue with whatever onKeyDown is being passed
    _onKeyDown === null || _onKeyDown === void 0 || _onKeyDown(e);
  }, [_onKeyDown, renderFocusTrap]);
  return ___EmotionJSX("div", _extends({
    role: "columnheader",
    ref: setHeaderEl,
    tabIndex: isFocused ? 0 : -1,
    onKeyDown: onKeyDown,
    css: styles.euiDataGridHeaderCell,
    className: classes,
    "data-test-subj": "dataGridHeaderCell-".concat(id),
    "data-gridcell-column-id": id,
    "data-gridcell-column-index": index,
    "data-gridcell-row-index": "-1",
    "data-gridcell-visible-row-index": "-1",
    style: width != null ? {
      width: "".concat(width, "px")
    } : {},
    "aria-label": renderFocusTrap ? ariaLabel : undefined
  }, rest), ___EmotionJSX(HandleInteractiveChildren, {
    cellEl: isDragging ? null : headerEl,
    renderFocusTrap: isDragging ? false : renderFocusTrap,
    updateCellFocusContext: updateCellFocusContext,
    onInteractiveChildrenFound: setInteractiveChildren
  }, typeof children === 'function' ? children(renderFocusTrap) : children), isLastColumn ? tabularCopyMarkers.hiddenNewline : tabularCopyMarkers.hiddenTab);
};
EuiDataGridHeaderCellWrapper.propTypes = {
  children: PropTypes.oneOfType([PropTypes.node.isRequired, PropTypes.func.isRequired]).isRequired,
  id: PropTypes.string.isRequired,
  index: PropTypes.number.isRequired,
  isLastColumn: PropTypes.bool.isRequired,
  width: PropTypes.oneOfType([PropTypes.number.isRequired, PropTypes.oneOf([null])]),
  className: PropTypes.string,
  "aria-label": PropTypes.any,
  hasColumnActions: PropTypes.bool,
  isDragging: PropTypes.bool,
  onKeyDown: PropTypes.any
};