/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import { css } from '@emotion/react';
import { logicalCSS } from '../../../../global_styling';
import { euiDataGridCellOutlineStyles, euiDataGridCellOutlineSelectors } from '../cell/data_grid_cell.styles';

/**
 * Styles that apply to both control and non-control columns
 */
export var euiDataGridHeaderCellWrapperStyles = function euiDataGridHeaderCellWrapperStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  var _euiDataGridCellOutli = euiDataGridCellOutlineStyles(euiThemeContext),
    focusStyles = _euiDataGridCellOutli.focusStyles,
    hoverStyles = _euiDataGridCellOutli.hoverStyles;
  var _euiDataGridCellOutli2 = euiDataGridCellOutlineSelectors(),
    outlineSelectors = _euiDataGridCellOutli2.header;
  return {
    euiDataGridHeaderCell: /*#__PURE__*/css("position:relative;display:flex;align-items:center;flex:0 0 auto;font-weight:", euiTheme.font.weight.bold, ";", outlineSelectors.focus, "{", focusStyles, ";}", outlineSelectors.focusTrapped, "{", hoverStyles, ";}", outlineSelectors.showActions, "{&,&>[data-focus-lock-disabled]{gap:", euiTheme.size.xxs, ";}}&>[data-focus-lock-disabled]{display:flex;align-items:center;", logicalCSS('width', '100%'), ";};label:euiDataGridHeaderCell;")
  };
};