/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import { css } from '@emotion/react';
import { logicalCSS } from '../../../../global_styling';
import { euiDataGridVariables } from '../../data_grid.styles';
export var euiDataGridHeaderStyles = function euiDataGridHeaderStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  var _euiDataGridVariables = euiDataGridVariables(euiThemeContext),
    levels = _euiDataGridVariables.levels;
  return {
    euiDataGridHeader: /*#__PURE__*/css("z-index:", levels.stickyHeader, ";position:sticky;", logicalCSS('top', 0), " ", logicalCSS('width', 'fit-content'), " display:flex;;label:euiDataGridHeader;"),
    underline: /*#__PURE__*/css("background-color:", euiTheme.colors.emptyShade, ";", logicalCSS('border-bottom', "".concat(euiTheme.border.width.thick, " solid ").concat(euiTheme.colors.text)), ";;label:underline;"),
    shade: /*#__PURE__*/css("background-color:", euiTheme.colors.lightestShade, ";;label:shade;")
  };
};