/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import { css } from '@emotion/react';
import { logicalCSS } from '../../../global_styling';
export var euiDataGridToolbarStyles = function euiDataGridToolbarStyles(_ref) {
  var euiTheme = _ref.euiTheme;
  return {
    euiDataGrid__controls: /*#__PURE__*/css("z-index:2;position:relative;display:flex;justify-content:space-between;align-items:center;gap:", euiTheme.size.base, ";", logicalCSS('padding-vertical', euiTheme.size.xs), " background-color:", euiTheme.colors.emptyShade, ";;label:euiDataGrid__controls;"),
    euiDataGrid__rightControls: /*#__PURE__*/css("display:flex;justify-content:flex-end;align-items:center;flex-wrap:wrap;column-gap:", euiTheme.size.s, ";", logicalCSS('padding-right', euiTheme.size.xs), "&:only-child{", logicalCSS('margin-left', 'auto'), ";};label:euiDataGrid__rightControls;"),
    euiDataGrid__leftControls: /*#__PURE__*/css("display:flex;flex-wrap:wrap;align-items:center;gap:", euiTheme.size.xxs, ";;label:euiDataGrid__leftControls;")
  };
};